/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb.packet;

import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.util.StringUtils;

public class DataPacketExtension
implements PacketExtension {
    public static final String ELEMENT_NAME = "data";
    private final String sessionID;
    private final long seq;
    private final String data;
    private byte[] decodedData;

    public DataPacketExtension(String sessionID, long seq, String data) {
        if (sessionID == null || "".equals(sessionID)) {
            throw new IllegalArgumentException("Session ID must not be null or empty");
        }
        if (seq < 0L || seq > 65535L) {
            throw new IllegalArgumentException("Sequence must not be between 0 and 65535");
        }
        if (data == null) {
            throw new IllegalArgumentException("Data must not be null");
        }
        this.sessionID = sessionID;
        this.seq = seq;
        this.data = data;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public long getSeq() {
        return this.seq;
    }

    public String getData() {
        return this.data;
    }

    public byte[] getDecodedData() {
        if (this.decodedData != null) {
            return this.decodedData;
        }
        if (this.data.matches(".*={1,2}+.+")) {
            return null;
        }
        this.decodedData = StringUtils.decodeBase64(this.data);
        return this.decodedData;
    }

    @Override
    public String getElementName() {
        return ELEMENT_NAME;
    }

    @Override
    public String getNamespace() {
        return "http://jabber.org/protocol/ibb";
    }

    @Override
    public String toXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<");
        buf.append(this.getElementName());
        buf.append(" ");
        buf.append("xmlns=\"");
        buf.append("http://jabber.org/protocol/ibb");
        buf.append("\" ");
        buf.append("seq=\"");
        buf.append(this.seq);
        buf.append("\" ");
        buf.append("sid=\"");
        buf.append(this.sessionID);
        buf.append("\">");
        buf.append(this.data);
        buf.append("</");
        buf.append(this.getElementName());
        buf.append(">");
        return buf.toString();
    }
}

