/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.nio.Bits;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.serialization.BinaryClassDefinition;
import com.hazelcast.nio.serialization.BinaryClassDefinitionProxy;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.ClassDefinitionImpl;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.MutableData;
import com.hazelcast.nio.serialization.PortableContext;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ClassDefinitionSerializer {
    private static final int CLASS_DEF_HEADER_SIZE = 16;
    private static final int ST_PREPARED = 1;
    private static final int ST_HEADER = 2;
    private static final int ST_DATA = 3;
    private static final int ST_SKIP_DATA = 4;
    private Data data;
    private PortableContext context;
    private byte status;
    private int classDefCount;
    private int classDefIndex;
    private ByteBuffer buffer;
    private ClassDefinition[] classDefinitions;
    private int classDefSize;
    private BinaryClassDefinition classDefProxy;
    private byte[] metadata;

    public ClassDefinitionSerializer(Data data, PortableContext context) {
        this.data = data;
        this.context = context;
    }

    public boolean write(ByteBuffer destination) {
        if (!this.isStatusSet(1)) {
            if (destination.remaining() < 4) {
                return false;
            }
            this.classDefinitions = this.context.getClassDefinitions(this.data);
            this.classDefCount = this.classDefinitions.length;
            destination.putInt(this.classDefCount);
            this.setStatus(1);
        }
        return this.writeAll(destination);
    }

    private boolean writeAll(ByteBuffer destination) {
        while (this.classDefIndex < this.classDefCount) {
            ClassDefinitionImpl cd = (ClassDefinitionImpl)this.classDefinitions[this.classDefIndex];
            if (!this.writeHeader(cd, destination)) {
                return false;
            }
            if (!this.writeData(cd, destination)) {
                return false;
            }
            this.clearStatus(2);
            this.clearStatus(3);
            ++this.classDefIndex;
        }
        return true;
    }

    private boolean writeHeader(ClassDefinitionImpl cd, ByteBuffer destination) {
        if (this.isStatusSet(2)) {
            return true;
        }
        if (destination.remaining() < 16) {
            return false;
        }
        destination.putInt(cd.getFactoryId());
        destination.putInt(cd.getClassId());
        destination.putInt(cd.getVersion());
        byte[] binary = cd.getBinary();
        destination.putInt(binary.length);
        this.setStatus(2);
        return true;
    }

    private boolean writeData(ClassDefinitionImpl cd, ByteBuffer destination) {
        if (this.isStatusSet(3)) {
            return true;
        }
        if (this.buffer == null) {
            this.buffer = ByteBuffer.wrap(cd.getBinary());
        }
        if (!this.flushBuffer(destination)) {
            return false;
        }
        this.buffer = null;
        this.setStatus(3);
        return true;
    }

    private boolean flushBuffer(ByteBuffer destination) {
        if (this.buffer.hasRemaining()) {
            IOUtil.copyToHeapBuffer(this.buffer, destination);
            if (this.buffer.hasRemaining()) {
                return false;
            }
        }
        return true;
    }

    public boolean read(ByteBuffer source) {
        if (!this.isStatusSet(1)) {
            if (source.remaining() < 4) {
                return false;
            }
            this.classDefCount = source.getInt();
            this.metadata = new byte[this.classDefCount * 12];
            ((MutableData)this.data).setHeader(this.metadata);
            this.setStatus(1);
        }
        return this.readAll(source);
    }

    private boolean readAll(ByteBuffer source) {
        while (this.classDefIndex < this.classDefCount) {
            if (!this.readHeader(source)) {
                return false;
            }
            if (!this.readData(source)) {
                return false;
            }
            this.clearStatus(2);
            this.clearStatus(3);
            ++this.classDefIndex;
        }
        return true;
    }

    private boolean readHeader(ByteBuffer source) {
        if (this.isStatusSet(2)) {
            return true;
        }
        if (source.remaining() < 16) {
            return false;
        }
        int factoryId = source.getInt();
        int classId = source.getInt();
        int version = source.getInt();
        this.classDefSize = source.getInt();
        boolean bigEndian = this.context.getByteOrder() == ByteOrder.BIG_ENDIAN;
        Bits.writeInt(this.metadata, this.classDefIndex * 12 + 0, factoryId, bigEndian);
        Bits.writeInt(this.metadata, this.classDefIndex * 12 + 4, classId, bigEndian);
        Bits.writeInt(this.metadata, this.classDefIndex * 12 + 8, version, bigEndian);
        ClassDefinition cd = this.context.lookupClassDefinition(factoryId, classId, version);
        if (cd == null) {
            this.classDefProxy = new BinaryClassDefinitionProxy(factoryId, classId, version);
            this.clearStatus(4);
        } else {
            this.setStatus(4);
        }
        this.setStatus(2);
        return true;
    }

    private boolean readData(ByteBuffer source) {
        if (this.isStatusSet(3)) {
            return true;
        }
        if (this.isStatusSet(4)) {
            int skip = Math.min(this.classDefSize, source.remaining());
            source.position(skip + source.position());
            this.classDefSize -= skip;
            if (this.classDefSize > 0) {
                return false;
            }
            this.clearStatus(4);
        } else {
            if (this.buffer == null) {
                this.buffer = ByteBuffer.allocate(this.classDefSize);
            }
            IOUtil.copyToHeapBuffer(source, this.buffer);
            if (this.buffer.hasRemaining()) {
                return false;
            }
            this.classDefProxy.setBinary(this.buffer.array());
            this.context.registerClassDefinition(this.classDefProxy);
            this.buffer = null;
            this.classDefProxy = null;
        }
        this.setStatus(3);
        return true;
    }

    private void setStatus(int bit) {
        this.status = Bits.setBit(this.status, bit);
    }

    private void clearStatus(int bit) {
        this.status = Bits.clearBit(this.status, bit);
    }

    private boolean isStatusSet(int bit) {
        return Bits.isBitSet(this.status, bit);
    }
}

