/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.operation;

import com.hazelcast.cache.impl.CacheClearResponse;
import com.hazelcast.cache.impl.ICacheRecordStore;
import com.hazelcast.cache.impl.ICacheService;
import com.hazelcast.cache.impl.operation.CacheClearBackupOperation;
import com.hazelcast.cache.impl.operation.PartitionWideCacheOperation;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import javax.cache.CacheException;

public class CacheClearOperation
extends PartitionWideCacheOperation
implements BackupAwareOperation {
    private transient ICacheRecordStore cache;

    public CacheClearOperation() {
    }

    public CacheClearOperation(String name) {
        super(name);
    }

    @Override
    public void beforeRun() throws Exception {
        ICacheService service = (ICacheService)this.getService();
        this.cache = service.getCacheRecordStore(this.name, this.getPartitionId());
    }

    @Override
    public void run() {
        if (this.cache == null) {
            return;
        }
        try {
            this.cache.clear();
            this.response = new CacheClearResponse(Boolean.TRUE);
        }
        catch (CacheException e) {
            this.response = new CacheClearResponse((Object)e);
        }
    }

    @Override
    public int getId() {
        return 15;
    }

    @Override
    public boolean shouldBackup() {
        return true;
    }

    @Override
    public final int getSyncBackupCount() {
        return this.cache != null ? this.cache.getConfig().getBackupCount() : 0;
    }

    @Override
    public final int getAsyncBackupCount() {
        return this.cache != null ? this.cache.getConfig().getAsyncBackupCount() : 0;
    }

    @Override
    public Operation getBackupOperation() {
        return new CacheClearBackupOperation(this.name);
    }
}

