/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.grammar.xmlschema;

import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionPool;
import com.sun.msv.grammar.NameClass;
import com.sun.msv.grammar.ReferenceExp;
import com.sun.msv.grammar.xmlschema.LaxDefaultNameClass;
import com.sun.msv.grammar.xmlschema.XMLSchemaGrammar;
import com.sun.msv.grammar.xmlschema.XMLSchemaSchema;
import java.util.Iterator;

public class AttributeWildcard {
    private NameClass name;
    private int processMode;
    public static final int SKIP = 0;
    public static final int LAX = 1;
    public static final int STRICT = 2;
    private static final long serialVersionUID = 1L;

    public AttributeWildcard(NameClass name, int processMode) {
        this.name = name;
        this.processMode = processMode;
    }

    public NameClass getName() {
        return this.name;
    }

    public int getProcessMode() {
        return this.processMode;
    }

    public AttributeWildcard copy() {
        return new AttributeWildcard(this.name, this.processMode);
    }

    public Expression createExpression(XMLSchemaGrammar grammar) {
        ExpressionPool pool = grammar.pool;
        switch (this.processMode) {
            case 0: {
                return pool.createZeroOrMore(pool.createAttribute(this.name));
            }
            case 1: 
            case 2: {
                Expression exp = Expression.epsilon;
                LaxDefaultNameClass laxNc = new LaxDefaultNameClass(this.name);
                Iterator itr = grammar.iterateSchemas();
                while (itr.hasNext()) {
                    XMLSchemaSchema schema = (XMLSchemaSchema)itr.next();
                    if (!this.name.accepts(schema.targetNamespace, "*")) continue;
                    ReferenceExp[] atts = schema.attributeDecls.getAll();
                    int i = 0;
                    while (i < atts.length) {
                        exp = pool.createSequence(pool.createOptional(atts[i]), exp);
                        laxNc.addName(schema.targetNamespace, atts[i].name);
                        ++i;
                    }
                }
                if (this.processMode == 2) {
                    return exp;
                }
                return pool.createSequence(pool.createZeroOrMore(pool.createAttribute(laxNc)), exp);
            }
        }
        throw new Error("undefined process mode:" + this.processMode);
    }

    static {
        SKIP = 0;
        LAX = 1;
        STRICT = 2;
        serialVersionUID = 1L;
    }
}

