/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvproto.getfile;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.rvproto.getfile.GetFileEntry;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class GetFileList
implements LiveWritable {
    public static final String GFLISTVERSION_DEFAULT = "Lst1";
    private final String gfListVersion;
    private final GetFileEntry[] files;

    public static GetFileList readGetFileList(ByteBlock byteBlock) {
        GetFileEntry getFileEntry;
        DefensiveTools.checkNull(byteBlock, "block");
        if (byteBlock.getLength() < 4) {
            return null;
        }
        String string = BinaryTools.getAsciiString(byteBlock.subBlock(0, 4));
        ByteBlock byteBlock2 = byteBlock.subBlock(4);
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(byteBlock2);
        Tlv[] tlvArray = immutableTlvChain.getTlvs();
        LinkedList<GetFileEntry> linkedList = new LinkedList<GetFileEntry>();
        for (int i = 0; i < tlvArray.length && (getFileEntry = GetFileEntry.readEntry(tlvArray, i)) != null; i += getFileEntry.getTotalTlvCount()) {
            linkedList.add(getFileEntry);
        }
        GetFileEntry[] getFileEntryArray = linkedList.toArray(new GetFileEntry[0]);
        return new GetFileList(string, getFileEntryArray);
    }

    public GetFileList(GetFileEntry[] getFileEntryArray) {
        this(GFLISTVERSION_DEFAULT, getFileEntryArray);
    }

    public GetFileList(String string, GetFileEntry[] getFileEntryArray) {
        DefensiveTools.checkNull(string, "gfListVersion");
        DefensiveTools.checkNull(getFileEntryArray, "files");
        this.gfListVersion = string;
        this.files = (GetFileEntry[])getFileEntryArray.clone();
        DefensiveTools.checkNullElements(this.files, "files");
    }

    public final String getGfListVersion() {
        return this.gfListVersion;
    }

    public final GetFileEntry[] getFileEntries() {
        return (GetFileEntry[])this.files.clone();
    }

    public final void write(OutputStream outputStream) throws IOException {
        outputStream.write(BinaryTools.getAsciiBytes(this.gfListVersion));
        for (int i = 0; i < this.files.length; ++i) {
            this.files[i].write(outputStream);
        }
    }

    public String toString() {
        return "GetFileList: version=" + this.gfListVersion + ", files=" + this.files.length;
    }
}

