/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.StringTokenizer;
import net.kano.joscar.DefensiveTools;

public final class SegmentedFilename {
    private static final String FILESEP_FT = "\u0001";
    private static final String FILESEP_NATIVE = System.getProperty("file.separator");
    private final String[] parts;

    private static SegmentedFilename createFromString(String string, String string2) {
        DefensiveTools.checkNull(string, "path");
        DefensiveTools.checkNull(string2, "separator");
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        LinkedList<String> linkedList = new LinkedList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            linkedList.add(string3);
        }
        return new SegmentedFilename(linkedList.toArray(new String[0]));
    }

    public static SegmentedFilename fromNativeFilename(String string) {
        return SegmentedFilename.createFromString(string, FILESEP_NATIVE);
    }

    public static SegmentedFilename fromFTFilename(String string) {
        return SegmentedFilename.createFromString(string, FILESEP_FT);
    }

    public SegmentedFilename(SegmentedFilename segmentedFilename, String string) {
        this(segmentedFilename, new SegmentedFilename(new String[]{string}));
    }

    public SegmentedFilename(SegmentedFilename segmentedFilename, SegmentedFilename segmentedFilename2) {
        DefensiveTools.checkNull(segmentedFilename2, "file");
        if (segmentedFilename == null) {
            this.parts = segmentedFilename2.parts;
        } else {
            this.parts = new String[segmentedFilename.parts.length + segmentedFilename2.parts.length];
            System.arraycopy(segmentedFilename.parts, 0, this.parts, 0, segmentedFilename.parts.length);
            System.arraycopy(segmentedFilename2.parts, 0, this.parts, segmentedFilename.parts.length, segmentedFilename2.parts.length);
        }
    }

    public SegmentedFilename(String[] stringArray) {
        DefensiveTools.checkNull(stringArray, "parts");
        this.parts = (String[])stringArray.clone();
        DefensiveTools.checkNullElements(this.parts, "parts");
    }

    public final String[] getSegments() {
        return (String[])this.parts.clone();
    }

    private final String toFilename(String string) {
        DefensiveTools.checkNull(string, "sep");
        StringBuffer stringBuffer = new StringBuffer(this.parts.length * 16);
        for (int i = 0; i < this.parts.length; ++i) {
            if (i != 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(this.parts[i]);
        }
        return stringBuffer.toString();
    }

    public final String toNativeFilename() {
        return this.toFilename(FILESEP_NATIVE);
    }

    public final String toFTFilename() {
        return this.toFilename(FILESEP_FT);
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.parts.length; ++i) {
            n ^= this.parts[i].hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SegmentedFilename)) {
            return false;
        }
        return Arrays.equals(this.parts, ((SegmentedFilename)object).parts);
    }

    public String toString() {
        return "SegmentedFilename: " + Arrays.asList(this.parts) + " (" + this.toNativeFilename() + ")";
    }
}

