/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.icbm.IcbmCommand;
import net.kano.joscar.snaccmd.icbm.MissedMsgInfo;

public class MissedMessagesCmd
extends IcbmCommand {
    private final MissedMsgInfo[] missedMsgInfos;

    protected MissedMessagesCmd(SnacPacket snacPacket) {
        super(10);
        MissedMsgInfo missedMsgInfo;
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        LinkedList<MissedMsgInfo> linkedList = new LinkedList<MissedMsgInfo>();
        while ((missedMsgInfo = MissedMsgInfo.readMissedMsgInfo(byteBlock)) != null) {
            linkedList.add(missedMsgInfo);
            byteBlock = byteBlock.subBlock(missedMsgInfo.getTotalSize());
        }
        this.missedMsgInfos = linkedList.toArray(new MissedMsgInfo[0]);
    }

    public MissedMessagesCmd(MissedMsgInfo[] missedMsgInfoArray) {
        super(10);
        this.missedMsgInfos = (MissedMsgInfo[])(missedMsgInfoArray == null ? null : missedMsgInfoArray.clone());
    }

    public final MissedMsgInfo[] getMissedMsgInfos() {
        return (MissedMsgInfo[])this.missedMsgInfos.clone();
    }

    public void writeData(OutputStream outputStream) throws IOException {
        if (this.missedMsgInfos != null) {
            for (int i = 0; i < this.missedMsgInfos.length; ++i) {
                this.missedMsgInfos[i].write(outputStream);
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MissedMessagesCmd: ");
        if (this.missedMsgInfos != null) {
            stringBuffer.append(this.missedMsgInfos.length);
            stringBuffer.append(" missed: ");
            for (int i = 0; i < this.missedMsgInfos.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.missedMsgInfos[i]);
            }
        }
        return stringBuffer.toString();
    }
}

