/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ExtraInfoBlock;
import net.kano.joscar.snaccmd.conn.ConnCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class SetExtraInfoCmd
extends ConnCommand {
    private static final int TYPE_DATA = 29;
    private ExtraInfoBlock[] blocks;

    protected SetExtraInfoCmd(SnacPacket snacPacket) {
        super(30);
        ByteBlock byteBlock = snacPacket.getData();
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(byteBlock);
        Tlv tlv = immutableTlvChain.getLastTlv(29);
        if (tlv != null) {
            ByteBlock byteBlock2 = tlv.getData();
            this.blocks = ExtraInfoBlock.readExtraInfoBlocks(byteBlock2);
        } else {
            this.blocks = null;
        }
    }

    public SetExtraInfoCmd(ExtraInfoBlock[] extraInfoBlockArray) {
        super(30);
        DefensiveTools.checkNull(extraInfoBlockArray, "blocks");
        extraInfoBlockArray = (ExtraInfoBlock[])extraInfoBlockArray.clone();
        DefensiveTools.checkNullElements(extraInfoBlockArray, "blocks");
        this.blocks = extraInfoBlockArray;
    }

    public final ExtraInfoBlock[] getInfoBlocks() {
        return (ExtraInfoBlock[])this.blocks.clone();
    }

    public void writeData(OutputStream outputStream) throws IOException {
        if (this.blocks != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            for (int i = 0; i < this.blocks.length; ++i) {
                this.blocks[i].write(byteArrayOutputStream);
            }
            new Tlv(29, ByteBlock.wrap(byteArrayOutputStream.toByteArray())).write(outputStream);
        }
    }

    public String toString() {
        return "SetExtraInfoCmd: blocks=" + (this.blocks == null ? null : Arrays.asList(this.blocks));
    }
}

