/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.zip;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.zip.ZipException;
import org.apache.tools.zip.ExtraFieldUtils;
import org.apache.tools.zip.ZipExtraField;
import org.apache.tools.zip.ZipShort;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ZipEntry
extends java.util.zip.ZipEntry
implements Cloneable {
    private static final int PLATFORM_UNIX = 3;
    private static final int PLATFORM_FAT = 0;
    private static Method setCompressedSizeMethod = null;
    private static Object lockReflection = new Object();
    private static boolean triedToGetMethod = false;
    private int internalAttributes;
    private int platform;
    private long externalAttributes;
    private Vector extraFields;
    private String name;
    private Long compressedSize;
    static /* synthetic */ Class class$java$util$zip$ZipEntry;

    public Object clone() {
        try {
            long l;
            long l2;
            ZipEntry zipEntry = (ZipEntry)super.clone();
            zipEntry.setName(this.getName());
            zipEntry.setComment(this.getComment());
            zipEntry.setMethod(this.getMethod());
            zipEntry.setTime(this.getTime());
            long l3 = this.getSize();
            if (l3 > 0L) {
                zipEntry.setSize(l3);
            }
            if ((l2 = this.getCompressedSize()) > 0L) {
                zipEntry.setComprSize(l2);
            }
            if ((l = this.getCrc()) > 0L) {
                zipEntry.setCrc(l);
            }
            zipEntry.extraFields = (Vector)this.extraFields.clone();
            zipEntry.setInternalAttributes(this.getInternalAttributes());
            zipEntry.setExternalAttributes(this.getExternalAttributes());
            zipEntry.setExtraFields(this.getExtraFields());
            return zipEntry;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public int getInternalAttributes() {
        return this.internalAttributes;
    }

    public void setInternalAttributes(int n) {
        this.internalAttributes = n;
    }

    public long getExternalAttributes() {
        return this.externalAttributes;
    }

    public void setExternalAttributes(long l) {
        this.externalAttributes = l;
    }

    public void setUnixMode(int n) {
        int n2 = 0;
        if ((n & 0x80) == 0) {
            n2 = 1;
        }
        this.setExternalAttributes(n << 16 | n2 | (this.isDirectory() ? 16 : 0));
        this.platform = 3;
    }

    public int getUnixMode() {
        return (int)(this.getExternalAttributes() >> 16 & 0xFFFFL);
    }

    public int getPlatform() {
        return this.platform;
    }

    protected void setPlatform(int n) {
        this.platform = n;
    }

    public void setExtraFields(ZipExtraField[] zipExtraFieldArray) {
        this.extraFields.removeAllElements();
        int n = 0;
        while (n < zipExtraFieldArray.length) {
            this.extraFields.addElement(zipExtraFieldArray[n]);
            ++n;
        }
        this.setExtra();
    }

    public ZipExtraField[] getExtraFields() {
        Object[] objectArray = new ZipExtraField[this.extraFields.size()];
        this.extraFields.copyInto(objectArray);
        return objectArray;
    }

    public void addExtraField(ZipExtraField zipExtraField) {
        ZipShort zipShort = zipExtraField.getHeaderId();
        boolean bl = false;
        int n = 0;
        while (!bl && n < this.extraFields.size()) {
            if (((ZipExtraField)this.extraFields.elementAt(n)).getHeaderId().equals(zipShort)) {
                this.extraFields.setElementAt(zipExtraField, n);
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            this.extraFields.addElement(zipExtraField);
        }
        this.setExtra();
    }

    public void removeExtraField(ZipShort zipShort) {
        boolean bl = false;
        int n = 0;
        while (!bl && n < this.extraFields.size()) {
            if (((ZipExtraField)this.extraFields.elementAt(n)).getHeaderId().equals(zipShort)) {
                this.extraFields.removeElementAt(n);
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            throw new NoSuchElementException();
        }
        this.setExtra();
    }

    public void setExtra(byte[] byArray) throws RuntimeException {
        try {
            this.setExtraFields(ExtraFieldUtils.parse(byArray));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    protected void setExtra() {
        super.setExtra(ExtraFieldUtils.mergeLocalFileDataData(this.getExtraFields()));
    }

    public byte[] getLocalFileDataExtra() {
        byte[] byArray = this.getExtra();
        return byArray != null ? byArray : new byte[]{};
    }

    public byte[] getCentralDirectoryExtra() {
        return ExtraFieldUtils.mergeCentralDirectoryData(this.getExtraFields());
    }

    public void setComprSize(long l) {
        if (ZipEntry.haveSetCompressedSize()) {
            ZipEntry.performSetCompressedSize(this, l);
        } else {
            this.compressedSize = new Long(l);
        }
    }

    public long getCompressedSize() {
        if (this.compressedSize != null) {
            return this.compressedSize;
        }
        return super.getCompressedSize();
    }

    public String getName() {
        return this.name == null ? super.getName() : this.name;
    }

    public boolean isDirectory() {
        return this.getName().endsWith("/");
    }

    protected void setName(String string) {
        this.name = string;
    }

    private static final boolean haveSetCompressedSize() {
        ZipEntry.checkSCS();
        boolean bl = false;
        if (setCompressedSizeMethod != null) {
            bl = true;
        }
        return bl;
    }

    private static final void performSetCompressedSize(ZipEntry zipEntry, long l) {
        Object[] objectArray = new Long[]{new Long(l)};
        try {
            setCompressedSizeMethod.invoke((Object)zipEntry, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            throw new RuntimeException("Exception setting the compressed size of " + zipEntry + ": " + throwable.getMessage());
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Exception setting the compressed size of " + zipEntry + ": " + throwable.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void checkSCS() {
        if (triedToGetMethod) return;
        Object object = lockReflection;
        synchronized (object) {
            triedToGetMethod = true;
            try {
                Class clazz = class$java$util$zip$ZipEntry;
                if (clazz == null) {
                    clazz = class$java$util$zip$ZipEntry = ZipEntry.class("[Ljava.util.zip.ZipEntry;", false);
                }
                setCompressedSizeMethod = clazz.getMethod("setCompressedSize", Long.TYPE);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            return;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.internalAttributes = 0;
        this.platform = 0;
        this.externalAttributes = 0L;
        this.extraFields = new Vector();
        this.name = null;
        this.compressedSize = null;
    }

    public ZipEntry(String string) {
        super(string);
        this.this();
    }

    public ZipEntry(java.util.zip.ZipEntry zipEntry) throws ZipException {
        super(zipEntry.getName());
        byte[] byArray;
        long l;
        long l2;
        this.this();
        this.setComment(zipEntry.getComment());
        this.setMethod(zipEntry.getMethod());
        this.setTime(zipEntry.getTime());
        long l3 = zipEntry.getSize();
        if (l3 > 0L) {
            this.setSize(l3);
        }
        if ((l2 = zipEntry.getCompressedSize()) > 0L) {
            this.setComprSize(l2);
        }
        if ((l = zipEntry.getCrc()) > 0L) {
            this.setCrc(l);
        }
        if ((byArray = zipEntry.getExtra()) != null) {
            this.setExtraFields(ExtraFieldUtils.parse(byArray));
        } else {
            this.setExtra();
        }
    }

    public ZipEntry(ZipEntry zipEntry) throws ZipException {
        this((java.util.zip.ZipEntry)zipEntry);
        this.setInternalAttributes(zipEntry.getInternalAttributes());
        this.setExternalAttributes(zipEntry.getExternalAttributes());
        this.setExtraFields(zipEntry.getExtraFields());
    }

    protected ZipEntry() {
        super("");
        this.this();
    }
}

