/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.impl;

import java.util.ArrayList;
import java.util.Collection;
import net.sf.jml.DisplayPictureListener;
import net.sf.jml.MsnContact;
import net.sf.jml.MsnContactPending;
import net.sf.jml.MsnFileTransfer;
import net.sf.jml.MsnGroup;
import net.sf.jml.MsnList;
import net.sf.jml.MsnMessenger;
import net.sf.jml.MsnObject;
import net.sf.jml.MsnProtocol;
import net.sf.jml.MsnSwitchboard;
import net.sf.jml.event.MsnAdapter;
import net.sf.jml.event.MsnContactListListener;
import net.sf.jml.event.MsnEmailListener;
import net.sf.jml.event.MsnFileTransferListener;
import net.sf.jml.event.MsnMessageListener;
import net.sf.jml.event.MsnMessengerListener;
import net.sf.jml.event.MsnSwitchboardListener;
import net.sf.jml.exception.JmlException;
import net.sf.jml.message.MsnControlMessage;
import net.sf.jml.message.MsnDatacastMessage;
import net.sf.jml.message.MsnEmailActivityMessage;
import net.sf.jml.message.MsnEmailInitEmailData;
import net.sf.jml.message.MsnEmailInitMessage;
import net.sf.jml.message.MsnEmailNotifyMessage;
import net.sf.jml.message.MsnInstantMessage;
import net.sf.jml.message.MsnSystemMessage;
import net.sf.jml.message.MsnUnknownMessage;
import net.sf.jml.message.p2p.DisplayPictureDuelManager;
import net.sf.jml.message.p2p.DisplayPictureRetrieveWorker;
import net.sf.jml.message.p2p.FileTransferManager;
import net.sf.jml.message.p2p.MsnP2PMessage;
import net.sf.jml.protocol.MsnOutgoingMessage;
import net.sf.jml.util.CopyOnWriteCollection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessenger
implements MsnMessenger {
    private static final Log logger = LogFactory.getLog(AbstractMessenger.class);
    private Object attachment;
    private ArrayList<MsnContactPending> pendingList = new ArrayList(0);
    private boolean logIncoming;
    private boolean logOutgoing;
    private MsnProtocol[] supportedProtocol = MsnProtocol.getAllSupportedProtocol();
    private MsnProtocol actualMsnProtocol;
    private DisplayPictureDuelManager duelManager = new DisplayPictureDuelManager();
    private FileTransferManager filetransferManager = new FileTransferManager();
    private final Collection<MsnMessengerListener> messengerListeners = new CopyOnWriteCollection();
    private final Collection<MsnMessageListener> messageListeners = new CopyOnWriteCollection();
    private final Collection<MsnEmailListener> emailListeners = new CopyOnWriteCollection();
    private final Collection<MsnContactListListener> contactListListeners = new CopyOnWriteCollection();
    private final Collection<MsnSwitchboardListener> switchboardListeners = new CopyOnWriteCollection();
    private final Collection<MsnFileTransferListener> fileTransferListeners = new CopyOnWriteCollection();

    @Override
    public ArrayList<MsnContactPending> getPendingList() {
        return this.pendingList;
    }

    @Override
    public Object getAttachment() {
        return this.attachment;
    }

    @Override
    public void setAttachment(Object object) {
        this.attachment = object;
    }

    @Override
    public boolean isLogIncoming() {
        return this.logIncoming;
    }

    @Override
    public void setLogIncoming(boolean bl) {
        this.logIncoming = bl;
    }

    @Override
    public boolean isLogOutgoing() {
        return this.logOutgoing;
    }

    @Override
    public void setLogOutgoing(boolean bl) {
        this.logOutgoing = bl;
    }

    @Override
    public MsnProtocol[] getSupportedProtocol() {
        return this.supportedProtocol;
    }

    @Override
    public void setSupportedProtocol(MsnProtocol[] msnProtocolArray) {
        if (msnProtocolArray != null && msnProtocolArray.length > 0) {
            this.supportedProtocol = msnProtocolArray;
        }
    }

    @Override
    public MsnProtocol getActualMsnProtocol() {
        return this.actualMsnProtocol;
    }

    public void setActualMsnProtocol(MsnProtocol msnProtocol) {
        this.actualMsnProtocol = msnProtocol;
    }

    @Override
    public void send(MsnOutgoingMessage msnOutgoingMessage) {
        this.send(msnOutgoingMessage, false);
    }

    @Override
    public void retrieveDisplayPicture(MsnObject msnObject, DisplayPictureListener displayPictureListener) throws JmlException {
        if (msnObject == null) {
            throw new JmlException();
        }
        if (msnObject.getType() != 3 && msnObject.getType() != 2) {
            throw new JmlException();
        }
        DisplayPictureRetrieveWorker displayPictureRetrieveWorker = new DisplayPictureRetrieveWorker(this, msnObject, displayPictureListener);
        displayPictureRetrieveWorker.start();
    }

    @Override
    public DisplayPictureDuelManager getDisplayPictureDuelManager() {
        return this.duelManager;
    }

    @Override
    public FileTransferManager getFileTransferManager() {
        return this.filetransferManager;
    }

    @Override
    public void addListener(MsnAdapter msnAdapter) {
        this.addMessengerListener(msnAdapter);
        this.addMessageListener(msnAdapter);
        this.addContactListListener(msnAdapter);
        this.addSwitchboardListener(msnAdapter);
        this.addFileTransferListener(msnAdapter);
        this.addEmailListener(msnAdapter);
    }

    @Override
    public void removeListener(MsnAdapter msnAdapter) {
        this.removeMessengerListener(msnAdapter);
        this.removeMessageListener(msnAdapter);
        this.removeContactListListener(msnAdapter);
        this.removeSwitchboardListener(msnAdapter);
        this.removeFileTransferListener(msnAdapter);
        this.removeEmailListener(msnAdapter);
    }

    @Override
    public void addMessengerListener(MsnMessengerListener msnMessengerListener) {
        if (msnMessengerListener != null) {
            this.messengerListeners.add(msnMessengerListener);
        }
    }

    @Override
    public void removeMessengerListener(MsnMessengerListener msnMessengerListener) {
        if (msnMessengerListener != null) {
            this.messengerListeners.remove(msnMessengerListener);
        }
    }

    public void fireLoginCompleted() {
        for (MsnMessengerListener msnMessengerListener : this.messengerListeners) {
            msnMessengerListener.loginCompleted(this);
        }
    }

    public void fireLogout() {
        if (this.duelManager != null) {
            this.duelManager.stop();
        }
        for (MsnMessengerListener msnMessengerListener : this.messengerListeners) {
            msnMessengerListener.logout(this);
        }
    }

    public void fireExceptionCaught(Throwable throwable) {
        for (MsnMessengerListener msnMessengerListener : this.messengerListeners) {
            msnMessengerListener.exceptionCaught(this, throwable);
        }
    }

    @Override
    public void addMessageListener(MsnMessageListener msnMessageListener) {
        if (msnMessageListener != null) {
            this.messageListeners.add(msnMessageListener);
        }
    }

    @Override
    public void removeMessageListener(MsnMessageListener msnMessageListener) {
        if (msnMessageListener != null) {
            this.messageListeners.remove(msnMessageListener);
        }
    }

    public void fireInstantMessageReceived(MsnSwitchboard msnSwitchboard, MsnInstantMessage msnInstantMessage, MsnContact msnContact) {
        for (MsnMessageListener msnMessageListener : this.messageListeners) {
            msnMessageListener.instantMessageReceived(msnSwitchboard, msnInstantMessage, msnContact);
        }
    }

    public void fireOfflineMessageReceived(String string, String string2, String string3, MsnContact msnContact) {
        for (MsnMessageListener msnMessageListener : this.messageListeners) {
            msnMessageListener.offlineMessageReceived(string, string2, string3, msnContact);
        }
    }

    public void fireControlMessageReceived(MsnSwitchboard msnSwitchboard, MsnControlMessage msnControlMessage, MsnContact msnContact) {
        for (MsnMessageListener msnMessageListener : this.messageListeners) {
            msnMessageListener.controlMessageReceived(msnSwitchboard, msnControlMessage, msnContact);
        }
    }

    public void fireSystemMessageReceived(MsnSystemMessage msnSystemMessage) {
        for (MsnMessageListener msnMessageListener : this.messageListeners) {
            msnMessageListener.systemMessageReceived(this, msnSystemMessage);
        }
    }

    public void fireDatacastMessageReceived(MsnSwitchboard msnSwitchboard, MsnDatacastMessage msnDatacastMessage, MsnContact msnContact) {
        for (MsnMessageListener msnMessageListener : this.messageListeners) {
            msnMessageListener.datacastMessageReceived(msnSwitchboard, msnDatacastMessage, msnContact);
        }
    }

    public void fireUnknownMessageReceived(MsnSwitchboard msnSwitchboard, MsnUnknownMessage msnUnknownMessage, MsnContact msnContact) {
        for (MsnMessageListener msnMessageListener : this.messageListeners) {
            msnMessageListener.unknownMessageReceived(msnSwitchboard, msnUnknownMessage, msnContact);
        }
    }

    public void fireP2PMessageReceived(MsnSwitchboard msnSwitchboard, MsnP2PMessage msnP2PMessage, MsnContact msnContact) {
        for (MsnMessageListener msnMessageListener : this.messageListeners) {
            msnMessageListener.p2pMessageReceived(msnSwitchboard, msnP2PMessage, msnContact);
        }
    }

    @Override
    public void addEmailListener(MsnEmailListener msnEmailListener) {
        if (msnEmailListener != null) {
            this.emailListeners.add(msnEmailListener);
        }
    }

    @Override
    public void removeEmailListener(MsnEmailListener msnEmailListener) {
        if (msnEmailListener != null) {
            this.emailListeners.remove(msnEmailListener);
        }
    }

    public void fireInitialEmailNotificationReceived(MsnSwitchboard msnSwitchboard, MsnEmailInitMessage msnEmailInitMessage, MsnContact msnContact) {
        for (MsnEmailListener msnEmailListener : this.emailListeners) {
            msnEmailListener.initialEmailNotificationReceived(msnSwitchboard, msnEmailInitMessage, msnContact);
        }
    }

    public void fireInitialEmailDataReceived(MsnSwitchboard msnSwitchboard, MsnEmailInitEmailData msnEmailInitEmailData, MsnContact msnContact) {
        for (MsnEmailListener msnEmailListener : this.emailListeners) {
            msnEmailListener.initialEmailDataReceived(msnSwitchboard, msnEmailInitEmailData, msnContact);
        }
    }

    public void fireNewEmailNotificationReceived(MsnSwitchboard msnSwitchboard, MsnEmailNotifyMessage msnEmailNotifyMessage, MsnContact msnContact) {
        for (MsnEmailListener msnEmailListener : this.emailListeners) {
            msnEmailListener.newEmailNotificationReceived(msnSwitchboard, msnEmailNotifyMessage, msnContact);
        }
    }

    public void fireEmailActivityNotificationReceived(MsnSwitchboard msnSwitchboard, MsnEmailActivityMessage msnEmailActivityMessage, MsnContact msnContact) {
        for (MsnEmailListener msnEmailListener : this.emailListeners) {
            msnEmailListener.activityEmailNotificationReceived(msnSwitchboard, msnEmailActivityMessage, msnContact);
        }
    }

    @Override
    public void addContactListListener(MsnContactListListener msnContactListListener) {
        if (msnContactListListener != null) {
            this.contactListListeners.add(msnContactListListener);
        }
    }

    @Override
    public void removeContactListListener(MsnContactListListener msnContactListListener) {
        if (msnContactListListener != null) {
            this.contactListListeners.remove(msnContactListListener);
        }
    }

    public void fireContactListSyncCompleted() {
        for (MsnContactListListener msnContactListListener : this.contactListListeners) {
            msnContactListListener.contactListSyncCompleted(this);
        }
    }

    public void fireContactListInitCompleted() {
        for (MsnContactListListener msnContactListListener : this.contactListListeners) {
            msnContactListListener.contactListInitCompleted(this);
        }
    }

    public void fireContactStatusChanged(MsnContact msnContact) {
        for (MsnContactListListener msnContactListListener : this.contactListListeners) {
            msnContactListListener.contactStatusChanged(this, msnContact);
        }
    }

    public void fireOwnerStatusChanged() {
        for (MsnContactListListener msnContactListListener : this.contactListListeners) {
            msnContactListListener.ownerStatusChanged(this);
        }
    }

    public void fireOwnerDisplayNameChanged() {
        for (MsnContactListListener msnContactListListener : this.contactListListeners) {
            msnContactListListener.ownerDisplayNameChanged(this);
        }
    }

    public void fireContactPersonalMessageChanged(MsnContact msnContact) {
        for (MsnContactListListener msnContactListListener : this.contactListListeners) {
            msnContactListListener.contactPersonalMessageChanged(this, msnContact);
        }
    }

    public void fireContactAddedMe(MsnContact msnContact) {
        for (MsnContactListListener msnContactListListener : this.contactListListeners) {
            msnContactListListener.contactAddedMe((MsnMessenger)this, msnContact);
        }
    }

    public void fireContactAddedMe(MsnContactPending[] msnContactPendingArray) {
        for (MsnContactListListener msnContactListListener : this.contactListListeners) {
            msnContactListListener.contactAddedMe((MsnMessenger)this, msnContactPendingArray);
        }
    }

    public void fireContactRemovedMe(MsnContact msnContact) {
        for (MsnContactListListener msnContactListListener : this.contactListListeners) {
            msnContactListListener.contactRemovedMe(this, msnContact);
        }
    }

    public void fireContactAddCompleted(MsnContact msnContact, MsnList msnList) {
        for (MsnContactListListener msnContactListListener : this.contactListListeners) {
            msnContactListListener.contactAddCompleted(this, msnContact, msnList);
        }
    }

    public void fireContactAddInGroupCompleted(MsnContact msnContact, MsnGroup msnGroup) {
        logger.debug((Object)("fire contact add " + msnContact + " listeners: " + this.contactListListeners));
        for (MsnContactListListener msnContactListListener : this.contactListListeners) {
            msnContactListListener.contactAddInGroupCompleted(this, msnContact, msnGroup);
        }
    }

    public void fireContactRemoveCompleted(MsnContact msnContact, MsnList msnList) {
        for (MsnContactListListener msnContactListListener : this.contactListListeners) {
            msnContactListListener.contactRemoveCompleted(this, msnContact, msnList);
        }
    }

    public void fireContactRemoveFromGroupCompleted(MsnContact msnContact, MsnGroup msnGroup) {
        for (MsnContactListListener msnContactListListener : this.contactListListeners) {
            msnContactListListener.contactRemoveFromGroupCompleted(this, msnContact, msnGroup);
        }
    }

    public void fireGroupAddCompleted(MsnGroup msnGroup) {
        for (MsnContactListListener msnContactListListener : this.contactListListeners) {
            msnContactListListener.groupAddCompleted(this, msnGroup);
        }
    }

    public void fireGroupRemoveCompleted(MsnGroup msnGroup) {
        for (MsnContactListListener msnContactListListener : this.contactListListeners) {
            msnContactListListener.groupRemoveCompleted(this, msnGroup);
        }
    }

    @Override
    public void addSwitchboardListener(MsnSwitchboardListener msnSwitchboardListener) {
        if (msnSwitchboardListener != null) {
            this.switchboardListeners.add(msnSwitchboardListener);
        }
    }

    @Override
    public void removeSwitchboardListener(MsnSwitchboardListener msnSwitchboardListener) {
        if (msnSwitchboardListener != null) {
            this.switchboardListeners.remove(msnSwitchboardListener);
        }
    }

    public void fireSwitchboardStarted(MsnSwitchboard msnSwitchboard) {
        for (MsnSwitchboardListener msnSwitchboardListener : this.switchboardListeners) {
            msnSwitchboardListener.switchboardStarted(msnSwitchboard);
        }
    }

    public void fireSwitchboardClosed(MsnSwitchboard msnSwitchboard) {
        for (MsnSwitchboardListener msnSwitchboardListener : this.switchboardListeners) {
            msnSwitchboardListener.switchboardClosed(msnSwitchboard);
        }
    }

    public void fireContactJoinSwitchboard(MsnSwitchboard msnSwitchboard, MsnContact msnContact) {
        for (MsnSwitchboardListener msnSwitchboardListener : this.switchboardListeners) {
            msnSwitchboardListener.contactJoinSwitchboard(msnSwitchboard, msnContact);
        }
    }

    public void fireContactLeaveSwitchboard(MsnSwitchboard msnSwitchboard, MsnContact msnContact) {
        for (MsnSwitchboardListener msnSwitchboardListener : this.switchboardListeners) {
            msnSwitchboardListener.contactLeaveSwitchboard(msnSwitchboard, msnContact);
        }
    }

    @Override
    public void addFileTransferListener(MsnFileTransferListener msnFileTransferListener) {
        if (msnFileTransferListener != null) {
            this.fileTransferListeners.add(msnFileTransferListener);
        }
    }

    @Override
    public void removeFileTransferListener(MsnFileTransferListener msnFileTransferListener) {
        if (msnFileTransferListener != null) {
            this.fileTransferListeners.remove(msnFileTransferListener);
        }
    }

    public void fireFileTransferRequestReceived(MsnFileTransfer msnFileTransfer) {
        for (MsnFileTransferListener msnFileTransferListener : this.fileTransferListeners) {
            msnFileTransferListener.fileTransferRequestReceived(msnFileTransfer);
        }
    }

    public void fireFileTransferStarted(MsnFileTransfer msnFileTransfer) {
        for (MsnFileTransferListener msnFileTransferListener : this.fileTransferListeners) {
            msnFileTransferListener.fileTransferStarted(msnFileTransfer);
        }
    }

    public void fireFileTransferProcess(MsnFileTransfer msnFileTransfer) {
        for (MsnFileTransferListener msnFileTransferListener : this.fileTransferListeners) {
            msnFileTransferListener.fileTransferProcess(msnFileTransfer);
        }
    }

    public void fireFileTransferFinished(MsnFileTransfer msnFileTransfer) {
        for (MsnFileTransferListener msnFileTransferListener : this.fileTransferListeners) {
            msnFileTransferListener.fileTransferFinished(msnFileTransfer);
        }
    }
}

