package org.jivesoftware.messenger.plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

import javax.xml.parsers.SAXParserFactory;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.dom4j.io.SAXWriter;
import org.jivesoftware.util.Log;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

import com.sun.msv.reader.util.GrammarLoader;
import com.sun.msv.reader.util.IgnoreController;
import com.sun.msv.verifier.DocumentDeclaration;
import com.sun.msv.verifier.Verifier;

public class UserSchemaValidator {
    private Document doc;
    private String schema;
    
    public UserSchemaValidator(String usersFile, String schemaFile) throws MalformedURLException, DocumentException {
        URL usersURL = new File(usersFile).toURL();       
        URL schemaURL = this.getClass().getClassLoader().getResource(schemaFile);        
        
        SAXReader reader = new SAXReader();
        doc = reader.read(usersURL);
        schema = schemaURL.toExternalForm();
    }

    public boolean validate() {
        try {
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            saxFactory.setNamespaceAware(true);
            DocumentDeclaration docDeclaration = GrammarLoader.loadVGM(schema, new IgnoreController() {
                public void error(Locator[] locations,
                                  String message,
                                  Exception exception) {
                    Log.error("ERROR: " + message);
                }

                public void error(Locator[] locations, String message) {
                    Log.error("WARNING: " + message);
                }
            }, saxFactory);
        
            ValidatorErrorHandler validatorErrorHandler = new ValidatorErrorHandler();
            Verifier verifier = new Verifier(docDeclaration, validatorErrorHandler);

            SAXWriter writer = new SAXWriter((ContentHandler) verifier);
            writer.setErrorHandler(validatorErrorHandler);

            writer.write(doc);
            if (verifier.isValid()) {
                return true;
            } else {
                Log.error(doc.getName() + " is invalid.");
                return false;
            }
        } catch (Exception e) {
            Log.error(e);
            return false;
        }
    }
    
    private class ValidatorErrorHandler implements ErrorHandler {
        public void error(SAXParseException e) {
            Log.error("ERROR:" + e);
        }

        public void fatalError(SAXParseException e) {
            Log.error("Fatal:" + e);
        }

        public void warning(SAXParseException e) {
            Log.error("Warning:" + e);
        }
    }
}
