/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.impl.MapEntries;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.operation.WanEventHolder;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.Predicate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

abstract class AbstractMultipleEntryBackupOperation
extends MapOperation {
    protected MapEntries responses;
    protected EntryBackupProcessor backupProcessor;
    protected List<WanEventHolder> wanEventList = Collections.emptyList();

    public AbstractMultipleEntryBackupOperation() {
    }

    public AbstractMultipleEntryBackupOperation(String name, EntryBackupProcessor backupProcessor) {
        super(name);
        this.backupProcessor = backupProcessor;
    }

    protected Predicate getPredicate() {
        return null;
    }

    protected void setWanEventList(List<WanEventHolder> wanEventList) {
        assert (wanEventList != null);
        this.wanEventList = wanEventList;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.wanEventList.size());
        for (WanEventHolder wanEventHolder : this.wanEventList) {
            out.writeData(wanEventHolder.getKey());
            out.writeData(wanEventHolder.getValue());
            out.writeInt(wanEventHolder.getEventType().getType());
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        if (size > 0) {
            this.wanEventList = new ArrayList<WanEventHolder>(size);
            for (int i = 0; i < size; ++i) {
                Data key = in.readData();
                Data value = in.readData();
                EntryEventType entryEventType = EntryEventType.getByType(in.readInt());
                this.wanEventList.add(new WanEventHolder(key, value, entryEventType));
            }
        }
    }
}

