/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr.commands;

import f00f.net.irc.martyr.InCommand;
import f00f.net.irc.martyr.State;
import f00f.net.irc.martyr.clientstate.ClientState;
import f00f.net.irc.martyr.commands.AbstractCommand;
import f00f.net.irc.martyr.commands.CtcpNotice;
import f00f.net.irc.martyr.util.FullNick;

public class NoticeCommand
extends AbstractCommand {
    private FullNick from;
    private String dest;
    private String notice;

    public NoticeCommand() {
        this.from = null;
        this.dest = null;
        this.notice = null;
    }

    public NoticeCommand(String notice) {
        this.notice = notice;
    }

    public NoticeCommand(String dest, String notice) {
        this(null, dest, notice);
    }

    public NoticeCommand(FullNick dest, String notice) {
        this(dest.getNick(), notice);
    }

    public NoticeCommand(FullNick source, String dest, String notice) {
        this.from = source;
        this.dest = dest;
        this.notice = notice;
    }

    public State getState() {
        return State.UNKNOWN;
    }

    public InCommand parse(String prefix, String identifier, String params) {
        FullNick from = prefix == null || prefix.trim().length() == 0 ? null : new FullNick(prefix);
        String dest = this.getParameter(params, 0);
        String msg = this.getParameter(params, 1);
        if (CtcpNotice.isCtcpString(msg)) {
            return new CtcpNotice(from, dest, msg);
        }
        return new NoticeCommand(from, dest, msg);
    }

    public String getIrcIdentifier() {
        return "NOTICE";
    }

    public String renderParams() {
        if (this.dest != null) {
            return this.dest + " :" + this.notice;
        }
        return ":" + this.notice;
    }

    public FullNick getFrom() {
        return this.from;
    }

    public String getDest() {
        return this.dest;
    }

    public String getNotice() {
        return this.notice;
    }

    public boolean isPrivateToUs(ClientState state) {
        return state.getNick().equals(this.dest);
    }
}

