/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.scanner;

import java.io.IOException;
import weblogic.xml.babel.dtd.EntityTable;
import weblogic.xml.babel.scanner.DTDSpace;
import weblogic.xml.babel.scanner.EntityValue;
import weblogic.xml.babel.scanner.ExternalID;
import weblogic.xml.babel.scanner.Name;
import weblogic.xml.babel.scanner.ScannerException;
import weblogic.xml.babel.scanner.ScannerState;

final class EntityDeclaration {
    private ScannerState state;
    private Name name;
    private DTDSpace space;
    private EntityValue entityValue;
    private ExternalID externalID;
    private EntityTable parameterTable;
    private EntityTable internalTable;

    EntityDeclaration(ScannerState scannerState) {
        this.state = scannerState;
        this.name = new Name(scannerState);
        this.space = new DTDSpace(scannerState);
        this.entityValue = new EntityValue(scannerState);
        this.externalID = new ExternalID(scannerState);
    }

    public void read() throws IOException, ScannerException {
        this.space.read();
        this.internalTable = this.state.getInternalEntityTable();
        if (this.state.currentChar == '%') {
            this.state.pushToken(this.state.tokenFactory.createToken(53));
            this.state.read();
            this.space.checkedRead();
            this.name.read();
            String string = this.state.currentToken.text;
            this.space.checkedRead();
            this.readParsedEntityDefinition();
            String string2 = this.entityValue.getText();
            this.parameterTable = this.state.getParameterEntityTable();
            this.parameterTable.put(string, string2);
        } else {
            this.state.pushToken(this.state.tokenFactory.createToken(52));
            this.name.read();
            String string = this.state.currentToken.text;
            this.space.checkedRead();
            if (this.readEntityDefinition()) {
                this.internalTable = this.state.getInternalEntityTable();
                this.internalTable.put(string, this.entityValue.getText());
            }
        }
        this.state.skipSpace();
        this.state.expect('>');
        this.state.pushToken(this.state.tokenFactory.createToken(39));
    }

    private void readParsedEntityDefinition() throws IOException, ScannerException {
        if (this.state.currentChar == '\'' || this.state.currentChar == '\"') {
            this.entityValue.read();
            return;
        }
        if (this.externalID.read()) {
            return;
        }
        throw new ScannerException("Entity Declarations must have an EntityValue or ExternalID defined", this.state);
    }

    private boolean readEntityDefinition() throws IOException, ScannerException {
        if (this.state.currentChar == '\'' || this.state.currentChar == '\"') {
            this.entityValue.read();
            return true;
        }
        if (this.externalID.read()) {
            this.space.checkedRead();
            if (this.state.currentChar == 'N') {
                this.state.expect("NDATA");
                this.state.pushToken(this.state.tokenFactory.createToken(54));
                this.space.checkedRead();
                this.name.read();
            }
            return false;
        }
        throw new ScannerException("Entity Declarations must have an EntityValue or ExternalID defined", this.state);
    }
}

