/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.stats;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jitsi.videobridge.stats.BundleContextHolder2;
import org.jitsi.videobridge.stats.Statistics;
import org.jitsi.videobridge.stats.StatsTransport;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatsManager
extends BundleContextHolder2 {
    private final List<TimeInfo<Statistics>> statistics = new LinkedList<TimeInfo<Statistics>>();
    private Thread thread;
    private final List<TimeInfo<StatsTransport>> transports = new LinkedList<TimeInfo<StatsTransport>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatistics(Statistics statistics, long period) {
        if (statistics == null) {
            throw new NullPointerException("statistics");
        }
        if (period < 1L) {
            throw new IllegalArgumentException("period " + period);
        }
        Object object = this.getSyncRoot();
        synchronized (object) {
            this.statistics.add(new TimeInfo<Statistics>(statistics, period));
            this.startThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransport(StatsTransport transport, long period) {
        if (transport == null) {
            throw new NullPointerException("transport");
        }
        if (period < 1L) {
            throw new IllegalArgumentException("period " + period);
        }
        Object object = this.getSyncRoot();
        synchronized (object) {
            this.transports.add(new TimeInfo<StatsTransport>(transport, period));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Statistics> getStatistics() {
        List<Statistics> r;
        Object object = this.getSyncRoot();
        synchronized (object) {
            int count = this.statistics.size();
            if (count < 1) {
                r = Collections.emptyList();
            } else {
                r = new ArrayList(count);
                for (TimeInfo<Statistics> timeInfo : this.statistics) {
                    r.add((Statistics)timeInfo.o);
                }
            }
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatisticsCount() {
        Object object = this.getSyncRoot();
        synchronized (object) {
            return this.statistics.size();
        }
    }

    private Object getSyncRoot() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<StatsTransport> getTransports() {
        List<StatsTransport> r;
        Object object = this.getSyncRoot();
        synchronized (object) {
            int count = this.transports.size();
            if (count < 1) {
                r = Collections.emptyList();
            } else {
                r = new ArrayList(count);
                for (TimeInfo<StatsTransport> timeInfo : this.transports) {
                    r.add((StatsTransport)timeInfo.o);
                }
            }
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInThread() {
        Object object;
        Object syncRoot = this.getSyncRoot();
        try {
            Thread currentThread = Thread.currentThread();
            ArrayList<TimeInfo<Statistics>> statistics = new ArrayList<TimeInfo<Statistics>>();
            ArrayList<TimeInfo<Object>> transports = new ArrayList<TimeInfo<Object>>();
            while (true) {
                long timeout = 0L;
                Object object2 = syncRoot;
                synchronized (object2) {
                    long aTimeout;
                    long elapsed;
                    if (!currentThread.equals(this.thread)) {
                        break;
                    }
                    if (this.getBundleContext() == null) {
                        break;
                    }
                    if (this.statistics.isEmpty()) {
                        break;
                    }
                    long l = System.currentTimeMillis();
                    for (TimeInfo<Statistics> timeInfo : this.statistics) {
                        elapsed = l - timeInfo.lastInvocationTime;
                        if (elapsed < 0L) continue;
                        aTimeout = timeInfo.period - elapsed;
                        if (aTimeout > 0L) {
                            if (timeout <= aTimeout) continue;
                            timeout = aTimeout;
                            continue;
                        }
                        statistics.add(timeInfo);
                    }
                    if (!this.transports.isEmpty()) {
                        for (TimeInfo<Object> timeInfo : this.transports) {
                            elapsed = l - timeInfo.lastInvocationTime;
                            if (elapsed < 0L) continue;
                            aTimeout = timeInfo.period - elapsed;
                            if (aTimeout > 0L) {
                                if (timeout <= aTimeout) continue;
                                timeout = aTimeout;
                                continue;
                            }
                            transports.add(timeInfo);
                        }
                    }
                    if (statistics.isEmpty() && transports.isEmpty()) {
                        long elapsed2;
                        if (timeout < 1L) {
                            timeout = 1L;
                        }
                        if ((elapsed2 = System.currentTimeMillis() - l) < 0L) {
                            elapsed2 = 0L;
                        }
                        if (elapsed2 == 0L || elapsed2 < timeout) {
                            try {
                                syncRoot.wait(timeout - elapsed2);
                            }
                            catch (InterruptedException ex) {
                                // empty catch block
                            }
                        }
                        continue;
                    }
                }
                if (!statistics.isEmpty()) {
                    for (TimeInfo timeInfo : statistics) {
                        timeInfo.lastInvocationTime = System.currentTimeMillis();
                        try {
                            ((Statistics)timeInfo.o).generate();
                        }
                        catch (Throwable throwable) {
                            if (throwable instanceof InterruptedException) {
                                Thread.currentThread().interrupt();
                                continue;
                            }
                            if (!(throwable instanceof ThreadDeath)) continue;
                            throw (ThreadDeath)throwable;
                        }
                    }
                    statistics.clear();
                }
                if (transports.isEmpty()) continue;
                Collection<Statistics> ss = this.getStatistics();
                for (TimeInfo timeInfo : transports) {
                    timeInfo.lastInvocationTime = System.currentTimeMillis();
                    StatsTransport transport = (StatsTransport)timeInfo.o;
                    try {
                        for (Statistics s : ss) {
                            transport.publishStatistics(s);
                        }
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof InterruptedException) {
                            Thread.currentThread().interrupt();
                            continue;
                        }
                        if (!(throwable instanceof ThreadDeath)) continue;
                        throw (ThreadDeath)throwable;
                    }
                }
                transports.clear();
            }
            Object var18_26 = null;
            object = syncRoot;
        }
        catch (Throwable throwable) {
            Object var18_27 = null;
            Object object2 = syncRoot;
            synchronized (object2) {
                if (Thread.currentThread().equals(this.thread)) {
                    this.thread = null;
                    syncRoot.notify();
                }
            }
            throw throwable;
        }
        synchronized (object) {
            if (Thread.currentThread().equals(this.thread)) {
                this.thread = null;
                syncRoot.notify();
            }
        }
    }

    @Override
    void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        for (StatsTransport transport : this.getTransports()) {
            transport.start(bundleContext);
        }
        this.startThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void startThread() {
        Object syncRoot;
        Object object = syncRoot = this.getSyncRoot();
        synchronized (object) {
            if (this.thread == null) {
                if (this.getBundleContext() == null) return;
                if (this.getStatisticsCount() <= 0) return;
                Thread thread = new Thread(){

                    public void run() {
                        StatsManager.this.runInThread();
                    }
                };
                thread.setDaemon(true);
                thread.setName(StatsManager.class.getName());
                this.thread = thread;
                boolean started = false;
                try {
                    thread.start();
                    return;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (started) throw throwable;
                    if (!thread.equals(this.thread)) throw throwable;
                    this.thread = null;
                    throw throwable;
                }
            }
            syncRoot.notify();
            return;
        }
    }

    @Override
    void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
        this.stopThread();
        for (StatsTransport transport : this.getTransports()) {
            transport.stop(bundleContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopThread() {
        Object syncRoot;
        Object object = syncRoot = this.getSyncRoot();
        synchronized (object) {
            if (this.thread != null && (this.getBundleContext() == null || this.getStatisticsCount() < 1)) {
                this.thread = null;
                syncRoot.notify();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TimeInfo<T> {
        public long lastInvocationTime = System.currentTimeMillis();
        public T o;
        public final long period;

        public TimeInfo(T o, long period) {
            this.o = o;
            this.period = period;
        }
    }
}

