/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.stats;

import java.util.Collection;
import net.java.sip.communicator.util.Logger;
import org.jitsi.videobridge.pubsub.PubSubPublisher;
import org.jitsi.videobridge.pubsub.PubSubResponseListener;
import org.jitsi.videobridge.stats.Statistics;
import org.jitsi.videobridge.stats.StatsTransport;
import org.jitsi.videobridge.xmpp.ComponentImpl;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.XMPPError;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;

public class PubSubStatsTransport
extends StatsTransport
implements PubSubResponseListener {
    private static final Logger logger = Logger.getLogger(PubSubStatsTransport.class);
    private final String nodeName;
    private PubSubPublisher publisher;
    private final ServiceListener serviceListener = new ServiceListener(){

        public void serviceChanged(ServiceEvent ev) {
            PubSubStatsTransport.this.serviceChanged(ev);
        }
    };
    private final String serviceName;

    public PubSubStatsTransport(String serviceName, String nodeName) {
        this.serviceName = serviceName;
        this.nodeName = nodeName;
    }

    protected void bundleContextChanged(BundleContext oldValue, BundleContext newValue) {
        super.bundleContextChanged(oldValue, newValue);
        if (oldValue != null) {
            oldValue.removeServiceListener(this.serviceListener);
        }
        if (newValue != null) {
            newValue.addServiceListener(this.serviceListener);
        }
        this.initOrDispose(null);
    }

    private void dispose() {
        if (this.publisher != null) {
            this.publisher.removeResponseListener(this);
            PubSubPublisher.releasePubsubManager(this.publisher);
            this.publisher = null;
        }
    }

    private void init() {
        if (this.publisher == null) {
            this.publisher = PubSubPublisher.getPubsubManager(this.serviceName);
            this.publisher.addResponseListener(this);
            try {
                this.publisher.createNode(this.nodeName);
            }
            catch (Exception ex) {
                logger.error((Object)("Failed to create PubSub node: " + this.nodeName));
                this.dispose();
            }
        }
    }

    private void initOrDispose(ComponentImpl unregistering) {
        boolean dispose;
        boolean init;
        BundleContext bundleContext = this.getBundleContext();
        if (bundleContext == null) {
            init = false;
            dispose = true;
        } else {
            Collection components = ComponentImpl.getComponents((BundleContext)bundleContext);
            int componentCount = components.size();
            if (unregistering == null) {
                init = componentCount > 0;
                dispose = !init;
            } else {
                init = false;
                if (components.contains(unregistering)) {
                    --componentCount;
                }
                boolean bl = dispose = componentCount < 1;
            }
        }
        if (init) {
            this.init();
        } else if (dispose) {
            this.dispose();
        }
    }

    public void onCreateNodeResponse(PubSubResponseListener.Response response) {
        if (PubSubResponseListener.Response.FAIL.equals((Object)response)) {
            this.dispose();
        }
    }

    public void onPublishResponse(PubSubResponseListener.Response type, IQ iq) {
        if (PubSubResponseListener.Response.FAIL.equals((Object)type)) {
            PubSubPublisher publisher;
            XMPPError err = iq.getError();
            if (err != null && XMPPError.Type.CANCEL.equals((Object)err.getType()) && XMPPError.Condition.item_not_found.toString().equals(err.getCondition()) && (publisher = this.publisher) != null) {
                String nodeName = this.nodeName;
                try {
                    publisher.createNode(nodeName);
                    return;
                }
                catch (Exception ex) {
                    logger.error((Object)("Failed to re-create PubSub node: " + nodeName));
                }
            }
            this.dispose();
        }
    }

    public void publishStatistics(Statistics stats) {
        PubSubPublisher publisher = this.publisher;
        if (publisher != null) {
            try {
                publisher.publish(this.nodeName, (PacketExtension)Statistics.toXMPP(stats));
            }
            catch (Exception e) {
                logger.error((Object)("Failed to publish to PubSub node: " + this.nodeName));
                this.dispose();
            }
        }
    }

    private void serviceChanged(ServiceEvent ev) {
        BundleContext bundleContext;
        int type = ev.getType();
        if ((type == 1 || type == 4) && (bundleContext = this.getBundleContext()) != null) {
            Object service = null;
            try {
                service = bundleContext.getService(ev.getServiceReference());
            }
            catch (IllegalArgumentException ex) {
            }
            catch (IllegalStateException ex) {
            }
            catch (SecurityException ex) {
                // empty catch block
            }
            if (service instanceof ComponentImpl) {
                this.initOrDispose(type == 4 ? (ComponentImpl)service : null);
            }
        }
    }
}

