/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.colibri;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.impl.protocol.jabber.extensions.AbstractPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.RTPLevelRelayType;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.SourcePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.IceUdpTransportPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ParameterPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.PayloadTypePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RTPHdrExtPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.SourceGroupPacketExtension;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.util.Logger;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.XMPPError;

public class ColibriConferenceIQ
extends IQ {
    public static final String ELEMENT_NAME = "conference";
    public static final String ID_ATTR_NAME = "id";
    public static final String NAMESPACE = "http://jitsi.org/protocol/colibri";
    private static final Logger logger = Logger.getLogger(ColibriConferenceIQ.class);
    public static final int[] NO_SSRCS = new int[0];
    private final List<ChannelBundle> channelBundles = new LinkedList<ChannelBundle>();
    private final List<Content> contents = new LinkedList<Content>();
    private final List<Endpoint> endpoints = new LinkedList<Endpoint>();
    private String id;
    private Recording recording;
    private RTCPTerminationStrategy rtcpTerminationStrategy;
    private boolean gracefulShutdown;

    public static IQ createGracefulShutdownErrorResponse(IQ request) {
        XMPPError error = new XMPPError(XMPPError.Condition.service_unavailable);
        error.addExtension((PacketExtension)new GracefulShutdown());
        IQ result = IQ.createErrorResponse((IQ)request, (XMPPError)error);
        result.setType(IQ.Type.ERROR);
        result.setPacketID(request.getPacketID());
        result.setFrom(request.getTo());
        result.setTo(request.getFrom());
        result.setError(error);
        return result;
    }

    public boolean addChannelBundle(ChannelBundle channelBundle) {
        if (channelBundle == null) {
            throw new NullPointerException("channelBundle");
        }
        return this.channelBundles.contains(this.channelBundles) ? false : this.channelBundles.add(channelBundle);
    }

    public boolean addContent(Content content) {
        if (content == null) {
            throw new NullPointerException("content");
        }
        return this.contents.contains(content) ? false : this.contents.add(content);
    }

    public boolean addContent(String contentName) {
        return this.addContent(new Content(contentName));
    }

    public void addEndpoint(Endpoint endpoint) {
        this.endpoints.add(endpoint);
    }

    public List<ChannelBundle> getChannelBundles() {
        return Collections.unmodifiableList(this.channelBundles);
    }

    public ChannelBundle getChannelBundle(String bundleId) {
        if (bundleId == null) {
            return null;
        }
        for (ChannelBundle bundle : this.channelBundles) {
            if (!bundleId.equals(bundle.getId())) continue;
            return bundle;
        }
        return null;
    }

    public String getChildElementXML() {
        boolean hasChildren;
        StringBuilder xml = new StringBuilder();
        xml.append('<').append(ELEMENT_NAME);
        xml.append(" xmlns='").append(NAMESPACE).append('\'');
        String id = this.getID();
        if (id != null) {
            xml.append(' ').append(ID_ATTR_NAME).append("='").append(id).append('\'');
        }
        List<Content> contents = this.getContents();
        List<ChannelBundle> channelBundles = this.getChannelBundles();
        boolean bl = hasChildren = this.recording != null || this.rtcpTerminationStrategy != null || this.gracefulShutdown || contents.size() > 0 || channelBundles.size() > 0;
        if (!hasChildren) {
            xml.append(" />");
        } else {
            xml.append('>');
            for (Content content : contents) {
                content.toXML(xml);
            }
            for (ChannelBundle channelBundle : channelBundles) {
                channelBundle.toXML(xml);
            }
            if (this.recording != null) {
                this.recording.toXML(xml);
            }
            if (this.rtcpTerminationStrategy != null) {
                this.rtcpTerminationStrategy.toXML(xml);
            }
            if (this.gracefulShutdown) {
                xml.append(new GracefulShutdown().toXML());
            }
            xml.append("</").append(ELEMENT_NAME).append('>');
        }
        return xml.toString();
    }

    public Content getContent(String contentName) {
        for (Content content : this.getContents()) {
            if (!contentName.equals(content.getName())) continue;
            return content;
        }
        return null;
    }

    public List<Content> getContents() {
        return Collections.unmodifiableList(this.contents);
    }

    public List<Endpoint> getEndpoints() {
        return Collections.unmodifiableList(this.endpoints);
    }

    public String getID() {
        return this.id;
    }

    public Content getOrCreateContent(String contentName) {
        Content content = this.getContent(contentName);
        if (content == null) {
            content = new Content(contentName);
            this.addContent(content);
        }
        return content;
    }

    public Recording getRecording() {
        return this.recording;
    }

    public RTCPTerminationStrategy getRTCPTerminationStrategy() {
        return this.rtcpTerminationStrategy;
    }

    public boolean removeContent(Content content) {
        return this.contents.remove(content);
    }

    public void setID(String id) {
        this.id = id;
    }

    public void setRecording(Recording recording) {
        this.recording = recording;
    }

    public void setRTCPTerminationStrategy(RTCPTerminationStrategy rtcpTerminationStrategy) {
        this.rtcpTerminationStrategy = rtcpTerminationStrategy;
    }

    public void setGracefulShutdown(boolean isGracefulShutdown) {
        this.gracefulShutdown = isGracefulShutdown;
    }

    public boolean isGracefulShutdown() {
        return this.gracefulShutdown;
    }

    public static class SctpConnection
    extends ChannelCommon {
        public static final String ELEMENT_NAME = "sctpconnection";
        public static final String PORT_ATTR_NAME = "port";
        private int port = 5000;

        public SctpConnection() {
            super(ELEMENT_NAME);
        }

        public int getPort() {
            return this.port;
        }

        @Override
        protected boolean hasContent() {
            return false;
        }

        @Override
        protected void printAttributes(StringBuilder xml) {
            xml.append(' ').append(PORT_ATTR_NAME).append("='").append(this.getPort()).append('\'');
        }

        @Override
        protected void printContent(StringBuilder xml) {
        }

        public void setPort(int port) {
            this.port = port;
        }
    }

    public static class RTCPTerminationStrategy {
        public static final String ELEMENT_NAME = "rtcp-termination-strategy";
        public static final String NAME_ATTR_NAME = "name";
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void toXML(StringBuilder xml) {
            xml.append('<').append(ELEMENT_NAME);
            xml.append(' ').append(NAME_ATTR_NAME).append("='").append(this.name).append('\'');
            xml.append("/>");
        }
    }

    public static class GracefulShutdown
    extends AbstractPacketExtension {
        public static final String ELEMENT_NAME = "graceful-shutdown";
        public static final String NAMESPACE = "http://jitsi.org/protocol/colibri";

        public GracefulShutdown() {
            super("http://jitsi.org/protocol/colibri", ELEMENT_NAME);
        }
    }

    public static class Recording {
        public static final String ELEMENT_NAME = "recording";
        public static final String DIRECTORY_ATTR_NAME = "directory";
        public static final String STATE_ATTR_NAME = "state";
        public static final String TOKEN_ATTR_NAME = "token";
        private String directory;
        private boolean state;
        private String token;

        public Recording(boolean state) {
            this.state = state;
        }

        public Recording(boolean state, String token) {
            this(state);
            this.token = token;
        }

        public String getDirectory() {
            return this.directory;
        }

        public boolean getState() {
            return this.state;
        }

        public String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public void setDirectory(String directory) {
            this.directory = directory;
        }

        public void toXML(StringBuilder xml) {
            xml.append('<').append(ELEMENT_NAME);
            xml.append(' ').append(STATE_ATTR_NAME).append("='").append(this.state).append('\'');
            if (this.token != null) {
                xml.append(' ').append(TOKEN_ATTR_NAME).append("='").append(this.token).append('\'');
            }
            if (this.directory != null) {
                xml.append(' ').append(DIRECTORY_ATTR_NAME).append("='").append(this.directory).append('\'');
            }
            xml.append("/>");
        }
    }

    public static class Endpoint {
        public static final String DISPLAYNAME_ATTR_NAME = "displayname";
        public static final String ELEMENT_NAME = "endpoint";
        public static final String ID_ATTR_NAME = "id";
        private String displayName;
        private String id;

        public Endpoint(String id, String displayName) {
            this.id = id;
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getId() {
            return this.id;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    public static class Content {
        public static final String ELEMENT_NAME = "content";
        public static final String NAME_ATTR_NAME = "name";
        private final List<Channel> channels = new LinkedList<Channel>();
        private String name;
        private final List<SctpConnection> sctpConnections = new LinkedList<SctpConnection>();

        public Content() {
        }

        public Content(String name) {
            this.setName(name);
        }

        public boolean addChannel(Channel channel) {
            if (channel == null) {
                throw new NullPointerException("channel");
            }
            return this.channels.contains(channel) ? false : this.channels.add(channel);
        }

        public boolean addSctpConnection(SctpConnection conn) {
            if (conn == null) {
                throw new NullPointerException("Sctp connection");
            }
            return !this.sctpConnections.contains(conn) && this.sctpConnections.add(conn);
        }

        public Channel getChannel(int channelIndex) {
            return this.getChannels().get(channelIndex);
        }

        public Channel getChannel(String channelID) {
            for (Channel channel : this.getChannels()) {
                if (!channelID.equals(channel.getID())) continue;
                return channel;
            }
            return null;
        }

        public SctpConnection getSctpConnection(String connectionID) {
            for (SctpConnection conn : this.getSctpConnections()) {
                if (!connectionID.equals(conn.getID())) continue;
                return conn;
            }
            return null;
        }

        public int getChannelCount() {
            return this.getChannels().size();
        }

        public List<Channel> getChannels() {
            return Collections.unmodifiableList(this.channels);
        }

        public String getName() {
            return this.name;
        }

        public List<SctpConnection> getSctpConnections() {
            return Collections.unmodifiableList(this.sctpConnections);
        }

        public boolean removeChannel(Channel channel) {
            return this.channels.remove(channel);
        }

        public void setName(String name) {
            if (name == null) {
                throw new NullPointerException(NAME_ATTR_NAME);
            }
            this.name = name;
        }

        public void toXML(StringBuilder xml) {
            xml.append('<').append(ELEMENT_NAME);
            xml.append(' ').append(NAME_ATTR_NAME).append("='").append(this.getName()).append('\'');
            List<Channel> channels = this.getChannels();
            List<SctpConnection> connections = this.getSctpConnections();
            if (channels.size() == 0 && connections.size() == 0) {
                xml.append(" />");
            } else {
                xml.append('>');
                for (Channel channel : channels) {
                    channel.toXML(xml);
                }
                for (SctpConnection conn : connections) {
                    conn.toXML(xml);
                }
                xml.append("</").append(ELEMENT_NAME).append('>');
            }
        }

        public boolean removeSctpConnection(SctpConnection connection) {
            return this.sctpConnections.remove(connection);
        }
    }

    public static abstract class ChannelCommon {
        public static final String CHANNEL_BUNDLE_ID_ATTR_NAME = "channel-bundle-id";
        public static final String ENDPOINT_ATTR_NAME = "endpoint";
        public static final String EXPIRE_ATTR_NAME = "expire";
        public static final int EXPIRE_NOT_SPECIFIED = -1;
        public static final String ID_ATTR_NAME = "id";
        public static final String INITIATOR_ATTR_NAME = "initiator";
        private String channelBundleId = null;
        private String elementName;
        private String endpoint;
        private int expire = -1;
        private String id;
        private Boolean initiator;
        private IceUdpTransportPacketExtension transport;

        protected ChannelCommon(String elementName) {
            this.elementName = elementName;
        }

        public String getChannelBundleId() {
            return this.channelBundleId;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public int getExpire() {
            return this.expire;
        }

        public String getID() {
            return this.id;
        }

        public IceUdpTransportPacketExtension getTransport() {
            return this.transport;
        }

        protected abstract boolean hasContent();

        public Boolean isInitiator() {
            return this.initiator;
        }

        protected abstract void printAttributes(StringBuilder var1);

        protected abstract void printContent(StringBuilder var1);

        public void setChannelBundleId(String channelBundleId) {
            this.channelBundleId = channelBundleId;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public void setExpire(int expire) {
            if (expire != -1 && expire < 0) {
                throw new IllegalArgumentException(EXPIRE_ATTR_NAME);
            }
            this.expire = expire;
        }

        public void setID(String id) {
            this.id = id;
        }

        public void setInitiator(Boolean initiator) {
            this.initiator = initiator;
        }

        public void setTransport(IceUdpTransportPacketExtension transport) {
            this.transport = transport;
        }

        public void toXML(StringBuilder xml) {
            boolean hasTransport;
            String channelBundleId;
            Boolean initiator;
            String id;
            int expire;
            xml.append('<').append(this.elementName);
            String endpoint = this.getEndpoint();
            if (endpoint != null) {
                xml.append(' ').append(ENDPOINT_ATTR_NAME).append("='").append(endpoint).append('\'');
            }
            if ((expire = this.getExpire()) >= 0) {
                xml.append(' ').append(EXPIRE_ATTR_NAME).append("='").append(expire).append('\'');
            }
            if ((id = this.getID()) != null) {
                xml.append(' ').append("id").append("='").append(id).append('\'');
            }
            if ((initiator = this.isInitiator()) != null) {
                xml.append(' ').append(INITIATOR_ATTR_NAME).append("='").append(initiator).append('\'');
            }
            if ((channelBundleId = this.getChannelBundleId()) != null) {
                xml.append(' ').append(CHANNEL_BUNDLE_ID_ATTR_NAME).append("='").append(channelBundleId).append('\'');
            }
            this.printAttributes(xml);
            IceUdpTransportPacketExtension transport = this.getTransport();
            boolean bl = hasTransport = transport != null;
            if (hasTransport || this.hasContent()) {
                xml.append('>');
                if (this.hasContent()) {
                    this.printContent(xml);
                }
                if (hasTransport) {
                    xml.append(transport.toXML());
                }
                xml.append("</").append(this.elementName).append('>');
            } else {
                xml.append(" />");
            }
        }
    }

    public static class ChannelBundle {
        public static final String ELEMENT_NAME = "channel-bundle";
        public static final String ID_ATTR_NAME = "id";
        private String id;
        private IceUdpTransportPacketExtension transport;

        public ChannelBundle(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public IceUdpTransportPacketExtension getTransport() {
            return this.transport;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setTransport(IceUdpTransportPacketExtension transport) {
            this.transport = transport;
        }

        public void toXML(StringBuilder xml) {
            xml.append('<').append(ELEMENT_NAME).append(' ').append("id").append("='").append(this.id).append('\'');
            if (this.transport != null) {
                xml.append('>');
                xml.append(this.transport.toXML());
                xml.append("</").append(ELEMENT_NAME).append('>');
            } else {
                xml.append(" />");
            }
        }
    }

    public static class Channel
    extends ChannelCommon {
        public static final String DIRECTION_ATTR_NAME = "direction";
        public static final String ELEMENT_NAME = "channel";
        @Deprecated
        public static final String HOST_ATTR_NAME = "host";
        public static final String LAST_N_ATTR_NAME = "last-n";
        public static final String ADAPTIVE_LAST_N_ATTR_NAME = "adaptive-last-n";
        public static final String ADAPTIVE_SIMULCAST_ATTR_NAME = "adaptive-simulcast";
        public static final String RECEIVING_SIMULCAST_LAYER = "receive-simulcast-layer";
        @Deprecated
        public static final String RTCP_PORT_ATTR_NAME = "rtcpport";
        public static final String RTP_LEVEL_RELAY_TYPE_ATTR_NAME = "rtp-level-relay-type";
        @Deprecated
        public static final String RTP_PORT_ATTR_NAME = "rtpport";
        public static final String SSRC_ELEMENT_NAME = "ssrc";
        private MediaDirection direction;
        @Deprecated
        private String host;
        private Integer lastN;
        private Boolean adaptiveLastN;
        private Boolean adaptiveSimulcast;
        private final List<PayloadTypePacketExtension> payloadTypes = new ArrayList<PayloadTypePacketExtension>();
        private final Map<Integer, RTPHdrExtPacketExtension> rtpHeaderExtensions = new HashMap<Integer, RTPHdrExtPacketExtension>();
        private Integer receivingSimulcastLayer;
        @Deprecated
        private int rtcpPort;
        private RTPLevelRelayType rtpLevelRelayType;
        @Deprecated
        private int rtpPort;
        private List<SourceGroupPacketExtension> sourceGroups;
        private final List<SourcePacketExtension> sources = new LinkedList<SourcePacketExtension>();
        private int[] ssrcs = NO_SSRCS;

        public Channel() {
            super(ELEMENT_NAME);
        }

        public boolean addPayloadType(PayloadTypePacketExtension payloadType) {
            if (payloadType == null) {
                throw new NullPointerException("payloadType");
            }
            payloadType.setNamespace(null);
            for (ParameterPacketExtension p : payloadType.getParameters()) {
                p.setNamespace(null);
            }
            return this.payloadTypes.contains(payloadType) ? false : this.payloadTypes.add(payloadType);
        }

        public void addRtpHeaderExtension(RTPHdrExtPacketExtension ext) {
            if (ext == null) {
                throw new NullPointerException("payloadType");
            }
            RTPHdrExtPacketExtension newExt = new RTPHdrExtPacketExtension(ext);
            newExt.setNamespace(null);
            int id = -1;
            try {
                id = Integer.valueOf(newExt.getID());
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (id < 0 || id > 14) {
                logger.warn((Object)("Failed to add an RTP header extension element with an invalid ID: " + newExt.getID()));
                return;
            }
            this.rtpHeaderExtensions.put(id, newExt);
        }

        public synchronized boolean addSource(SourcePacketExtension source) {
            if (source == null) {
                throw new NullPointerException("source");
            }
            return this.sources.contains(source) ? false : this.sources.add(source);
        }

        public synchronized boolean addSourceGroup(SourceGroupPacketExtension sourceGroup) {
            if (sourceGroup == null) {
                throw new NullPointerException("sourceGroup");
            }
            if (this.sourceGroups == null) {
                this.sourceGroups = new LinkedList<SourceGroupPacketExtension>();
            }
            return this.sourceGroups.contains(sourceGroup) ? false : this.sourceGroups.add(sourceGroup);
        }

        public synchronized boolean addSSRC(int ssrc) {
            for (int i = 0; i < this.ssrcs.length; ++i) {
                if (this.ssrcs[i] != ssrc) continue;
                return false;
            }
            int[] newSSRCs = new int[this.ssrcs.length + 1];
            System.arraycopy(this.ssrcs, 0, newSSRCs, 0, this.ssrcs.length);
            newSSRCs[this.ssrcs.length] = ssrc;
            this.ssrcs = newSSRCs;
            return true;
        }

        public MediaDirection getDirection() {
            return this.direction == null ? MediaDirection.SENDRECV : this.direction;
        }

        @Deprecated
        public String getHost() {
            return this.host;
        }

        public Integer getLastN() {
            return this.lastN;
        }

        public Boolean getAdaptiveLastN() {
            return this.adaptiveLastN;
        }

        public Boolean getAdaptiveSimulcast() {
            return this.adaptiveSimulcast;
        }

        public List<PayloadTypePacketExtension> getPayloadTypes() {
            return Collections.unmodifiableList(this.payloadTypes);
        }

        public Collection<RTPHdrExtPacketExtension> getRtpHeaderExtensions() {
            return Collections.unmodifiableCollection(this.rtpHeaderExtensions.values());
        }

        public Integer getReceivingSimulcastLayer() {
            return this.receivingSimulcastLayer;
        }

        @Deprecated
        public int getRTCPPort() {
            return this.rtcpPort;
        }

        public RTPLevelRelayType getRTPLevelRelayType() {
            return this.rtpLevelRelayType;
        }

        @Deprecated
        public int getRTPPort() {
            return this.rtpPort;
        }

        public synchronized List<SourceGroupPacketExtension> getSourceGroups() {
            return this.sourceGroups == null ? null : new ArrayList<SourceGroupPacketExtension>(this.sourceGroups);
        }

        public synchronized List<SourcePacketExtension> getSources() {
            return new ArrayList<SourcePacketExtension>(this.sources);
        }

        public synchronized int[] getSSRCs() {
            return this.ssrcs.length == 0 ? NO_SSRCS : (int[])this.ssrcs.clone();
        }

        @Override
        protected boolean hasContent() {
            List<PayloadTypePacketExtension> payloadTypes = this.getPayloadTypes();
            if (!payloadTypes.isEmpty()) {
                return true;
            }
            List<SourceGroupPacketExtension> sourceGroups = this.getSourceGroups();
            if (sourceGroups != null && !this.getSourceGroups().isEmpty()) {
                return true;
            }
            List<SourcePacketExtension> sources = this.getSources();
            if (!sources.isEmpty()) {
                return true;
            }
            int[] ssrcs = this.getSSRCs();
            return ssrcs.length != 0;
        }

        @Override
        protected void printAttributes(StringBuilder xml) {
            int rtpPort;
            RTPLevelRelayType rtpLevelRelayType;
            int rtcpPort;
            Integer lastN;
            String host;
            MediaDirection direction = this.getDirection();
            if (direction != null && direction != MediaDirection.SENDRECV) {
                xml.append(' ').append(DIRECTION_ATTR_NAME).append("='").append(direction.toString()).append('\'');
            }
            if ((host = this.getHost()) != null) {
                xml.append(' ').append(HOST_ATTR_NAME).append("='").append(host).append('\'');
            }
            if ((lastN = this.getLastN()) != null) {
                xml.append(' ').append(LAST_N_ATTR_NAME).append("='").append(lastN).append('\'');
            }
            if ((rtcpPort = this.getRTCPPort()) > 0) {
                xml.append(' ').append(RTCP_PORT_ATTR_NAME).append("='").append(rtcpPort).append('\'');
            }
            if ((rtpLevelRelayType = this.getRTPLevelRelayType()) != null) {
                xml.append(' ').append(RTP_LEVEL_RELAY_TYPE_ATTR_NAME).append("='").append((Object)rtpLevelRelayType).append('\'');
            }
            if ((rtpPort = this.getRTPPort()) > 0) {
                xml.append(' ').append(RTP_PORT_ATTR_NAME).append("='").append(rtpPort).append('\'');
            }
        }

        @Override
        protected void printContent(StringBuilder xml) {
            List<PayloadTypePacketExtension> payloadTypes = this.getPayloadTypes();
            Collection<RTPHdrExtPacketExtension> rtpHdrExtPacketExtensions = this.getRtpHeaderExtensions();
            List<SourcePacketExtension> sources = this.getSources();
            List<SourceGroupPacketExtension> sourceGroups = this.getSourceGroups();
            int[] ssrcs = this.getSSRCs();
            for (PayloadTypePacketExtension payloadType : payloadTypes) {
                xml.append(payloadType.toXML());
            }
            for (RTPHdrExtPacketExtension ext : rtpHdrExtPacketExtensions) {
                xml.append(ext.toXML());
            }
            for (SourcePacketExtension source : sources) {
                xml.append(source.toXML());
            }
            if (sourceGroups != null && sourceGroups.size() != 0) {
                for (SourceGroupPacketExtension sourceGroup : sourceGroups) {
                    xml.append(sourceGroup.toXML());
                }
            }
            for (int i = 0; i < ssrcs.length; ++i) {
                xml.append('<').append(SSRC_ELEMENT_NAME).append('>').append(Long.toString((long)ssrcs[i] & 0xFFFFFFFFL)).append("</").append(SSRC_ELEMENT_NAME).append('>');
            }
        }

        public boolean removePayloadType(PayloadTypePacketExtension payloadType) {
            return this.payloadTypes.remove(payloadType);
        }

        public void removeRtpHeaderExtension(RTPHdrExtPacketExtension ext) {
            int id = -1;
            try {
                id = Integer.valueOf(ext.getID());
            }
            catch (NumberFormatException nfe) {
                logger.warn((Object)("Invalid ID: " + ext.getID()));
                return;
            }
            this.rtpHeaderExtensions.remove(id);
        }

        public synchronized boolean removeSource(SourcePacketExtension source) {
            return this.sources.remove(source);
        }

        public synchronized boolean removeSSRC(int ssrc) {
            if (this.ssrcs.length == 1) {
                if (this.ssrcs[0] == ssrc) {
                    this.ssrcs = NO_SSRCS;
                    return true;
                }
                return false;
            }
            for (int i = 0; i < this.ssrcs.length; ++i) {
                if (this.ssrcs[i] != ssrc) continue;
                int[] newSSRCs = new int[this.ssrcs.length - 1];
                if (i != 0) {
                    System.arraycopy(this.ssrcs, 0, newSSRCs, 0, i);
                }
                if (i != newSSRCs.length) {
                    System.arraycopy(this.ssrcs, i + 1, newSSRCs, i, newSSRCs.length - i);
                }
                this.ssrcs = newSSRCs;
                return true;
            }
            return false;
        }

        public void setDirection(MediaDirection direction) {
            this.direction = direction;
        }

        @Deprecated
        public void setHost(String host) {
            this.host = host;
        }

        public void setLastN(Integer lastN) {
            this.lastN = lastN;
        }

        public void setAdaptiveLastN(Boolean adaptiveLastN) {
            this.adaptiveLastN = adaptiveLastN;
        }

        public void setAdaptiveSimulcast(Boolean adaptiveSimulcast) {
            this.adaptiveSimulcast = adaptiveSimulcast;
        }

        public void setReceivingSimulcastLayer(Integer simulcastLayer) {
            this.receivingSimulcastLayer = simulcastLayer;
        }

        @Deprecated
        public void setRTCPPort(int rtcpPort) {
            this.rtcpPort = rtcpPort;
        }

        public void setRTPLevelRelayType(RTPLevelRelayType rtpLevelRelayType) {
            this.rtpLevelRelayType = rtpLevelRelayType;
        }

        public void setRTPLevelRelayType(String s) {
            this.setRTPLevelRelayType(RTPLevelRelayType.parseRTPLevelRelayType(s));
        }

        @Deprecated
        public void setRTPPort(int rtpPort) {
            this.rtpPort = rtpPort;
        }

        public void setSSRCs(int[] ssrcs) {
            this.ssrcs = ssrcs == null || ssrcs.length == 0 ? NO_SSRCS : (int[])ssrcs.clone();
        }
    }
}

