/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.transform;

import java.util.LinkedList;
import org.jitsi.impl.neomedia.transform.AbsSendTimeEngine;
import org.jitsi.impl.neomedia.transform.REDFilterTransformEngine;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.impl.neomedia.transform.TransformEngineChain;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.neomedia.Transformer;
import org.jitsi.util.Logger;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.RtpChannel;
import org.jitsi.videobridge.rtcp.NACKHandler;
import org.jitsi.videobridge.rtcp.NACKNotifier;
import org.jitsi.videobridge.transform.CachingTransformer;
import org.jitsi.videobridge.transform.RTCPTransformEngine;
import org.jitsi.videobridge.transform.RawPacketCache;

public class RtpChannelTransformEngine
extends TransformEngineChain {
    private static final byte RED_PAYLOAD_TYPE = 116;
    private static final String DISABLE_NACK_TERMINATION_PNAME = "org.jitsi.videobridge.DISABLE_NACK_TERMINATION";
    private static final Logger logger = Logger.getLogger(RtpChannelTransformEngine.class);
    private final RtpChannel channel;
    private REDFilterTransformEngine redFilter;
    private CachingTransformer cache;
    private RTCPTransformEngine rtcpTransformEngine;
    private NACKNotifier nackNotifier;
    private AbsSendTimeEngine absSendTime;

    public RtpChannelTransformEngine(RtpChannel channel) {
        this.channel = channel;
        this.engineChain = this.createChain();
    }

    private TransformEngine[] createChain() {
        ConfigurationService cfg;
        LinkedList<Object> transformerList = new LinkedList<Object>();
        this.redFilter = new REDFilterTransformEngine(116);
        transformerList.add(this.redFilter);
        this.absSendTime = new AbsSendTimeEngine();
        transformerList.add(this.absSendTime);
        boolean enableNackTermination = true;
        Conference conference = this.channel.getContent().getConference();
        if (conference != null && (cfg = conference.getVideobridge().getConfigurationService()) != null) {
            boolean bl = enableNackTermination = !cfg.getBoolean(DISABLE_NACK_TERMINATION_PNAME, false);
        }
        if (enableNackTermination && this.channel instanceof NACKHandler) {
            logger.info((Object)("Enabling NACK termination for channel " + this.channel.getID()));
            this.cache = new CachingTransformer();
            transformerList.add(this.cache);
            this.nackNotifier = new NACKNotifier((NACKHandler)((Object)this.channel));
            this.rtcpTransformEngine = new RTCPTransformEngine(new Transformer[]{this.nackNotifier});
            transformerList.add((Object)this.rtcpTransformEngine);
        }
        return transformerList.toArray(new TransformEngine[transformerList.size()]);
    }

    public void enableAbsSendTime(int extensionID) {
        if (this.absSendTime != null) {
            this.absSendTime.setExtensionID(extensionID);
        }
    }

    public void enableREDFilter(boolean enabled) {
        if (this.redFilter != null) {
            this.redFilter.setEnabled(enabled);
        }
    }

    public RawPacketCache getCache() {
        return this.cache;
    }
}

