/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.osgi;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.lang.reflect.Method;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private static final String HAZELCAST_OSGI_START = "hazelcast.osgi.start";
    private static final ILogger LOGGER = Logger.getLogger(Activator.class);
    private HazelcastInstance hazelcastInstance;

    public void start(BundleContext context) throws Exception {
        this.activateJavaxScripting(context);
        if (System.getProperty(HAZELCAST_OSGI_START) != null) {
            this.hazelcastInstance = Hazelcast.newHazelcastInstance();
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (System.getProperty(HAZELCAST_OSGI_START) != null) {
            this.hazelcastInstance.shutdown();
        }
    }

    private void activateJavaxScripting(BundleContext context) throws Exception {
        if (!this.isJavaxScriptingAvailable()) {
            LOGGER.warning("javax.scripting is not available, scripts from Management Center cannot be executed!");
            return;
        }
        Class clazz = context.getBundle().loadClass("com.hazelcast.osgi.ScriptEngineActivator");
        Method register = clazz.getDeclaredMethod("registerOsgiScriptEngineManager", BundleContext.class);
        register.invoke((Object)clazz, context);
    }

    private boolean isJavaxScriptingAvailable() {
        try {
            Class.forName("javax.script.ScriptEngineManager");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

