/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.MinimalEncoder;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;
import net.kano.joscar.tlv.TlvTools;

public final class DirInfo
implements LiveWritable {
    private static final int TYPE_CHARSET = 24;
    private static final int TYPE_SN = 9;
    private static final int TYPE_EMAIL = 5;
    private static final int TYPE_FIRSTNAME = 1;
    private static final int TYPE_MIDDLENAME = 3;
    private static final int TYPE_LASTNAME = 2;
    private static final int TYPE_MAIDENNAME = 4;
    private static final int TYPE_NICKNAME = 12;
    private static final int TYPE_ADDRESS = 33;
    private static final int TYPE_CITY = 8;
    private static final int TYPE_STATE = 7;
    private static final int TYPE_ZIP = 13;
    private static final int TYPE_COUNTRY = 6;
    private static final int TYPE_LANGUAGE = 15;
    private final String sn;
    private final String email;
    private final String first;
    private final String middle;
    private final String last;
    private final String maiden;
    private final String nickname;
    private final String address;
    private final String city;
    private final String state;
    private final String zip;
    private final String country;
    private final String language;
    private final int totalSize;
    private ByteBlock block = null;
    private int tlvCount = -1;

    public static DirInfo readDirInfo(ByteBlock byteBlock) {
        return DirInfo.readDirInfo(TlvTools.readChain(byteBlock));
    }

    public static DirInfo readDirInfo(ByteBlock byteBlock, int n) {
        return DirInfo.readDirInfo(TlvTools.readChain(byteBlock, n));
    }

    public static DirInfo readDirInfo(TlvChain tlvChain) {
        DefensiveTools.checkNull(tlvChain, "chain");
        if (tlvChain.getTlvCount() == 0) {
            return null;
        }
        String string = tlvChain.getString(24);
        String string2 = tlvChain.getString(9, string);
        String string3 = tlvChain.getString(5, string);
        String string4 = tlvChain.getString(1, string);
        String string5 = tlvChain.getString(3, string);
        String string6 = tlvChain.getString(2, string);
        String string7 = tlvChain.getString(12, string);
        String string8 = tlvChain.getString(4, string);
        String string9 = tlvChain.getString(33, string);
        String string10 = tlvChain.getString(8, string);
        String string11 = tlvChain.getString(7, string);
        String string12 = tlvChain.getString(13, string);
        String string13 = tlvChain.getString(6, string);
        String string14 = tlvChain.getString(15, string);
        return new DirInfo(string2, string3, string4, string5, string6, string8, string7, string9, string10, string11, string12, string13, string14, tlvChain.getTotalSize());
    }

    protected DirInfo(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, int n) {
        DefensiveTools.checkRange(n, "totalSize", -1);
        this.sn = string;
        this.email = string2;
        this.first = string3;
        this.middle = string4;
        this.last = string5;
        this.maiden = string6;
        this.nickname = string7;
        this.address = string8;
        this.city = string9;
        this.state = string10;
        this.zip = string11;
        this.country = string12;
        this.language = string13;
        this.totalSize = n;
    }

    public DirInfo(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12) {
        this(null, string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, -1);
    }

    public DirInfo(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13) {
        this(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, -1);
    }

    public final String getScreenname() {
        return this.sn;
    }

    public final String getEmail() {
        return this.email;
    }

    public final String getFirstname() {
        return this.first;
    }

    public final String getMiddlename() {
        return this.middle;
    }

    public final String getLastname() {
        return this.last;
    }

    public final String getMaiden() {
        return this.maiden;
    }

    public final String getNickname() {
        return this.nickname;
    }

    public final String getStreetAddress() {
        return this.address;
    }

    public final String getCity() {
        return this.city;
    }

    public final String getState() {
        return this.state;
    }

    public final String getZip() {
        return this.zip;
    }

    public final String getCountryCode() {
        return this.country;
    }

    public final String getLanguageCode() {
        return this.language;
    }

    public final int getTotalSize() {
        return this.totalSize;
    }

    private static boolean writeString(OutputStream outputStream, int n, String string, MinimalEncoder minimalEncoder) throws IOException {
        if (string != null) {
            new Tlv(n, ByteBlock.wrap(minimalEncoder.encode(string).getData())).write(outputStream);
            return true;
        }
        return false;
    }

    private void writeTo(OutputStream outputStream) throws IOException {
        int n = 0;
        MinimalEncoder minimalEncoder = new MinimalEncoder();
        minimalEncoder.updateAll(new String[]{this.sn, this.email, this.first, this.middle, this.last, this.maiden, this.nickname, this.address, this.city, this.state, this.zip, this.country, this.language});
        Tlv.getStringInstance(24, minimalEncoder.getCharset()).write(outputStream);
        ++n;
        if (DirInfo.writeString(outputStream, 9, this.sn, minimalEncoder)) {
            ++n;
        }
        if (DirInfo.writeString(outputStream, 5, this.email, minimalEncoder)) {
            ++n;
        }
        if (DirInfo.writeString(outputStream, 1, this.first, minimalEncoder)) {
            ++n;
        }
        if (DirInfo.writeString(outputStream, 3, this.middle, minimalEncoder)) {
            ++n;
        }
        if (DirInfo.writeString(outputStream, 2, this.last, minimalEncoder)) {
            ++n;
        }
        if (DirInfo.writeString(outputStream, 4, this.maiden, minimalEncoder)) {
            ++n;
        }
        if (DirInfo.writeString(outputStream, 12, this.nickname, minimalEncoder)) {
            ++n;
        }
        if (DirInfo.writeString(outputStream, 33, this.address, minimalEncoder)) {
            ++n;
        }
        if (DirInfo.writeString(outputStream, 8, this.city, minimalEncoder)) {
            ++n;
        }
        if (DirInfo.writeString(outputStream, 7, this.state, minimalEncoder)) {
            ++n;
        }
        if (DirInfo.writeString(outputStream, 13, this.zip, minimalEncoder)) {
            ++n;
        }
        if (DirInfo.writeString(outputStream, 6, this.country, minimalEncoder)) {
            ++n;
        }
        if (DirInfo.writeString(outputStream, 15, this.language, minimalEncoder)) {
            ++n;
        }
        this.tlvCount = n;
    }

    private void ensureBlockExists() {
        if (this.block != null && this.tlvCount != -1) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.writeTo(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.block = ByteBlock.wrap(byteArrayOutputStream.toByteArray());
    }

    public final int getTlvCount() {
        if (this.tlvCount == -1) {
            this.ensureBlockExists();
        }
        return this.tlvCount;
    }

    public void write(OutputStream outputStream) throws IOException {
        if (this.block == null) {
            this.writeTo(outputStream);
        } else {
            this.block.write(outputStream);
        }
    }

    public String toString() {
        return "DirInfo for " + this.sn + " (email=" + this.email + "): " + "first='" + this.first + "'" + ", middle='" + this.middle + "'" + ", last='" + this.last + "'" + ", maiden='" + this.maiden + "'" + ", nickname='" + this.nickname + "'" + ", address='" + this.address + "'" + ", city='" + this.city + "'" + ", state='" + this.state + "'" + ", zip='" + this.zip + "'" + ", country='" + this.country + "'" + ", language='" + this.language + "'";
    }
}

