/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.StringUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Available
extends Task
implements Condition {
    private String property;
    private String classname;
    private String file;
    private Path filepath;
    private String resource;
    private FileDir type;
    private Path classpath;
    private AntClassLoader loader;
    private String value;
    private boolean isTask;
    private boolean ignoreSystemclasses;

    public void setClasspath(Path path) {
        this.createClasspath().append(path);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public void setFilepath(Path path) {
        this.createFilepath().append(path);
    }

    public Path createFilepath() {
        if (this.filepath == null) {
            this.filepath = new Path(this.getProject());
        }
        return this.filepath.createPath();
    }

    public void setProperty(String string) {
        this.property = string;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public void setClassname(String string) {
        if (!"".equals(string)) {
            this.classname = string;
        }
    }

    public void setFile(File file) {
        this.file = FileUtils.newFileUtils().removeLeadingPath(this.getProject().getBaseDir(), file);
    }

    public void setResource(String string) {
        this.resource = string;
    }

    public void setType(String string) {
        this.log("DEPRECATED - The setType(String) method has been deprecated. Use setType(Available.FileDir) instead.");
        this.type = new FileDir();
        this.type.setValue(string);
    }

    public void setType(FileDir fileDir) {
        this.type = fileDir;
    }

    public void setIgnoresystemclasses(boolean bl) {
        this.ignoreSystemclasses = bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        if (this.property == null) {
            throw new BuildException("property attribute is required", this.getLocation());
        }
        this.isTask = true;
        try {
            if (this.eval()) {
                String string = this.getProject().getProperty(this.property);
                if (string != null && !string.equals(this.value)) {
                    this.log("DEPRECATED - <available> used to override an existing property." + StringUtils.LINE_SEP + "  Build file should not reuse the same property name for different values.");
                }
                this.getProject().setProperty(this.property, this.value);
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.isTask = false;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.isTask = false;
            return;
        }
    }

    public boolean eval() throws BuildException {
        if (this.classname == null && this.file == null && this.resource == null) {
            throw new BuildException("At least one of (classname|file|resource) is required", this.getLocation());
        }
        if (this.type != null && this.file == null) {
            throw new BuildException("The type attribute is only valid when specifying the file attribute.", this.getLocation());
        }
        if (this.classpath != null) {
            this.classpath.setProject(this.getProject());
            this.loader = this.getProject().createClassLoader(this.classpath);
        }
        String string = "";
        if (this.isTask) {
            string = " to set property " + this.property;
        } else {
            this.setTaskName("available");
        }
        if (this.classname != null && !this.checkClass(this.classname)) {
            this.log("Unable to load class " + this.classname + string, 3);
            return false;
        }
        if (this.file != null && !this.checkFile()) {
            if (this.type != null) {
                this.log("Unable to find " + this.type + ' ' + this.file + string, 3);
            } else {
                this.log("Unable to find " + this.file + string, 3);
            }
            return false;
        }
        if (this.resource != null && !this.checkResource(this.resource)) {
            this.log("Unable to load resource " + this.resource + string, 3);
            return false;
        }
        if (this.loader != null) {
            this.loader.cleanup();
            this.loader = null;
        }
        if (!this.isTask) {
            this.setTaskName(null);
        }
        return true;
    }

    private final boolean checkFile() {
        if (this.filepath == null) {
            return this.checkFile(this.getProject().resolveFile(this.file), this.file);
        }
        String[] stringArray = this.filepath.list();
        int n = 0;
        while (n < stringArray.length) {
            File file;
            this.log("Searching " + stringArray[n], 4);
            File file2 = new File(stringArray[n]);
            if (file2.exists() && this.file.equals(stringArray[n])) {
                if (this.type == null) {
                    this.log("Found: " + file2, 3);
                    return true;
                }
                if (this.type.isDir() && file2.isDirectory()) {
                    this.log("Found directory: " + file2, 3);
                    return true;
                }
                if (this.type.isFile() && file2.isFile()) {
                    this.log("Found file: " + file2, 3);
                    return true;
                }
                return false;
            }
            FileUtils fileUtils = FileUtils.newFileUtils();
            File file3 = fileUtils.getParentFile(file2);
            if (file3 != null && file3.exists() && this.file.equals(file3.getAbsolutePath())) {
                if (this.type == null) {
                    this.log("Found: " + file3, 3);
                    return true;
                }
                if (this.type.isDir()) {
                    this.log("Found directory: " + file3, 3);
                    return true;
                }
                return false;
            }
            if (file2.exists() && file2.isDirectory() && this.checkFile(new File(file2, this.file), this.file + " in " + file2)) {
                return true;
            }
            if (file3 != null && file3.exists() && this.checkFile(new File(file3, this.file), this.file + " in " + file3)) {
                return true;
            }
            if (file3 != null && (file = fileUtils.getParentFile(file3)) != null && file.exists() && this.checkFile(new File(file, this.file), this.file + " in " + file)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private final boolean checkFile(File file, String string) {
        if (this.type != null) {
            if (this.type.isDir()) {
                if (file.isDirectory()) {
                    this.log("Found directory: " + string, 3);
                }
                return file.isDirectory();
            }
            if (this.type.isFile()) {
                if (file.isFile()) {
                    this.log("Found file: " + string, 3);
                }
                return file.isFile();
            }
        }
        if (file.exists()) {
            this.log("Found: " + string, 3);
        }
        return file.exists();
    }

    private final boolean checkResource(String string) {
        if (this.loader != null) {
            boolean bl = false;
            if (this.loader.getResourceAsStream(string) != null) {
                bl = true;
            }
            return bl;
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader != null) {
            boolean bl = false;
            if (classLoader.getResourceAsStream(string) != null) {
                bl = true;
            }
            return bl;
        }
        boolean bl = false;
        if (ClassLoader.getSystemResourceAsStream(string) != null) {
            bl = true;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    private final boolean checkClass(String var1_1) {
        block7: {
            var2_2 = null;
            if (!this.ignoreSystemclasses) ** GOTO lbl19
            this.loader = this.getProject().createClassLoader(this.classpath);
            this.loader.setParentFirst(false);
            this.loader.addJavaLibraries();
            if (this.loader == null) ** GOTO lbl15
            try {
                var2_2 = this.loader.findClass(var1_1);
            }
            catch (SecurityException var3_5) {
                return true;
            }
            break block7;
lbl15:
            // 1 sources

            return false;
        }
        try {
            block8: {
                break block8;
lbl19:
                // 1 sources

                var2_2 = this.loader != null ? this.loader.loadClass(var1_1) : ((var3_6 = this.getClass().getClassLoader()) != null ? Class.forName(var1_1, true, var3_6) : Class.forName(var1_1));
            }
            return true;
        }
        catch (ClassNotFoundException var2_3) {
            this.log("class \"" + var1_1 + "\" was not found", 4);
            return false;
        }
        catch (NoClassDefFoundError var2_4) {
            this.log("Could not load dependent class \"" + var2_4.getMessage() + "\" for class \"" + var1_1 + '\"', 4);
            return false;
        }
    }

    private final /* synthetic */ void this() {
        this.value = "true";
        this.isTask = false;
        this.ignoreSystemclasses = false;
    }

    public Available() {
        this.this();
    }

    public static class FileDir
    extends EnumeratedAttribute {
        private static final String[] VALUES = new String[]{"file", "dir"};

        public String[] getValues() {
            return VALUES;
        }

        public boolean isDir() {
            return "dir".equalsIgnoreCase(this.getValue());
        }

        public boolean isFile() {
            return "file".equalsIgnoreCase(this.getValue());
        }
    }
}

