/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.OscarTools;
import net.kano.joscar.StringBlock;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.icbm.IcbmCommand;

public abstract class TypingCmd
extends IcbmCommand {
    public static final int NULLS_DEFAULT = 0;
    public static final int CODE_DEFAULT = 1;
    public static final int STATE_TYPING = 2;
    public static final int STATE_PAUSED = 1;
    public static final int STATE_NO_TEXT = 0;
    private final long nulls;
    private final int code;
    private final String sn;
    private final int typingState;

    protected TypingCmd(int n, SnacPacket snacPacket) {
        super(n);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        this.nulls = BinaryTools.getLong(byteBlock, 0);
        this.code = BinaryTools.getUShort(byteBlock, 8);
        ByteBlock byteBlock2 = byteBlock.subBlock(10);
        StringBlock stringBlock = OscarTools.readScreenname(byteBlock2);
        this.sn = stringBlock.getString();
        ByteBlock byteBlock3 = byteBlock2.subBlock(stringBlock.getTotalSize());
        this.typingState = BinaryTools.getUShort(byteBlock3, 0);
    }

    protected TypingCmd(int n, String string, int n2) {
        this(n, 0L, 1, string, n2);
    }

    protected TypingCmd(int n, long l, int n2, String string, int n3) {
        super(n);
        DefensiveTools.checkRange(n2, "code", 0);
        DefensiveTools.checkNull(string, "sn");
        DefensiveTools.checkRange(n3, "typingState", 0);
        this.nulls = l;
        this.code = n2;
        this.sn = string;
        this.typingState = n3;
    }

    public final long getNullBlockValue() {
        return this.nulls;
    }

    public final int getCode() {
        return this.code;
    }

    public final String getScreenname() {
        return this.sn;
    }

    public final int getTypingState() {
        return this.typingState;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        BinaryTools.writeLong(outputStream, this.nulls);
        BinaryTools.writeUShort(outputStream, this.code);
        OscarTools.writeScreenname(outputStream, this.sn);
        BinaryTools.writeUShort(outputStream, this.typingState);
    }

    public String toString() {
        return MiscTools.getClassName(this) + " from " + this.sn + " (nulls=" + this.nulls + ", code=" + this.code + "): " + (this.typingState == 2 ? "typing" : (this.typingState == 1 ? "typed" : (this.typingState == 0 ? "no text" : "unknown: " + this.typingState)));
    }
}

