/*
 * Decompiled with CFR 0.152.
 */
package org.schwering.irc.lib;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;
import org.schwering.irc.lib.IRCEventListener;
import org.schwering.irc.lib.IRCModeParser;
import org.schwering.irc.lib.IRCParser;
import org.schwering.irc.lib.IRCUser;
import org.schwering.irc.lib.IRCUtil;

public class IRCConnection
extends Thread {
    private Socket socket;
    protected byte level = 0;
    protected String host;
    protected int[] ports;
    private BufferedReader in;
    private PrintWriter out;
    protected String encoding = "ISO-8859-1";
    private IRCEventListener[] listeners = new IRCEventListener[0];
    private int timeout = 900000;
    private boolean colorsEnabled = false;
    private boolean pongAutomatic = true;
    private String pass;
    private String nick;
    private String realname;
    private String username;

    public IRCConnection(String host, int[] ports, String pass, String nick, String username, String realname) {
        if (host == null || ports == null || ports.length == 0) {
            throw new IllegalArgumentException("Host and ports may not be null.");
        }
        this.host = host;
        this.ports = ports;
        this.pass = pass != null && pass.length() == 0 ? null : pass;
        this.nick = nick;
        this.username = username;
        this.realname = realname;
    }

    public IRCConnection(String host, int portMin, int portMax, String pass, String nick, String username, String realname) {
        this(host, IRCConnection.portRangeToArray(portMin, portMax), pass, nick, username, realname);
    }

    private static int[] portRangeToArray(int portMin, int portMax) {
        if (portMin > portMax) {
            int tmp = portMin;
            portMin = portMax;
            portMax = tmp;
        }
        int[] ports = new int[portMax - portMin + 1];
        for (int i = 0; i < ports.length; ++i) {
            ports[i] = portMin + i;
        }
        return ports;
    }

    public void connect() throws IOException {
        if (this.level != 0) {
            throw new SocketException(String.valueOf(String.valueOf("Socket closed or already open (").concat(String.valueOf(this.level))).concat(String.valueOf(")")));
        }
        IOException exception = null;
        Socket s = null;
        for (int i = 0; i < this.ports.length && s == null; ++i) {
            try {
                s = new Socket(this.host, this.ports[i]);
                exception = null;
                continue;
            }
            catch (IOException exc) {
                if (s != null) {
                    s.close();
                }
                s = null;
                exception = exc;
            }
        }
        if (exception != null) {
            throw exception;
        }
        this.prepare(s);
    }

    protected void prepare(Socket s) throws IOException {
        if (s == null) {
            throw new SocketException("Socket s is null, not connected");
        }
        this.socket = s;
        this.level = 1;
        s.setSoTimeout(this.timeout);
        this.in = new BufferedReader(new InputStreamReader(s.getInputStream(), this.encoding));
        this.out = new PrintWriter(new OutputStreamWriter(s.getOutputStream(), this.encoding));
        this.start();
        this.register();
    }

    private void register() {
        if (this.pass != null) {
            this.send(String.valueOf("PASS ").concat(String.valueOf(this.pass)));
        }
        this.send(String.valueOf("NICK ").concat(String.valueOf(this.nick)));
        this.send(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("USER ").concat(String.valueOf(this.username))).concat(String.valueOf(" "))).concat(String.valueOf(this.socket.getLocalAddress()))).concat(String.valueOf(" "))).concat(String.valueOf(this.host))).concat(String.valueOf(" :"))).concat(String.valueOf(this.realname)));
    }

    public void run() {
        try {
            while (!this.isInterrupted()) {
                String line = this.in.readLine();
                if (line != null) {
                    this.get(line);
                    continue;
                }
                this.close();
            }
        }
        catch (IOException exc) {
            this.close();
        }
    }

    public void send(String line) {
        try {
            IRCParser p;
            this.out.write(String.valueOf(line).concat(String.valueOf("\r\n")));
            this.out.flush();
            if (this.level == 1 && (p = new IRCParser(line)).getCommand().equalsIgnoreCase("NICK")) {
                this.nick = p.getParameter(1).trim();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void get(String line) {
        block51: {
            String command;
            IRCParser p;
            block53: {
                int i;
                block52: {
                    block50: {
                        try {
                            p = new IRCParser(line, this.colorsEnabled);
                        }
                        catch (Exception exc) {
                            return;
                        }
                        command = p.getCommand();
                        if (!command.equalsIgnoreCase("PRIVMSG")) break block50;
                        IRCUser user = p.getUser();
                        String middle = p.getMiddle();
                        String trailing = p.getTrailing();
                        for (int i2 = 0; i2 < this.listeners.length; ++i2) {
                            this.listeners[i2].onPrivmsg(middle, user, trailing);
                        }
                        break block51;
                    }
                    if (!command.equalsIgnoreCase("MODE")) break block52;
                    String chan = p.getParameter(1);
                    if (IRCUtil.isChan(chan)) {
                        IRCUser user = p.getUser();
                        String param2 = p.getParameter(2);
                        String paramsFrom3 = p.getParametersFrom(3);
                        for (int i3 = 0; i3 < this.listeners.length; ++i3) {
                            this.listeners[i3].onMode(chan, user, new IRCModeParser(param2, paramsFrom3));
                        }
                    } else {
                        IRCUser user = p.getUser();
                        String paramsFrom2 = p.getParametersFrom(2);
                        for (int i4 = 0; i4 < this.listeners.length; ++i4) {
                            this.listeners[i4].onMode(user, chan, paramsFrom2);
                        }
                    }
                    break block51;
                }
                if (!command.equalsIgnoreCase("PING")) break block53;
                String ping = p.getTrailing();
                if (this.pongAutomatic) {
                    this.doPong(ping);
                } else {
                    for (i = 0; i < this.listeners.length; ++i) {
                        this.listeners[i].onPing(ping);
                    }
                }
                if (this.level != 1) break block51;
                this.level = (byte)2;
                for (i = 0; i < this.listeners.length; ++i) {
                    this.listeners[i].onRegistered();
                }
                break block51;
            }
            if (command.equalsIgnoreCase("JOIN")) {
                IRCUser user = p.getUser();
                String trailing = p.getTrailing();
                for (int i = 0; i < this.listeners.length; ++i) {
                    this.listeners[i].onJoin(trailing, user);
                }
            } else if (command.equalsIgnoreCase("NICK")) {
                IRCUser user = p.getUser();
                String changingNick = p.getNick();
                String newNick = p.getTrailing();
                if (changingNick.equalsIgnoreCase(this.nick)) {
                    this.nick = newNick;
                }
                for (int i = 0; i < this.listeners.length; ++i) {
                    this.listeners[i].onNick(user, newNick);
                }
            } else if (command.equalsIgnoreCase("QUIT")) {
                IRCUser user = p.getUser();
                String trailing = p.getTrailing();
                for (int i = 0; i < this.listeners.length; ++i) {
                    this.listeners[i].onQuit(user, trailing);
                }
            } else if (command.equalsIgnoreCase("PART")) {
                IRCUser user = p.getUser();
                String chan = p.getParameter(1);
                String msg = p.getParameterCount() > 1 ? p.getTrailing() : "";
                for (int i = 0; i < this.listeners.length; ++i) {
                    this.listeners[i].onPart(chan, user, msg);
                }
            } else if (command.equalsIgnoreCase("NOTICE")) {
                IRCUser user = p.getUser();
                String middle = p.getMiddle();
                String trailing = p.getTrailing();
                for (int i = 0; i < this.listeners.length; ++i) {
                    this.listeners[i].onNotice(middle, user, trailing);
                }
            } else {
                int reply = IRCUtil.parseInt(command);
                if (reply >= 1 && reply < 400) {
                    String potNick = p.getParameter(1);
                    if ((this.level == 1 || this.level == 2) && this.nick.length() > potNick.length() && this.nick.substring(0, potNick.length()).equalsIgnoreCase(potNick)) {
                        this.nick = potNick;
                        if (this.level == 2) {
                            this.level = (byte)3;
                        }
                    }
                    if (this.level == 1) {
                        this.level = (byte)2;
                        for (int i = 0; i < this.listeners.length; ++i) {
                            this.listeners[i].onRegistered();
                        }
                    }
                    String middle = p.getMiddle();
                    String trailing = p.getTrailing();
                    for (int i = 0; i < this.listeners.length; ++i) {
                        this.listeners[i].onReply(reply, middle, trailing);
                    }
                } else if (reply >= 400 && reply < 600) {
                    String trailing = p.getTrailing();
                    for (int i = 0; i < this.listeners.length; ++i) {
                        this.listeners[i].onError(reply, trailing);
                    }
                } else if (command.equalsIgnoreCase("KICK")) {
                    IRCUser user = p.getUser();
                    String param1 = p.getParameter(1);
                    String param2 = p.getParameter(2);
                    String msg = p.getParameterCount() > 2 ? p.getTrailing() : "";
                    for (int i = 0; i < this.listeners.length; ++i) {
                        this.listeners[i].onKick(param1, user, param2, msg);
                    }
                } else if (command.equalsIgnoreCase("INVITE")) {
                    IRCUser user = p.getUser();
                    String middle = p.getMiddle();
                    String trailing = p.getTrailing();
                    for (int i = 0; i < this.listeners.length; ++i) {
                        this.listeners[i].onInvite(trailing, user, middle);
                    }
                } else if (command.equalsIgnoreCase("TOPIC")) {
                    IRCUser user = p.getUser();
                    String middle = p.getMiddle();
                    String trailing = p.getTrailing();
                    for (int i = 0; i < this.listeners.length; ++i) {
                        this.listeners[i].onTopic(middle, user, trailing);
                    }
                } else if (command.equalsIgnoreCase("ERROR")) {
                    String trailing = p.getTrailing();
                    for (int i = 0; i < this.listeners.length; ++i) {
                        this.listeners[i].onError(trailing);
                    }
                } else {
                    String prefix = p.getPrefix();
                    String middle = p.getMiddle();
                    String trailing = p.getTrailing();
                    for (int i = 0; i < this.listeners.length; ++i) {
                        this.listeners[i].unknown(prefix, command, middle, trailing);
                    }
                }
            }
        }
    }

    public void close() {
        try {
            this.interrupt();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        try {
            this.socket.close();
        }
        catch (Exception exc) {
            // empty catch block
        }
        try {
            this.out.close();
        }
        catch (Exception exc) {
            // empty catch block
        }
        try {
            this.in.close();
        }
        catch (Exception exc) {
            // empty catch block
        }
        if (this.level != -1) {
            this.level = (byte)-1;
            for (int i = 0; i < this.listeners.length; ++i) {
                this.listeners[i].onDisconnected();
            }
        }
        this.socket = null;
        this.in = null;
        this.out = null;
        this.listeners = new IRCEventListener[0];
    }

    public void addIRCEventListener(IRCEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener is null.");
        }
        int len = this.listeners.length;
        IRCEventListener[] oldListeners = this.listeners;
        this.listeners = new IRCEventListener[len + 1];
        System.arraycopy(oldListeners, 0, this.listeners, 0, len);
        this.listeners[len] = listener;
    }

    public boolean removeIRCEventListener(IRCEventListener listener) {
        if (listener == null) {
            return false;
        }
        int index = -1;
        for (int i = 0; i < this.listeners.length; ++i) {
            if (!this.listeners[i].equals(listener)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return false;
        }
        this.listeners[index] = null;
        int len = this.listeners.length - 1;
        IRCEventListener[] newListeners = new IRCEventListener[len];
        int i = 0;
        int j = 0;
        while (i < len) {
            if (this.listeners[j] != null) {
                newListeners[i++] = this.listeners[j];
            }
            ++j;
        }
        this.listeners = newListeners;
        return true;
    }

    public void setColors(boolean colors) {
        this.colorsEnabled = colors;
    }

    public void setPong(boolean pong) {
        this.pongAutomatic = pong;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setTimeout(int millis) {
        if (this.socket != null) {
            try {
                this.socket.setSoTimeout(millis);
            }
            catch (IOException exc) {
                exc.printStackTrace();
            }
        }
        this.timeout = millis;
    }

    public boolean isConnected() {
        return this.level >= 1;
    }

    public String getNick() {
        return this.nick;
    }

    public String getRealname() {
        return this.realname;
    }

    public String getUsername() {
        return this.username;
    }

    public String getHost() {
        return this.host;
    }

    public String getPassword() {
        return this.pass;
    }

    public int[] getPorts() {
        return this.ports;
    }

    public int getPort() {
        return this.socket != null ? this.socket.getPort() : 0;
    }

    public boolean getColors() {
        return this.colorsEnabled;
    }

    public boolean getPong() {
        return this.pongAutomatic;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int getTimeout() {
        if (this.socket != null) {
            try {
                int n = this.socket.getSoTimeout();
                return n;
            }
            catch (IOException exc) {
                exc.printStackTrace();
                int n = -1;
                return n;
            }
        }
        return this.timeout;
    }

    public String toString() {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.getClass().getName()).concat(String.valueOf("["))).concat(String.valueOf(this.host))).concat(String.valueOf(","))).concat(String.valueOf(this.getPort()))).concat(String.valueOf(","))).concat(String.valueOf(this.username))).concat(String.valueOf(","))).concat(String.valueOf(this.nick))).concat(String.valueOf(","))).concat(String.valueOf(this.realname))).concat(String.valueOf(","))).concat(String.valueOf(this.pass))).concat(String.valueOf(","))).concat(String.valueOf(this.isConnected()))).concat(String.valueOf("]"));
    }

    public void doAway() {
        this.send("AWAY");
    }

    public void doAway(String msg) {
        this.send(String.valueOf("AWAY :").concat(String.valueOf(msg)));
    }

    public void doInvite(String nick, String chan) {
        this.send(String.valueOf(String.valueOf(String.valueOf("INVITE ").concat(String.valueOf(nick))).concat(String.valueOf(" "))).concat(String.valueOf(chan)));
    }

    public void doIson(String nick) {
        this.send(String.valueOf("ISON ").concat(String.valueOf(nick)));
    }

    public void doJoin(String chan) {
        this.send(String.valueOf("JOIN ").concat(String.valueOf(chan)));
    }

    public void doJoin(String chan, String key) {
        this.send(String.valueOf(String.valueOf(String.valueOf("JOIN ").concat(String.valueOf(chan))).concat(String.valueOf(" "))).concat(String.valueOf(key)));
    }

    public void doKick(String chan, String nick) {
        this.send(String.valueOf(String.valueOf(String.valueOf("KICK ").concat(String.valueOf(chan))).concat(String.valueOf(" "))).concat(String.valueOf(nick)));
    }

    public void doKick(String chan, String nick, String msg) {
        this.send(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("KICK ").concat(String.valueOf(chan))).concat(String.valueOf(" "))).concat(String.valueOf(nick))).concat(String.valueOf(" :"))).concat(String.valueOf(msg)));
    }

    public void doList() {
        this.send("LIST");
    }

    public void doList(String chan) {
        this.send(String.valueOf("LIST ").concat(String.valueOf(chan)));
    }

    public void doNames() {
        this.send("NAMES");
    }

    public void doNames(String chan) {
        this.send(String.valueOf("NAMES ").concat(String.valueOf(chan)));
    }

    public void doPrivmsg(String target, String msg) {
        this.send(String.valueOf(String.valueOf(String.valueOf("PRIVMSG ").concat(String.valueOf(target))).concat(String.valueOf(" :"))).concat(String.valueOf(msg)));
    }

    public void doMode(String chan) {
        this.send(String.valueOf("MODE ").concat(String.valueOf(chan)));
    }

    public void doMode(String target, String mode) {
        this.send(String.valueOf(String.valueOf(String.valueOf("MODE ").concat(String.valueOf(target))).concat(String.valueOf(" "))).concat(String.valueOf(mode)));
    }

    public void doNick(String nick) {
        this.send(String.valueOf("NICK ").concat(String.valueOf(nick)));
    }

    public void doNotice(String target, String msg) {
        this.send(String.valueOf(String.valueOf(String.valueOf("NOTICE ").concat(String.valueOf(target))).concat(String.valueOf(" :"))).concat(String.valueOf(msg)));
    }

    public void doPart(String chan) {
        this.send(String.valueOf("PART ").concat(String.valueOf(chan)));
    }

    public void doPart(String chan, String msg) {
        this.send(String.valueOf(String.valueOf(String.valueOf("PART ").concat(String.valueOf(chan))).concat(String.valueOf(" :"))).concat(String.valueOf(msg)));
    }

    public void doPong(String ping) {
        this.send(String.valueOf("PONG :").concat(String.valueOf(ping)));
    }

    public void doQuit() {
        this.send("QUIT");
    }

    public void doQuit(String msg) {
        this.send(String.valueOf("QUIT :").concat(String.valueOf(msg)));
    }

    public void doTopic(String chan) {
        this.send(String.valueOf("TOPIC ").concat(String.valueOf(chan)));
    }

    public void doTopic(String chan, String topic) {
        this.send(String.valueOf(String.valueOf(String.valueOf("TOPIC ").concat(String.valueOf(chan))).concat(String.valueOf(" :"))).concat(String.valueOf(topic)));
    }

    public void doWho(String criteric) {
        this.send(String.valueOf("WHO ").concat(String.valueOf(criteric)));
    }

    public void doWhois(String nick) {
        this.send(String.valueOf("WHOIS ").concat(String.valueOf(nick)));
    }

    public void doWhowas(String nick) {
        this.send(String.valueOf("WHOWAS ").concat(String.valueOf(nick)));
    }

    public void doUserhost(String nick) {
        this.send(String.valueOf("USERHOST ").concat(String.valueOf(nick)));
    }
}

