/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.network;

import java.io.IOException;
import java.net.SocketException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openymsg.network.ServiceType;
import org.openymsg.network.Session;
import org.openymsg.network.UnknowServiceException;
import org.openymsg.network.YMSG9BadFormatException;
import org.openymsg.network.YMSG9Packet;
import org.openymsg.network.YahooConference;
import org.openymsg.network.YahooException;
import org.openymsg.network.YahooUser;
import org.openymsg.network.event.SessionConferenceInviteEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputThread
extends Thread {
    private volatile boolean quit = false;
    protected final Session parentSession;
    private static final Log log = LogFactory.getLog(InputThread.class);

    public InputThread(Session parentSession) {
        super("jYMSG Input " + parentSession.getLoginID().getId());
        this.parentSession = parentSession;
    }

    public void stopMe() {
        this.quit = true;
    }

    @Override
    public void run() {
        while (!this.quit) {
            try {
                this.process(this.parentSession.network.receivePacket());
            }
            catch (UnknowServiceException e) {
                log.warn((Object)("unknow packet: " + e.getPacket().toString()));
            }
            catch (Exception e) {
                if (this.quit && e instanceof SocketException) {
                    log.debug((Object)"logging out so don't handle exception", (Throwable)e);
                    return;
                }
                log.error((Object)"error on process packet", (Throwable)e);
                try {
                    this.parentSession.sendExceptionEvent(e, "Source: InputThread");
                }
                catch (Exception e2) {
                    log.error((Object)"error on sendException to the session", (Throwable)e2);
                }
                if (!(e instanceof IOException)) continue;
                this.quit = true;
            }
        }
    }

    private void process(YMSG9Packet pkt) throws Exception {
        if (pkt == null) {
            this.quit = true;
            return;
        }
        if (pkt.sessionId != 0L) {
            this.parentSession.sessionId = pkt.sessionId;
        }
        if (pkt.status == -1L && this.processError(pkt)) {
            return;
        }
        log.trace((Object)("Incoming packet: " + pkt));
        this.processPayload(pkt);
    }

    protected void processPayload(YMSG9Packet pkt) throws IOException, YahooException {
        log.trace((Object)("processPayload " + (Object)((Object)pkt.service) + "/" + pkt.status));
        switch (pkt.service) {
            case ADDIGNORE: {
                this.parentSession.receiveAddIgnore(pkt);
                break;
            }
            case AUTH: {
                this.parentSession.receiveAuth(pkt);
                break;
            }
            case AUTHRESP: {
                this.parentSession.receiveAuthResp(pkt);
                break;
            }
            case CHATCONNECT: {
                this.parentSession.receiveChatConnect(pkt);
                break;
            }
            case CHATDISCONNECT: {
                this.parentSession.receiveChatDisconnect(pkt);
                break;
            }
            case CHATEXIT: {
                this.parentSession.receiveChatExit(pkt);
                break;
            }
            case CHATJOIN: {
                this.parentSession.receiveChatJoin(pkt);
                break;
            }
            case CHATMSG: {
                this.parentSession.receiveChatMsg(pkt);
                break;
            }
            case CHATPM: {
                this.parentSession.receiveChatPM(pkt);
                break;
            }
            case CONFADDINVITE: {
                this.receiveConfAddInvite(pkt);
                break;
            }
            case CONFDECLINE: {
                this.parentSession.receiveConfDecline(pkt);
                break;
            }
            case CONFINVITE: {
                this.receiveConfInvite(pkt);
                break;
            }
            case CONFLOGOFF: {
                this.parentSession.receiveConfLogoff(pkt);
                break;
            }
            case CONFLOGON: {
                this.parentSession.receiveConfLogon(pkt);
                break;
            }
            case CONFMSG: {
                this.parentSession.receiveConfMsg(pkt);
                break;
            }
            case CONTACTIGNORE: {
                this.parentSession.receiveContactIgnore(pkt);
                break;
            }
            case CONTACTNEW: {
                this.parentSession.receiveContactNew(pkt);
                break;
            }
            case FILETRANSFER: {
                this.parentSession.receiveFileTransfer(pkt);
                break;
            }
            case FRIENDADD: {
                this.parentSession.receiveFriendAdd(pkt);
                break;
            }
            case FRIENDREMOVE: {
                this.parentSession.receiveFriendRemove(pkt);
                break;
            }
            case GOTGROUPRENAME: {
                this.parentSession.receiveGroupRename(pkt);
                break;
            }
            case IDACT: {
                this.parentSession.receiveIdAct(pkt);
                break;
            }
            case IDDEACT: {
                this.parentSession.receiveIdDeact(pkt);
                break;
            }
            case ISAWAY: {
                this.parentSession.receiveIsAway(pkt);
                break;
            }
            case ISBACK: {
                this.parentSession.receiveIsBack(pkt);
                break;
            }
            case LIST: {
                this.parentSession.receiveList(pkt);
                break;
            }
            case LIST_15: {
                this.parentSession.receiveList15(pkt);
                break;
            }
            case LOGOFF: {
                this.parentSession.receiveLogoff(pkt);
                break;
            }
            case LOGON: {
                this.parentSession.receiveLogon(pkt);
                break;
            }
            case MESSAGE: {
                this.parentSession.receiveMessage(pkt);
                break;
            }
            case NEWMAIL: {
                this.parentSession.receiveNewMail(pkt);
                break;
            }
            case NOTIFY: {
                this.parentSession.receiveNotify(pkt);
                break;
            }
            case USERSTAT: {
                this.parentSession.receiveUserStat(pkt);
                break;
            }
            case Y6_STATUS_UPDATE: {
                this.parentSession.receiveStatusUpdate(pkt);
                break;
            }
            case STATUS_15: {
                this.parentSession.receiveStatus15(pkt);
                break;
            }
            case GROUPRENAME: {
                this.parentSession.receiveGroupRename(pkt);
                break;
            }
            case CONTACTREJECT: {
                this.parentSession.receiveContactRejected(pkt);
                break;
            }
            case PICTURE: {
                this.parentSession.receivePicture(pkt);
                break;
            }
            case Y7_AUTHORIZATION: {
                this.parentSession.receiveAuthorization(pkt);
                break;
            }
            case PING: {
                log.debug((Object)"Received PING (but ignoring it).");
                break;
            }
            case UNKNOWN002: {
                log.debug((Object)"Received 239 (but ignoring it).");
                break;
            }
            default: {
                log.info((Object)("Don't know how to handle service type '" + pkt.service.getValue() + "'. The original packet was: " + pkt.toString()));
            }
        }
    }

    private boolean processError(YMSG9Packet pkt) throws Exception {
        switch (pkt.service) {
            case AUTHRESP: {
                this.parentSession.receiveAuthResp(pkt);
                return true;
            }
            case CHATJOIN: {
                this.parentSession.receiveChatJoin(pkt);
                return true;
            }
            case LOGOFF: {
                this.parentSession.receiveLogoff(pkt);
                return true;
            }
        }
        this.parentSession.errorMessage(pkt, null);
        return pkt.body.length <= 2;
    }

    private void receiveConfAddInvite(YMSG9Packet pkt) {
        YahooConference yc = this.parentSession.getOrCreateConference(pkt);
        if (yc.isClosed()) {
            yc.reopenConference();
        }
        this.receiveConfInvite(pkt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveConfInvite(YMSG9Packet pkt) {
        try {
            String[] invitedUserIds = pkt.getValues("52");
            String[] currentUserIds = pkt.getValues("53");
            if (invitedUserIds.length == 0 && currentUserIds.length == 0) {
                log.debug((Object)("Correctly not handling empty invite: " + pkt));
                return;
            }
            YahooConference yc = this.parentSession.getOrCreateConference(pkt);
            String otherInvitedUserIdsCommaSeparated = pkt.getValue("51");
            String to = pkt.getValue("1");
            String from = pkt.getValue("50");
            Set<YahooUser> invitedUsers = this.getUsers(invitedUserIds);
            Set<YahooUser> currentUsers = this.getUsers(currentUserIds);
            Set<YahooUser> otherInvitedUsers = this.getUsers(otherInvitedUserIdsCommaSeparated);
            invitedUsers.addAll(otherInvitedUsers);
            SessionConferenceInviteEvent se = new SessionConferenceInviteEvent(this, to, from, yc, invitedUsers, currentUsers);
            yc.addUsers(invitedUserIds);
            yc.addUsers(currentUserIds);
            yc.addUser(from);
            if (!yc.isClosed()) {
                this.parentSession.fire(se, ServiceType.CONFINVITE);
            }
            YahooConference yahooConference = yc;
            synchronized (yahooConference) {
                Queue<YMSG9Packet> buffer = yc.inviteReceived();
                for (YMSG9Packet packet : buffer) {
                    this.process(packet);
                }
            }
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("conference invite", pkt, e);
        }
    }

    private Set<YahooUser> getUsers(String otherInvitedUserIdsCommaSeparated) {
        if (otherInvitedUserIdsCommaSeparated == null || otherInvitedUserIdsCommaSeparated.length() == 0) {
            return Collections.emptySet();
        }
        String[] ids = otherInvitedUserIdsCommaSeparated.split(",");
        return this.getUsers(ids);
    }

    private Set<YahooUser> getUsers(String[] users) {
        HashSet<YahooUser> conferenceUsers = new HashSet<YahooUser>();
        for (String userId : users) {
            YahooUser user = this.parentSession.getRoster().getUser(userId);
            if (user == null) {
                user = new YahooUser(userId);
            }
            conferenceUsers.add(user);
        }
        return conferenceUsers;
    }
}

