/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.util.Arrays;
import java.util.EnumSet;
import org.eclipse.jetty.http.PathMap;
import org.eclipse.jetty.server.DispatcherType;
import org.eclipse.jetty.servlet.FilterHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterMapping {
    public static final int DEFAULT = 0;
    public static final int REQUEST = 1;
    public static final int FORWARD = 2;
    public static final int INCLUDE = 4;
    public static final int ERROR = 8;
    public static final int ASYNC = 16;
    public static final int ALL = 31;
    private int _dispatches = 0;
    private String _filterName;
    private transient FilterHolder _holder;
    private String[] _pathSpecs;
    private String[] _servletNames;

    public static int dispatch(String type) {
        if ("request".equalsIgnoreCase(type)) {
            return 1;
        }
        if ("forward".equalsIgnoreCase(type)) {
            return 2;
        }
        if ("include".equalsIgnoreCase(type)) {
            return 4;
        }
        if ("error".equalsIgnoreCase(type)) {
            return 8;
        }
        if ("async".equalsIgnoreCase(type)) {
            return 16;
        }
        throw new IllegalArgumentException(type);
    }

    public static int dispatch(DispatcherType type) {
        switch (type) {
            case REQUEST: {
                return 1;
            }
            case ASYNC: {
                return 16;
            }
            case FORWARD: {
                return 2;
            }
            case INCLUDE: {
                return 4;
            }
            case ERROR: {
                return 8;
            }
        }
        throw new IllegalArgumentException(type.toString());
    }

    public static DispatcherType dispatch(int type) {
        switch (type) {
            case 1: {
                return DispatcherType.REQUEST;
            }
            case 16: {
                return DispatcherType.ASYNC;
            }
            case 2: {
                return DispatcherType.FORWARD;
            }
            case 4: {
                return DispatcherType.INCLUDE;
            }
            case 8: {
                return DispatcherType.ERROR;
            }
        }
        throw new IllegalArgumentException("" + type);
    }

    boolean appliesTo(String path, int type) {
        if (this.appliesTo(type)) {
            for (int i = 0; i < this._pathSpecs.length; ++i) {
                if (this._pathSpecs[i] == null || !PathMap.match((String)this._pathSpecs[i], (String)path, (boolean)true)) continue;
                return true;
            }
        }
        return false;
    }

    boolean appliesTo(int type) {
        if (this._dispatches == 0) {
            return type == 1 || type == 16 && this._holder.isAsyncSupported();
        }
        return (this._dispatches & type) != 0;
    }

    public int getDispatches() {
        return this._dispatches;
    }

    public String getFilterName() {
        return this._filterName;
    }

    FilterHolder getFilterHolder() {
        return this._holder;
    }

    public String[] getPathSpecs() {
        return this._pathSpecs;
    }

    public void setDispatcherTypes(EnumSet<DispatcherType> dispatcherTypes) {
        this._dispatches = 0;
        if (dispatcherTypes.contains(DispatcherType.ERROR)) {
            this._dispatches |= 8;
        }
        if (dispatcherTypes.contains(DispatcherType.FORWARD)) {
            this._dispatches |= 2;
        }
        if (dispatcherTypes.contains(DispatcherType.INCLUDE)) {
            this._dispatches |= 4;
        }
        if (dispatcherTypes.contains(DispatcherType.REQUEST)) {
            this._dispatches |= 1;
        }
    }

    public void setDispatches(int dispatches) {
        this._dispatches = dispatches;
    }

    public void setFilterName(String filterName) {
        this._filterName = filterName;
    }

    void setFilterHolder(FilterHolder holder) {
        this._holder = holder;
        this.setFilterName(holder.getName());
    }

    public void setPathSpecs(String[] pathSpecs) {
        this._pathSpecs = pathSpecs;
    }

    public void setPathSpec(String pathSpec) {
        this._pathSpecs = new String[]{pathSpec};
    }

    public String[] getServletNames() {
        return this._servletNames;
    }

    public void setServletNames(String[] servletNames) {
        this._servletNames = servletNames;
    }

    public void setServletName(String servletName) {
        this._servletNames = new String[]{servletName};
    }

    public String toString() {
        return (this._pathSpecs == null ? "[]" : Arrays.asList(this._pathSpecs).toString()) + "/" + (this._servletNames == null ? "[]" : Arrays.asList(this._servletNames).toString()) + "==" + this._dispatches + "=>" + this._filterName;
    }
}

