/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.adapters;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import weblogic.xml.babel.adapters.ElementConsumer;
import weblogic.xml.babel.baseparser.PrefixMapping;
import weblogic.xml.babel.baseparser.SymbolTable;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.Location;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.events.AttributeImpl;
import weblogic.xml.stream.events.ChangePrefixMappingEvent;
import weblogic.xml.stream.events.CharacterDataEvent;
import weblogic.xml.stream.events.EndDocumentEvent;
import weblogic.xml.stream.events.EndElementEvent;
import weblogic.xml.stream.events.EndPrefixMappingEvent;
import weblogic.xml.stream.events.LocationImpl;
import weblogic.xml.stream.events.Name;
import weblogic.xml.stream.events.ProcessingInstructionEvent;
import weblogic.xml.stream.events.SpaceEvent;
import weblogic.xml.stream.events.StartDocumentEvent;
import weblogic.xml.stream.events.StartElementEvent;
import weblogic.xml.stream.events.StartPrefixMappingEvent;

public class SAXAdapter
implements ContentHandler,
DTDHandler,
ErrorHandler {
    private boolean debug = false;
    protected ElementConsumer consumer;
    protected Locator locator;
    protected SymbolTable nameSpaceTable;

    public SAXAdapter() {
    }

    public SAXAdapter(ElementConsumer elementConsumer) {
        this.consumer = elementConsumer;
    }

    public void setElementConsumer(ElementConsumer elementConsumer) {
        this.consumer = elementConsumer;
    }

    public ElementConsumer getElementConsumer() {
        return this.consumer;
    }

    public Location getLocation(Locator locator) {
        return new LocationImpl(locator.getColumnNumber(), locator.getLineNumber(), locator.getPublicId(), locator.getSystemId());
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
        if (this.debug) {
            System.out.println("[StartDocument]");
        }
        this.consumer.add(new StartDocumentEvent());
        this.nameSpaceTable = new SymbolTable();
        this.nameSpaceTable.put("", null);
        this.nameSpaceTable.put("xml", "http://www.w3.org/XML/1998/namespace");
    }

    public void endDocument() throws SAXException {
        if (this.debug) {
            System.out.println("[EndDocument]");
        }
        this.consumer.add(new EndDocumentEvent());
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.nameSpaceTable.openScope();
        if (this.debug) {
            System.out.println("[startPrefixMapping[" + string + "][" + string2 + "]]");
        }
        this.consumer.add(new StartPrefixMappingEvent(string, string2));
        this.nameSpaceTable.put(string, string2);
    }

    public void endPrefixMapping(String string) throws SAXException {
        Object[] objectArray = this.nameSpaceTable.closeScope();
        if (this.debug) {
            System.out.println("[endPrefixMapping[" + string + "]]");
        }
        int n = 0;
        while (n < objectArray.length) {
            PrefixMapping prefixMapping = (PrefixMapping)objectArray[n];
            if (prefixMapping.getUri() == null) {
                this.consumer.add(new EndPrefixMappingEvent(prefixMapping.getPrefix()));
            } else {
                this.consumer.add(new ChangePrefixMappingEvent(prefixMapping.getOldUri(), prefixMapping.getUri(), prefixMapping.getPrefix()));
            }
            ++n;
        }
    }

    protected String getPrefix(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n);
    }

    public String getUri(String string) {
        if (string.equals("")) {
            string = null;
        }
        return string;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        StartElementEvent startElementEvent = new StartElementEvent((XMLName)new Name(this.getUri(string), string2, this.getPrefix(string3)));
        int n = 0;
        while (n < attributes.getLength()) {
            String string4 = attributes.getLocalName(n);
            String string5 = this.getPrefix(attributes.getQName(n));
            if (string4.equals("xmlns")) {
                startElementEvent.addNamespace((Attribute)new AttributeImpl((XMLName)new Name(string4), attributes.getValue(n), attributes.getType(n)));
            } else if (string5 != null && string5.equals("xmlns")) {
                startElementEvent.addNamespace((Attribute)new AttributeImpl((XMLName)new Name(null, string4, string5), attributes.getValue(n), attributes.getType(n)));
            } else {
                startElementEvent.addAttribute((Attribute)new AttributeImpl((XMLName)new Name(this.getUri(attributes.getURI(n)), attributes.getLocalName(n), this.getPrefix(attributes.getQName(n))), attributes.getValue(n), attributes.getType(n)));
            }
            ++n;
        }
        if (this.debug) {
            System.out.print("[startElement[" + startElementEvent + "]");
        }
        this.consumer.add(startElementEvent);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.debug) {
            System.out.println("[endElement[" + string3 + "]");
        }
        this.consumer.add(new EndElementEvent((XMLName)new Name(this.getUri(string), string2, this.getPrefix(string3))));
    }

    protected boolean isSpace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.debug) {
            System.out.print("[Characters[]");
        }
        boolean bl = true;
        int n3 = 0;
        while (n3 < n2) {
            if (!this.isSpace(cArray[n + n3])) {
                bl = false;
                break;
            }
            ++n3;
        }
        if (bl) {
            this.consumer.add(new SpaceEvent(new String(cArray, n, n2)));
        } else {
            this.consumer.add(new CharacterDataEvent(new String(cArray, n, n2)));
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.consumer.add(new SpaceEvent(new String(cArray, n, n2)));
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.debug) {
            System.out.println("[ProcessingInstruction]");
        }
        this.consumer.add(new ProcessingInstructionEvent((XMLName)new Name(string), string2));
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        throw new SAXException(sAXParseException);
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        throw new SAXException(sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw new SAXException(sAXParseException);
    }

    public void notationDecl(String string, String string2, String string3) throws SAXException {
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
    }
}

