/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.cache;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.util.cache.SimpleMapCache;

public class SimpleLRUCache
extends SimpleMapCache {
    private static final float LOADFACTOR = 0.75f;
    private int cacheSize;

    public SimpleLRUCache(int cacheSize) {
        super(null);
        this.cacheSize = cacheSize;
        int capacity = (int)Math.ceil((float)cacheSize / 0.75f) + 1;
        this.map = new LinkedHashMap(capacity, 0.75f, true){

            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > SimpleLRUCache.this.cacheSize;
            }
        };
    }
}

