/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.config;

import com.install4j.runtime.installer.InstallerUtil;
import com.install4j.runtime.installer.config.AbstractConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.platform.win32.InstallRegistry;
import nanoxml.XMLElement;

public class WindowsSpecificConfig
extends AbstractConfig {
    private String programGroup = "";
    private boolean allowUserDisableStartMenuCreation = false;
    private boolean rebootInstaller = false;
    private boolean rebootUninstaller = false;
    private boolean quicklaunchIconIncluded = false;
    private boolean quicklaunchIconSelected = false;
    private InstallerConfig installerConfig;

    public WindowsSpecificConfig(InstallerConfig installerConfig) {
        this.installerConfig = installerConfig;
    }

    public String getProgramGroup() {
        String string;
        if (InstallerUtil.isWindows() && this.installerConfig.isSuggestPreviousLocations() && (string = InstallRegistry.getProgramGroup(this.installerConfig.getTargetApplicationId())) != null && string.trim().length() > 0) {
            return string;
        }
        return this.programGroup;
    }

    public boolean isAllowUserDisableStartMenuCreation() {
        return this.allowUserDisableStartMenuCreation;
    }

    public boolean isRebootInstaller() {
        return this.rebootInstaller;
    }

    public boolean isRebootUninstaller() {
        return this.rebootUninstaller;
    }

    public boolean isQuicklaunchIconIncluded() {
        return this.quicklaunchIconIncluded;
    }

    public boolean isQuicklaunchIconSelected() {
        return this.quicklaunchIconSelected;
    }

    protected void read(XMLElement xMLElement) {
        this.programGroup = WindowsSpecificConfig.readAttribute(xMLElement, "programGroup", this.programGroup);
        this.allowUserDisableStartMenuCreation = WindowsSpecificConfig.readAttribute(xMLElement, "allowUserDisableStartMenuCreation", this.allowUserDisableStartMenuCreation);
        this.rebootInstaller = WindowsSpecificConfig.readAttribute(xMLElement, "rebootInstaller", this.rebootInstaller);
        this.rebootUninstaller = WindowsSpecificConfig.readAttribute(xMLElement, "rebootUninstaller", this.rebootUninstaller);
        this.quicklaunchIconIncluded = WindowsSpecificConfig.readAttribute(xMLElement, "quicklaunchIconIncluded", this.quicklaunchIconIncluded);
        this.quicklaunchIconSelected = WindowsSpecificConfig.readAttribute(xMLElement, "quicklaunchIconSelected", this.quicklaunchIconSelected);
    }
}

