/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.auth;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.auth.AuthCommand;

public class KeyResponse
extends AuthCommand {
    private final ByteBlock key;

    protected KeyResponse(SnacPacket packet) {
        super(7);
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ByteBlock data = packet.getData();
        if (data.getLength() < 2) {
            this.key = null;
            return;
        }
        int len = BinaryTools.getUShort((ByteBlock)data, (int)0);
        this.key = data.subBlock(2, len);
    }

    public KeyResponse(ByteBlock key) {
        super(7);
        this.key = key;
    }

    public final ByteBlock getKey() {
        return this.key;
    }

    public void writeData(OutputStream out) throws IOException {
        int len = this.key == null ? 0 : (int)this.key.getWritableLength();
        BinaryTools.writeUShort((OutputStream)out, (int)len);
        if (this.key != null) {
            this.key.write(out);
        }
    }

    public String toString() {
        return "KeyResponse: key=" + BinaryTools.getAsciiString((ByteBlock)this.key);
    }
}

