/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.message;

import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jml.MsnContact;
import net.sf.jml.MsnProtocol;
import net.sf.jml.protocol.MsnSession;
import net.sf.jml.protocol.outgoing.OutgoingMSG;
import net.sf.jml.util.ByteBufferUtils;
import net.sf.jml.util.Charset;
import net.sf.jml.util.StringHolder;

public abstract class MsnMimeMessage {
    private static final Pattern charsetPattern = Pattern.compile(".*charset=([\\S&&[^;]]+).*", 2);
    private static final String KEY_MIME_VERSION = "MIME-Version";
    private static final String KEY_CONTENT_TYPE = "Content-Type";
    protected final StringHolder headers = new StringHolder();
    private static final ByteBuffer SPLIT = Charset.encode("\r\n\r\n");

    public MsnMimeMessage() {
        this.setMimeVersion("1.0");
    }

    public final StringHolder getHeaders() {
        return this.headers;
    }

    public final String getContentType() {
        return this.headers.getProperty(KEY_CONTENT_TYPE);
    }

    protected void setContentType(String string) {
        this.headers.setProperty(KEY_CONTENT_TYPE, string);
    }

    public final String getMimeVersion() {
        return this.headers.getProperty(KEY_MIME_VERSION);
    }

    protected void setMimeVersion(String string) {
        this.headers.setProperty(KEY_MIME_VERSION, string);
    }

    protected final String getCharset() {
        Matcher matcher;
        String string = this.getContentType();
        if (string != null && (matcher = charsetPattern.matcher(string)).matches()) {
            return matcher.group(1);
        }
        return "UTF-8";
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.headers.toString());
        stringBuffer.append("\r\n");
        return stringBuffer.toString();
    }

    public OutgoingMSG[] toOutgoingMsg(MsnProtocol msnProtocol) {
        OutgoingMSG outgoingMSG = new OutgoingMSG(msnProtocol);
        outgoingMSG.setMsg(Charset.encodeAsByteArray(this.toString()));
        outgoingMSG.setMsgType(OutgoingMSG.TYPE_ACKNOWLEDGE_WHEN_ERROR);
        return new OutgoingMSG[]{outgoingMSG};
    }

    protected void parseMessage(byte[] byArray) {
        int n = ByteBufferUtils.indexOf(ByteBuffer.wrap(byArray), SPLIT);
        this.headers.parseString(Charset.decode(ByteBuffer.wrap(byArray, 0, n >= 0 ? n : byArray.length)));
        int n2 = n + SPLIT.remaining();
        if (n >= 0 && n2 < byArray.length) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n2, byArray.length - n2);
            this.parseBuffer(byteBuffer);
        }
    }

    protected void parseBuffer(ByteBuffer byteBuffer) {
    }

    protected void messageReceived(MsnSession msnSession, MsnContact msnContact) {
    }
}

