/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.client.CallableClientRequest;
import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.core.EntryAdapter;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.MapEvent;
import com.hazelcast.map.impl.DataAwareEntryEvent;
import com.hazelcast.map.impl.EntryEventFilter;
import com.hazelcast.map.impl.MapPortableHook;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.QueryEventFilter;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.Predicate;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.EventFilter;
import com.hazelcast.spi.impl.PortableEntryEvent;
import java.security.Permission;

public abstract class AbstractMapAddEntryListenerRequest
extends CallableClientRequest
implements RetryableRequest {
    protected String name;
    protected Data key;
    protected boolean includeValue;

    public AbstractMapAddEntryListenerRequest() {
    }

    public AbstractMapAddEntryListenerRequest(String name, boolean includeValue) {
        this.name = name;
        this.includeValue = includeValue;
    }

    public AbstractMapAddEntryListenerRequest(String name, Data key, boolean includeValue) {
        this(name, includeValue);
        this.key = key;
    }

    protected abstract Predicate getPredicate();

    public Object call() {
        final ClientEndpoint endpoint = this.getEndpoint();
        MapService mapService = (MapService)this.getService();
        EntryAdapter<Object, Object> listener = new EntryAdapter<Object, Object>(){

            @Override
            public void onEntryEvent(EntryEvent<Object, Object> event) {
                if (endpoint.isAlive()) {
                    if (!(event instanceof DataAwareEntryEvent)) {
                        throw new IllegalArgumentException("Expecting: DataAwareEntryEvent, Found: " + event.getClass().getSimpleName());
                    }
                    DataAwareEntryEvent dataAwareEntryEvent = (DataAwareEntryEvent)event;
                    Data key = dataAwareEntryEvent.getKeyData();
                    Data value = dataAwareEntryEvent.getNewValueData();
                    Data oldValue = dataAwareEntryEvent.getOldValueData();
                    Data mergingValue = dataAwareEntryEvent.getMergingValueData();
                    PortableEntryEvent portableEntryEvent = new PortableEntryEvent(key, value, oldValue, mergingValue, event.getEventType(), event.getMember().getUuid());
                    endpoint.sendEvent(key, portableEntryEvent, AbstractMapAddEntryListenerRequest.this.getCallId());
                }
            }

            @Override
            public void onMapEvent(MapEvent event) {
                if (endpoint.isAlive()) {
                    EntryEventType type = event.getEventType();
                    String uuid = event.getMember().getUuid();
                    PortableEntryEvent portableEntryEvent = new PortableEntryEvent(type, uuid, event.getNumberOfEntriesAffected());
                    endpoint.sendEvent(null, portableEntryEvent, AbstractMapAddEntryListenerRequest.this.getCallId());
                }
            }
        };
        EventFilter eventFilter = this.getEventFilter();
        String registrationId = mapService.getMapServiceContext().addEventListener(listener, eventFilter, this.name);
        endpoint.setListenerRegistration("hz:impl:mapService", this.name, registrationId);
        return registrationId;
    }

    protected EventFilter getEventFilter() {
        if (this.getPredicate() == null) {
            return new EntryEventFilter(this.includeValue, this.key);
        }
        return new QueryEventFilter(this.includeValue, this.key, this.getPredicate());
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.name, "listen");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }
}

