/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.lock.client;

import com.hazelcast.client.impl.client.KeyBasedClientRequest;
import com.hazelcast.client.impl.client.SecureRequest;
import com.hazelcast.concurrent.lock.InternalLockNamespace;
import com.hazelcast.concurrent.lock.client.LockPortableHook;
import com.hazelcast.concurrent.lock.operations.BeforeAwaitOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.LockPermission;
import com.hazelcast.spi.ObjectNamespace;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;

public class BeforeAwaitRequest
extends KeyBasedClientRequest
implements Portable,
SecureRequest {
    private ObjectNamespace namespace;
    private Data key;
    private long threadId;
    private String conditionId;

    public BeforeAwaitRequest() {
    }

    public BeforeAwaitRequest(ObjectNamespace namespace, long threadId, String conditionId, Data key) {
        this.namespace = namespace;
        this.threadId = threadId;
        this.conditionId = conditionId;
        this.key = key;
    }

    @Override
    protected Object getKey() {
        return this.key;
    }

    @Override
    protected Operation prepareOperation() {
        return new BeforeAwaitOperation(this.namespace, this.key, this.threadId, this.conditionId);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:lockService";
    }

    @Override
    public int getFactoryId() {
        return LockPortableHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 7;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeLong("tid", this.threadId);
        writer.writeUTF("cid", this.conditionId);
        ObjectDataOutput out = writer.getRawDataOutput();
        this.namespace.writeData(out);
        out.writeData(this.key);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.threadId = reader.readLong("tid");
        this.conditionId = reader.readUTF("cid");
        ObjectDataInput in = reader.getRawDataInput();
        this.namespace = new InternalLockNamespace();
        this.namespace.readData(in);
        this.key = in.readData();
    }

    @Override
    public Permission getRequiredPermission() {
        return new LockPermission(this.namespace.getObjectName(), "lock");
    }
}

