/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.atomicreference.client;

import com.hazelcast.client.ClientEngine;
import com.hazelcast.client.impl.client.PartitionClientRequest;
import com.hazelcast.client.impl.client.SecureRequest;
import com.hazelcast.concurrent.atomicreference.client.AtomicReferencePortableHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.AtomicReferencePermission;
import java.io.IOException;
import java.security.Permission;

public abstract class ModifyRequest
extends PartitionClientRequest
implements Portable,
SecureRequest {
    String name;
    Data update;

    public ModifyRequest() {
    }

    public ModifyRequest(String name, Data update) {
        this.name = name;
        this.update = update;
    }

    @Override
    protected int getPartition() {
        ClientEngine clientEngine = this.getClientEngine();
        Object key = this.serializationService.toData(this.name);
        return clientEngine.getPartitionService().getPartitionId((Data)key);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:atomicReferenceService";
    }

    @Override
    public int getFactoryId() {
        return AtomicReferencePortableHook.F_ID;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeData(this.update);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        ObjectDataInput in = reader.getRawDataInput();
        this.update = in.readData();
    }

    @Override
    public Permission getRequiredPermission() {
        return new AtomicReferencePermission(this.name, "modify");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }
}

