/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.stream;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import weblogic.xml.babel.baseparser.SAXElementFactory;
import weblogic.xml.babel.stream.CanonicalUtils;
import weblogic.xml.babel.stream.CanonicalWriter;
import weblogic.xml.babel.stream.XMLInputStreamBase;
import weblogic.xml.babel.stream.XMLOutputStreamBase;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.AttributeIterator;
import weblogic.xml.stream.ElementFactory;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLStreamException;

public class ExclusiveCanonicalWriter
extends CanonicalWriter {
    private boolean firstElement = true;

    public ExclusiveCanonicalWriter(Writer writer) {
        super(writer);
    }

    public ExclusiveCanonicalWriter(Writer writer, Map map) {
        super(writer, map);
    }

    private List addNSAttribute(String string, String string2, List arrayList) {
        if (string == null) {
            return arrayList;
        }
        this.getScopedNamespaces().checkPrefixMap(string, string2);
        if (this.getScopedNamespaces().needToWriteNS(string)) {
            if (arrayList == null) {
                arrayList = new ArrayList<Attribute>();
            }
            if ("".equals(string)) {
                string = null;
            }
            arrayList.add(ElementFactory.createNamespaceAttribute((String)string, (String)string2));
        }
        return arrayList;
    }

    public List checkPrefix(String string, String string2, List list) {
        if (string2 == null) {
            return list;
        }
        if (string == null) {
            return this.addNSAttribute("", string2, list);
        }
        if ("xml".equals(string)) {
            return list;
        }
        return this.addNSAttribute(string, string2, list);
    }

    public List checkAndDeclareNamespacePrefixes(StartElement startElement) throws XMLStreamException {
        Object object;
        AttributeIterator attributeIterator;
        AttributeIterator attributeIterator2;
        String string = startElement.getName().getPrefix();
        String string2 = startElement.getName().getNamespaceUri();
        List list = this.checkPrefix(string, string2, null);
        boolean bl = false;
        if (list != null && "xmlns".equals((attributeIterator2 = (Attribute)list.get(0)).getName().getLocalName())) {
            bl = true;
        }
        attributeIterator2 = startElement.getNamespaces();
        while (attributeIterator2.hasNext()) {
            attributeIterator = attributeIterator2.next();
            if (!"xmlns".equals(attributeIterator.getName().getLocalName())) continue;
            object = attributeIterator.getValue();
            if (object == null) {
                object = "";
            }
            if (bl) continue;
            list = this.checkPrefix(null, (String)object, list);
        }
        attributeIterator = startElement.getAttributes();
        while (attributeIterator.hasNext()) {
            object = attributeIterator.next();
            list = this.checkPrefix(object.getName().getPrefix(), object.getName().getNamespaceUri(), list);
        }
        return list;
    }

    public void write(StartElement startElement) throws XMLStreamException {
        this.incrementLevel();
        this.getScopedNamespaces().openScope();
        this.write('<');
        this.write(startElement.getName());
        List list = this.checkAndDeclareNamespacePrefixes(startElement);
        if (this.firstElement) {
            if (list != null) {
                this.writeNamespaces(CanonicalUtils.sortNamespaces(ElementFactory.createAttributeIterator(list.iterator()), this.declareParentNamespaces(this.getExternalNamespaces())));
            } else {
                this.writeNamespaces(CanonicalUtils.sortNamespaces(this.declareParentNamespaces(this.getExternalNamespaces())));
            }
            this.firstElement = false;
        } else if (list != null) {
            this.writeNamespaces(CanonicalUtils.sortNamespaces(ElementFactory.createAttributeIterator(list.iterator())));
        }
        this.write(CanonicalUtils.sortAttributes(startElement.getAttributes()));
        this.write('>');
    }

    public AttributeIterator declareParentNamespaces(Map map) {
        TreeMap<String, Attribute> treeMap = new TreeMap<String, Attribute>();
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getValue();
                if (string.equals("http://www.w3.org/XML/1998/namespace")) continue;
                String string2 = (String)entry.getKey();
                if (string2.equals("")) {
                    string2 = null;
                }
                Attribute attribute = ElementFactory.createNamespaceAttribute((String)string2, (String)string);
                treeMap.put(attribute.getName().getQualifiedName(), attribute);
            }
        }
        return ElementFactory.createAttributeIterator(treeMap.values().iterator());
    }

    public static void main(String[] stringArray) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("test", "http://testuri.org");
        ExclusiveCanonicalWriter exclusiveCanonicalWriter = new ExclusiveCanonicalWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("out.xml"), "utf-8"), hashMap);
        XMLInputStreamBase xMLInputStreamBase = new XMLInputStreamBase();
        xMLInputStreamBase.openValidating(SAXElementFactory.createInputSource(stringArray[0]));
        xMLInputStreamBase.skip(2);
        xMLInputStreamBase.next();
        XMLOutputStreamBase xMLOutputStreamBase = new XMLOutputStreamBase(exclusiveCanonicalWriter);
        xMLOutputStreamBase.add(xMLInputStreamBase.getSubStream());
        xMLOutputStreamBase.flush();
    }
}

