/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.stream;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import weblogic.xml.babel.stream.XMLWriter;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.AttributeIterator;
import weblogic.xml.stream.ChangePrefixMapping;
import weblogic.xml.stream.CharacterData;
import weblogic.xml.stream.Comment;
import weblogic.xml.stream.EndDocument;
import weblogic.xml.stream.EndElement;
import weblogic.xml.stream.EndPrefixMapping;
import weblogic.xml.stream.EntityReference;
import weblogic.xml.stream.ProcessingInstruction;
import weblogic.xml.stream.Space;
import weblogic.xml.stream.StartDocument;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.StartPrefixMapping;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLStreamException;

public class SAXEventWriter
extends XMLWriter {
    ContentHandler contentHandler;

    public SAXEventWriter() {
    }

    public SAXEventWriter(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    protected void check() throws XMLStreamException {
        if (this.contentHandler == null) {
            throw new XMLStreamException("Null handler in SAXEventWriter");
        }
    }

    public static String nullToEmptyString(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    public static Attributes createAttributes(AttributeIterator attributeIterator) {
        AttributesImpl attributesImpl = new AttributesImpl();
        while (attributeIterator.hasNext()) {
            Attribute attribute = attributeIterator.next();
            attributesImpl.addAttribute(SAXEventWriter.nullToEmptyString(attribute.getName().getNamespaceUri()), attribute.getName().getLocalName(), attribute.getName().getQualifiedName(), attribute.getType(), attribute.getValue());
        }
        return attributesImpl;
    }

    public void write(StartElement startElement) throws XMLStreamException {
        this.check();
        XMLName xMLName = startElement.getName();
        Attributes attributes = this.writeElementNameSpaces ? SAXEventWriter.createAttributes(startElement.getAttributesAndNamespaces()) : SAXEventWriter.createAttributes(startElement.getAttributes());
        try {
            this.contentHandler.startElement(SAXEventWriter.nullToEmptyString(xMLName.getNamespaceUri()), xMLName.getLocalName(), xMLName.getQualifiedName(), attributes);
        }
        catch (SAXException sAXException) {
            throw new XMLStreamException((Throwable)sAXException);
        }
    }

    public void write(EndElement endElement) throws XMLStreamException {
        try {
            this.contentHandler.endElement(SAXEventWriter.nullToEmptyString(endElement.getName().getNamespaceUri()), endElement.getName().getLocalName(), endElement.getName().getQualifiedName());
        }
        catch (SAXException sAXException) {
            throw new XMLStreamException((Throwable)sAXException);
        }
    }

    public void write(ProcessingInstruction processingInstruction) throws XMLStreamException {
        try {
            this.contentHandler.processingInstruction(SAXEventWriter.nullToEmptyString(processingInstruction.getTarget()), SAXEventWriter.nullToEmptyString(processingInstruction.getData()));
        }
        catch (SAXException sAXException) {
            throw new XMLStreamException((Throwable)sAXException);
        }
    }

    public void write(CharacterData characterData) throws XMLStreamException {
        try {
            if (characterData.hasContent()) {
                this.contentHandler.characters(characterData.getContent().toCharArray(), 0, characterData.getContent().length());
            }
        }
        catch (SAXException sAXException) {
            throw new XMLStreamException((Throwable)sAXException);
        }
    }

    public void write(StartDocument startDocument) throws XMLStreamException {
        try {
            this.contentHandler.startDocument();
        }
        catch (SAXException sAXException) {
            throw new XMLStreamException((Throwable)sAXException);
        }
    }

    public void write(EndDocument endDocument) throws XMLStreamException {
        try {
            this.contentHandler.endDocument();
        }
        catch (SAXException sAXException) {
            throw new XMLStreamException((Throwable)sAXException);
        }
    }

    public void write(Comment comment) throws XMLStreamException {
    }

    public void write(StartPrefixMapping startPrefixMapping) throws XMLStreamException {
        try {
            this.contentHandler.startPrefixMapping(startPrefixMapping.getPrefix(), startPrefixMapping.getNamespaceUri());
        }
        catch (SAXException sAXException) {
            throw new XMLStreamException((Throwable)sAXException);
        }
    }

    public void write(ChangePrefixMapping changePrefixMapping) throws XMLStreamException {
        try {
            this.contentHandler.endPrefixMapping(changePrefixMapping.getPrefix());
        }
        catch (SAXException sAXException) {
            throw new XMLStreamException((Throwable)sAXException);
        }
    }

    public void write(EndPrefixMapping endPrefixMapping) throws XMLStreamException {
        try {
            this.contentHandler.endPrefixMapping(endPrefixMapping.getPrefix());
        }
        catch (SAXException sAXException) {
            throw new XMLStreamException((Throwable)sAXException);
        }
    }

    public void write(EntityReference entityReference) throws XMLStreamException {
        try {
            this.contentHandler.skippedEntity(entityReference.getName().getQualifiedName());
        }
        catch (SAXException sAXException) {
            throw new XMLStreamException((Throwable)sAXException);
        }
    }

    public void write(Space space) throws XMLStreamException {
        this.write((CharacterData)space);
    }

    public void flush() throws XMLStreamException {
    }

    public boolean write(XMLEvent xMLEvent) throws XMLStreamException {
        switch (xMLEvent.getType()) {
            case 2: {
                this.write((StartElement)xMLEvent);
                break;
            }
            case 4: {
                this.write((EndElement)xMLEvent);
                break;
            }
            case 8: {
                this.write((ProcessingInstruction)xMLEvent);
                break;
            }
            case 16: {
                this.write((CharacterData)xMLEvent);
                break;
            }
            case 32: {
                this.write((Comment)xMLEvent);
                break;
            }
            case 256: {
                this.write((StartDocument)xMLEvent);
                break;
            }
            case 512: {
                this.write((EndDocument)xMLEvent);
                break;
            }
            case 1024: {
                this.write((StartPrefixMapping)xMLEvent);
                break;
            }
            case 2048: {
                this.write((EndPrefixMapping)xMLEvent);
                break;
            }
            case 4096: {
                this.write((ChangePrefixMapping)xMLEvent);
                break;
            }
            case 8192: {
                this.write((EntityReference)xMLEvent);
                break;
            }
            case 64: {
                this.write((Space)xMLEvent);
                break;
            }
            case 128: {
                throw new XMLStreamException("Attempt to write a null element.");
            }
            default: {
                throw new XMLStreamException("Attempt to write unknown element [" + xMLEvent.getType() + "]");
            }
        }
        return true;
    }

    public static SAXEventWriter getWriter(ContentHandler contentHandler) throws XMLStreamException {
        SAXEventWriter sAXEventWriter = new SAXEventWriter();
        sAXEventWriter.setContentHandler(contentHandler);
        sAXEventWriter.setWriteHeader(false);
        sAXEventWriter.setWriteElementNameSpaces(true);
        sAXEventWriter.setWriteAll(true);
        sAXEventWriter.setShowNamespaceBindings(true);
        sAXEventWriter.setNormalizeWhiteSpace(false);
        return sAXEventWriter;
    }
}

