/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.network;

import java.net.MalformedURLException;
import java.util.StringTokenizer;
import java.util.Vector;

public final class VURL {
    private VURL contextURL;
    private String rawURL;
    private String protocol;
    private String loginPassword;
    private String host;
    private int port;
    private String path;
    private String file;
    private String parameters;
    private String anchor;

    public VURL(String spec) throws MalformedURLException {
        this(null, spec);
    }

    public VURL(VURL context, String target) throws MalformedURLException {
        this.contextURL = context;
        this.rawURL = target;
        this.port = -1;
        this.compose();
    }

    public String getCompleteURL() {
        StringBuffer result = new StringBuffer(100);
        this.appendBasicURLComponents(result, true);
        if (this.parameters != null) {
            result.append(this.parameters);
        }
        if (this.anchor != null) {
            result.append('#');
            result.append(this.anchor);
        }
        return result.toString();
    }

    public String getCompleteURLWithoutAnchor() {
        StringBuffer result = new StringBuffer(100);
        this.appendBasicURLComponents(result, true);
        if (this.parameters != null) {
            result.append(this.parameters);
        }
        return result.toString();
    }

    public String getCompleteURLWithoutAnchorOrAuth() {
        StringBuffer result = new StringBuffer(100);
        this.appendBasicURLComponentsNoAuth(result, true);
        if (this.parameters != null) {
            result.append(this.parameters);
        }
        return result.toString();
    }

    public String getLoginPassword() {
        return this.loginPassword;
    }

    public String getRawURL() {
        return this.rawURL;
    }

    public String getBasicURL() {
        StringBuffer result = new StringBuffer(100);
        this.appendBasicURLComponents(result, true);
        return result.toString();
    }

    public boolean equals(Object obj) {
        VURL other = (VURL)obj;
        return other.toString().equals(this.toString());
    }

    public String getBasicURLNoFile() {
        StringBuffer result = new StringBuffer(100);
        this.appendBasicURLComponents(result, false);
        return result.toString();
    }

    public String getFile() {
        if (this.file == null) {
            return "";
        }
        return this.file;
    }

    public String getFileNoPath() {
        if (this.file == null) {
            return "";
        }
        int idx = this.file.lastIndexOf(47);
        if (idx != -1) {
            return this.file.substring(idx + 1);
        }
        return this.file;
    }

    public String getSlotList() throws MalformedURLException {
        if (this.protocol == null || !this.protocol.equalsIgnoreCase("gram")) {
            throw new MalformedURLException("Not a GRAM URL: " + this.rawURL);
        }
        return this.path;
    }

    public String getGrammarRule() throws MalformedURLException {
        if (this.protocol == null || !this.protocol.equalsIgnoreCase("gram")) {
            throw new MalformedURLException("Not a GRAM URL: " + this.rawURL);
        }
        return this.host;
    }

    public String getPrompt() throws MalformedURLException {
        if (this.protocol == null || !this.protocol.equalsIgnoreCase("prompt")) {
            throw new MalformedURLException("Not a PROMPT URL: " + this.rawURL);
        }
        return this.host;
    }

    public String getPath() {
        if (this.path == null) {
            return "/";
        }
        return this.path;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getAnchor() {
        return this.anchor;
    }

    public String getParameters() {
        if (this.parameters == null) {
            return "";
        }
        return this.parameters;
    }

    public String toString() {
        return this.getCompleteURL();
    }

    public boolean isLocalURL() {
        return this.protocol == null || !this.protocol.startsWith("http");
    }

    public boolean specifiedAsAnchorOnly() {
        return this.rawURL != null && this.rawURL.startsWith("#");
    }

    private void compose() throws MalformedURLException {
        if (this.rawURL == null) {
            throw new MalformedURLException("Null URL");
        }
        try {
            if (this.rawURL.startsWith("/") || this.rawURL.startsWith("\\")) {
                if (this.contextURL == null) {
                    throw new MalformedURLException("No context URL was given for: " + this.rawURL);
                }
                this.protocol = this.contextURL.getProtocol();
                this.loginPassword = this.contextURL.getLoginPassword();
                this.host = this.contextURL.getHost();
                this.port = this.contextURL.getPort();
                this.extractComponents(this.rawURL, false, false, false, true, true, true, true);
            } else if (this.specifiedAsAnchorOnly()) {
                if (this.contextURL == null) {
                    throw new MalformedURLException("No context URL was given for: " + this.rawURL);
                }
                this.protocol = this.contextURL.getProtocol();
                this.loginPassword = this.contextURL.getLoginPassword();
                this.host = this.contextURL.getHost();
                this.port = this.contextURL.getPort();
                this.path = this.contextURL.getPath();
                this.file = this.contextURL.getFile();
                this.parameters = null;
                this.extractComponents(this.rawURL, false, false, false, false, false, true, false);
            } else {
                boolean knownType = true;
                String lowercaseURL = this.rawURL.toLowerCase();
                if (lowercaseURL.startsWith("gram://")) {
                    this.protocol = "gram";
                } else if (lowercaseURL.startsWith("http://")) {
                    this.protocol = "http";
                } else if (lowercaseURL.startsWith("https://")) {
                    this.protocol = "https";
                } else if (lowercaseURL.startsWith("file://")) {
                    this.protocol = "file";
                } else if (lowercaseURL.startsWith("dtmf:")) {
                    this.protocol = "dtmf";
                } else if (lowercaseURL.startsWith("prompt://")) {
                    this.protocol = "prompt";
                } else if (lowercaseURL.startsWith("builtin://")) {
                    this.protocol = "builtin";
                } else {
                    knownType = false;
                }
                if (knownType) {
                    this.extractComponents(this.rawURL, true, true, true, true, true, true, true);
                } else if (this.rawURL.indexOf("://") == -1 && this.contextURL != null && !"dtmf".equals(this.protocol)) {
                    if (this.rawURL.startsWith("./")) {
                        this.rawURL = this.rawURL.substring(2);
                    }
                    this.protocol = this.contextURL.getProtocol();
                    this.loginPassword = this.contextURL.getLoginPassword();
                    this.host = this.contextURL.getHost();
                    this.port = this.contextURL.getPort();
                    String contextPath = this.contextURL.getPath();
                    this.extractComponents(this.rawURL, false, false, false, true, true, true, true);
                    if (contextPath != null && this.path != null) {
                        this.path = this.joinPaths(contextPath, this.path);
                    } else if (contextPath != null) {
                        this.path = contextPath;
                    }
                } else {
                    if (this.contextURL == null) {
                        throw new MalformedURLException("No context URL was given for: " + this.rawURL);
                    }
                    throw new MalformedURLException("Unrecognized protocol: " + this.rawURL);
                }
            }
            if (this.host != null && (this.host.indexOf(63) != -1 || this.host.indexOf(35) != -1)) {
                throw new MalformedURLException("Bad host: " + this.rawURL);
            }
            if (this.path != null && (this.path.indexOf(63) != -1 || this.path.indexOf(35) != -1)) {
                throw new MalformedURLException("Bad path: " + this.rawURL);
            }
            if (this.file != null && (this.file.indexOf(63) != -1 || this.file.indexOf(35) != -1)) {
                throw new MalformedURLException("Bad file: " + this.rawURL);
            }
        }
        catch (Exception e) {
            throw new MalformedURLException("Error parsing URL.  Context URL: " + this.contextURL + " URL: " + this.rawURL + " Exception: " + e.getMessage());
        }
    }

    private void extractComponents(String url, boolean setProtocol, boolean setHost, boolean setPort, boolean setPath, boolean setFile, boolean setAnchor, boolean setParameters) throws MalformedURLException {
        int protocolEnd;
        if (setProtocol && !"dtmf".equals(this.protocol)) {
            int protocolEnd2 = url.indexOf("://");
            this.protocol = protocolEnd2 != -1 ? url.substring(0, protocolEnd2) : null;
        }
        if (setHost || setPort) {
            String prot = "";
            protocolEnd = url.indexOf("://");
            if (protocolEnd == -1) {
                protocolEnd = 0;
            } else {
                prot = url.substring(0, protocolEnd);
                protocolEnd += 3;
            }
            String theHost = null;
            int thePort = -1;
            if (prot.startsWith("http") || prot.equalsIgnoreCase("gram") || prot.equalsIgnoreCase("prompt")) {
                int hostAndPortEnd = url.indexOf(47, protocolEnd);
                String hostAndPort = hostAndPortEnd == -1 ? url.substring(protocolEnd) : url.substring(protocolEnd, hostAndPortEnd);
                int hostStart = 0;
                int atsign = hostAndPort.indexOf(64);
                if (atsign != -1) {
                    this.loginPassword = hostAndPort.substring(hostStart, atsign);
                    hostStart = atsign + 1;
                } else {
                    this.loginPassword = null;
                }
                int ipv6end = hostAndPort.indexOf(93, hostStart);
                int colon = ipv6end != -1 ? hostAndPort.indexOf(58, ipv6end) : hostAndPort.indexOf(58, hostStart);
                if (colon == -1) {
                    theHost = hostAndPort.substring(hostStart);
                } else {
                    theHost = hostAndPort.substring(hostStart, colon);
                    String thePortString = hostAndPort.substring(colon + 1);
                    try {
                        thePort = Integer.parseInt(thePortString);
                    }
                    catch (NumberFormatException e) {
                        throw new MalformedURLException("Invalid port: " + thePortString);
                    }
                }
            }
            if (setHost) {
                this.host = theHost;
            }
            if (setPort) {
                this.port = thePort;
            }
        }
        if (setPath || setFile) {
            String theFile;
            String thePath;
            int fileEnd;
            String prot = "";
            protocolEnd = url.indexOf("://");
            if (protocolEnd == -1) {
                protocolEnd = 0;
            } else {
                prot = url.substring(0, protocolEnd);
                protocolEnd += 3;
            }
            int hostEnd = protocolEnd;
            if (!prot.equals("") && !prot.equalsIgnoreCase("file") && (hostEnd = url.indexOf(47, protocolEnd)) == -1) {
                hostEnd = url.length();
            }
            if ((fileEnd = url.indexOf(63)) == -1) {
                String anchorStr;
                int anchorStart = url.lastIndexOf(35);
                if (anchorStart != -1 && ((anchorStr = url.substring(anchorStart)).indexOf(38) != -1 || anchorStr.indexOf(61) != -1)) {
                    anchorStart = -1;
                }
                fileEnd = anchorStart;
            }
            if (fileEnd == -1) {
                fileEnd = url.length();
            }
            if (fileEnd < hostEnd) {
                throw new MalformedURLException("Bad host/file position");
            }
            String pathAndFile = url.substring(hostEnd, fileEnd);
            int lastSlash = pathAndFile.lastIndexOf(47);
            int lastBackslash = pathAndFile.lastIndexOf(92);
            int pathEnd = -1;
            if (prot.equalsIgnoreCase("gram") || prot.equalsIgnoreCase("prompt")) {
                pathEnd = pathAndFile.length() - 1;
            } else {
                int n = pathEnd = lastSlash < lastBackslash ? lastBackslash : lastSlash;
            }
            if (pathEnd == -1) {
                thePath = null;
                theFile = pathAndFile;
            } else {
                thePath = pathAndFile.substring(0, pathEnd + 1);
                theFile = pathAndFile.substring(pathEnd + 1);
            }
            if (theFile.length() == 0) {
                theFile = null;
            }
            if (setFile) {
                this.file = theFile;
            }
            if (setPath) {
                this.path = thePath;
            }
        }
        if (setAnchor || setParameters) {
            String theAnchor = null;
            int anchorStart = url.lastIndexOf(35);
            if (anchorStart != -1) {
                String anchorStr = url.substring(anchorStart + 1);
                if (anchorStr.indexOf(38) == -1 && anchorStr.indexOf(61) == -1) {
                    theAnchor = anchorStr;
                } else {
                    anchorStart = -1;
                }
            }
            if (setAnchor) {
                this.anchor = theAnchor;
            }
            if (setParameters) {
                String theParameters = null;
                int parameterStart = url.indexOf(63);
                if (parameterStart != -1) {
                    theParameters = anchorStart == -1 ? url.substring(parameterStart) : url.substring(parameterStart, anchorStart);
                }
                this.parameters = theParameters;
            }
        }
    }

    private void appendBasicURLComponents(StringBuffer buffer, boolean includeFile) {
        if ("dtmf".equals(this.protocol)) {
            buffer.append(this.file);
            return;
        }
        if (this.protocol != null) {
            buffer.append(this.protocol);
            buffer.append("://");
        }
        if (this.loginPassword != null && this.host != null) {
            buffer.append(this.loginPassword);
            buffer.append('@');
        }
        if (this.host != null) {
            buffer.append(this.host);
        }
        if (this.port != -1) {
            buffer.append(':');
            buffer.append(this.port);
        }
        if (this.path != null) {
            buffer.append(this.path);
        } else {
            buffer.append('/');
        }
        if (includeFile && this.file != null) {
            buffer.append(this.file);
        }
    }

    private void appendBasicURLComponentsNoAuth(StringBuffer buffer, boolean includeFile) {
        if (this.protocol != null) {
            buffer.append(this.protocol);
            buffer.append("://");
        }
        if (this.host != null) {
            buffer.append(this.host);
        }
        if (this.port != -1) {
            buffer.append(':');
            buffer.append(this.port);
        }
        if (this.path != null) {
            buffer.append(this.path);
        } else {
            buffer.append('/');
        }
        if (includeFile && this.file != null) {
            buffer.append(this.file);
        }
    }

    private String joinPaths(String context_path, String relative_path) {
        if (context_path.indexOf("../") == -1 && relative_path.indexOf("../") == -1) {
            return context_path + relative_path;
        }
        Vector<String> components = new Vector<String>();
        StringTokenizer st = new StringTokenizer(context_path, "/");
        while (st.hasMoreTokens()) {
            components.addElement(st.nextToken());
        }
        st = new StringTokenizer(relative_path, "/");
        while (st.hasMoreTokens()) {
            components.addElement(st.nextToken());
        }
        for (int i = components.size() - 1; i > 0; --i) {
            String component = (String)components.elementAt(i);
            if (!component.equals(".")) continue;
            components.removeElementAt(i);
        }
        StringBuffer joined_path = new StringBuffer();
        int num_to_skip = 0;
        for (int i = components.size() - 1; i >= 0; --i) {
            String component = (String)components.elementAt(i);
            if (component.equals(".")) {
                while (num_to_skip > 0) {
                    joined_path.insert(0, "../");
                    --num_to_skip;
                }
                joined_path.insert(0, "./");
                continue;
            }
            if (component.equals("..")) {
                ++num_to_skip;
                continue;
            }
            if (num_to_skip > 0) {
                --num_to_skip;
                continue;
            }
            joined_path.insert(0, component + "/");
        }
        while (num_to_skip > 0) {
            joined_path.insert(0, "../");
            --num_to_skip;
        }
        if (!joined_path.toString().startsWith(".")) {
            joined_path.insert(0, "/");
        }
        return joined_path.toString();
    }
}

