/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icq;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.LEBinaryTools;
import net.kano.joscar.OscarTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.icq.AbstractIcqCmd;
import net.kano.joscar.snaccmd.icq.FromIcqCmd;

public class OfflineMsgIcqCmd
extends FromIcqCmd {
    private long fromUIN;
    private Calendar cal;
    private int msgType;
    private String contents;

    protected OfflineMsgIcqCmd(SnacPacket packet) {
        super(packet);
        ByteBlock block = this.getIcqData();
        this.fromUIN = LEBinaryTools.getUInt(block, 0);
        this.cal = new GregorianCalendar(LEBinaryTools.getUShort(block, 4), LEBinaryTools.getUByte(block, 6), LEBinaryTools.getUByte(block, 7), LEBinaryTools.getUByte(block, 8), LEBinaryTools.getUByte(block, 9));
        this.msgType = LEBinaryTools.getUShort(block, 10);
        int textlen = LEBinaryTools.getUShort(block, 12) - 1;
        block = block.subBlock(14, textlen);
        this.contents = OscarTools.getString(block, "US-ASCII");
    }

    public OfflineMsgIcqCmd(long ownerUIN, int id, long uin, Date date, int msgType, String contents) {
        super(ownerUIN, AbstractIcqCmd.CMD_OFFLINE_MSG, id);
        this.fromUIN = uin;
        this.cal = new GregorianCalendar();
        this.cal.setTime(date);
        this.msgType = msgType;
        this.contents = contents;
    }

    public void writeIcqData(OutputStream out) throws IOException {
        LEBinaryTools.writeUInt(out, this.fromUIN);
        LEBinaryTools.writeUShort(out, this.cal.get(1));
        LEBinaryTools.writeUByte(out, this.cal.get(2));
        LEBinaryTools.writeUByte(out, this.cal.get(5));
        LEBinaryTools.writeUByte(out, this.cal.get(11));
        LEBinaryTools.writeUByte(out, this.cal.get(12));
        LEBinaryTools.writeUShort(out, this.msgType);
        LEBinaryTools.writeUShort(out, this.contents.length() + 1);
        byte[] bytes = BinaryTools.getAsciiBytes((String)(this.contents + '\u0000'));
        out.write(bytes);
    }

    public Date getDate() {
        return this.cal.getTime();
    }

    public String getContents() {
        return this.contents;
    }

    public long getFromUIN() {
        return this.fromUIN;
    }

    public int getMsgType() {
        return this.msgType;
    }

    public String toString() {
        return "OfflineMsgIcqCmd: <" + this.getContents() + "> in: " + super.toString();
    }
}

