/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.ssi;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ssi.SsiCommand;
import net.kano.joscar.snaccmd.ssi.SsiItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SsiDataCmd
extends SsiCommand {
    public static final int VERSION_DEFAULT = 0;
    private final int version;
    private final List<SsiItem> items;
    private final long lastmod;

    protected SsiDataCmd(SnacPacket snacPacket) {
        super(6);
        SsiItem ssiItem;
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        this.version = BinaryTools.getUByte(byteBlock, 0);
        int n = BinaryTools.getUShort(byteBlock, 1);
        ArrayList<SsiItem> arrayList = new ArrayList<SsiItem>();
        ByteBlock byteBlock2 = byteBlock.subBlock(3);
        for (int i = 0; i < n && (ssiItem = SsiItem.readSsiItem(byteBlock2)) != null; ++i) {
            arrayList.add(ssiItem);
            byteBlock2 = byteBlock2.subBlock(ssiItem.getTotalSize());
        }
        this.items = DefensiveTools.getUnmodifiable(arrayList);
        this.lastmod = BinaryTools.getUInt(byteBlock2, 0);
    }

    public SsiDataCmd(Collection<? extends SsiItem> collection, long l) {
        this(0, collection, l);
    }

    public SsiDataCmd(int n, Collection<? extends SsiItem> collection, long l) {
        super(6);
        DefensiveTools.checkRange(n, "version", 0);
        DefensiveTools.checkRange(l, "lastmod", 0L);
        List<? extends SsiItem> list = DefensiveTools.getSafeNonnullListCopy(collection, "items");
        this.version = n;
        this.items = list;
        this.lastmod = l;
    }

    public final int getSsiVersion() {
        return this.version;
    }

    public final List<SsiItem> getItems() {
        return this.items;
    }

    public final long getLastModDate() {
        return this.lastmod;
    }

    @Override
    public void writeData(OutputStream outputStream) throws IOException {
        BinaryTools.writeUByte(outputStream, this.version);
        BinaryTools.writeUShort(outputStream, this.items.size());
        for (SsiItem ssiItem : this.items) {
            ssiItem.write(outputStream);
        }
        BinaryTools.writeUInt(outputStream, this.lastmod);
    }

    public String toString() {
        return "SsiDataCmd (ssi version=" + this.version + "): " + this.items.size() + " items, modified " + new Date(this.lastmod * 1000L);
    }
}

