/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.Writable;
import net.kano.joscar.snaccmd.WarningLevel;
import org.jetbrains.annotations.Nullable;

public class ParamInfo
implements Writable {
    public static final int MAXCHAN_DEFAULT = 0;
    public static final long FLAG_CHANMSGS_ALLOWED = 1L;
    public static final long FLAG_MISSEDCALLS_ALLOWED = 2L;
    public static final long FLAG_TYPING_NOTIFICATION = 8L;
    private final int maxChannel;
    private final long flags;
    private final int maxMsgLen;
    private final WarningLevel maxSenderWarning;
    private final WarningLevel maxReceiverWarning;
    private final long minMsgInterval;

    @Nullable
    protected static ParamInfo readParamInfo(ByteBlock byteBlock) {
        DefensiveTools.checkNull(byteBlock, "block");
        if (byteBlock.getLength() < 16) {
            return null;
        }
        int n = BinaryTools.getUShort(byteBlock, 0);
        long l = BinaryTools.getUInt(byteBlock, 2);
        int n2 = BinaryTools.getUShort(byteBlock, 6);
        WarningLevel warningLevel = WarningLevel.getInstanceFromX10(BinaryTools.getUShort(byteBlock, 8));
        WarningLevel warningLevel2 = WarningLevel.getInstanceFromX10(BinaryTools.getUShort(byteBlock, 10));
        long l2 = BinaryTools.getUInt(byteBlock, 12);
        return new ParamInfo(n, l, n2, warningLevel, warningLevel2, l2);
    }

    public ParamInfo(long l, int n, WarningLevel warningLevel, WarningLevel warningLevel2, long l2) {
        this(0, l, n, warningLevel, warningLevel2, l2);
    }

    public ParamInfo(int n, long l, int n2, WarningLevel warningLevel, WarningLevel warningLevel2, long l2) {
        DefensiveTools.checkRange(n, "maxChannel", 0);
        DefensiveTools.checkRange(l, "flags", 0L);
        DefensiveTools.checkRange(n2, "maxMsgLen", 0);
        DefensiveTools.checkNull(warningLevel, "maxSenderWarning");
        DefensiveTools.checkNull(warningLevel2, "maxReceiverWarning");
        DefensiveTools.checkRange(l2, "minMsgInterval", 0L);
        this.maxChannel = n;
        this.flags = l;
        this.maxMsgLen = n2;
        this.maxSenderWarning = warningLevel;
        this.maxReceiverWarning = warningLevel2;
        this.minMsgInterval = l2;
    }

    public final int getMaxChannel() {
        return this.maxChannel;
    }

    public final long getFlags() {
        return this.flags;
    }

    public final int getMaxMsgLen() {
        return this.maxMsgLen;
    }

    public final WarningLevel getMaxSenderWarning() {
        return this.maxSenderWarning;
    }

    public final WarningLevel getMaxReceiverWarning() {
        return this.maxReceiverWarning;
    }

    public final long getMinMsgInterval() {
        return this.minMsgInterval;
    }

    public long getWritableLength() {
        return 16L;
    }

    public void write(OutputStream outputStream) throws IOException {
        BinaryTools.writeUShort(outputStream, this.maxChannel);
        BinaryTools.writeUInt(outputStream, this.flags);
        BinaryTools.writeUShort(outputStream, this.maxMsgLen);
        BinaryTools.writeUShort(outputStream, this.maxSenderWarning.getX10Value());
        BinaryTools.writeUShort(outputStream, this.maxReceiverWarning.getX10Value());
        BinaryTools.writeUInt(outputStream, this.minMsgInterval);
    }

    public String toString() {
        return "ParamInfo: maxChannel=" + this.maxChannel + ", flags=0x" + Long.toHexString(this.flags) + " (" + MiscTools.getFlagFieldsString(ParamInfo.class, this.flags, "FLAG_.*") + ")" + ", maxMsgLen=" + this.maxMsgLen + ", maxSenderWarning=" + this.maxSenderWarning + ", maxReceiverWarning=" + this.maxReceiverWarning + ", minMsgInterval=" + this.minMsgInterval;
    }
}

