/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import java.io.File;
import java.io.FileFilter;
import java.util.regex.Pattern;

public class RegexFileFilter
implements FileFilter {
    private boolean matchSubstring;
    private boolean matchAbsolutePaths;
    private Pattern pattern;

    public RegexFileFilter(String regex, boolean matchSubstring, boolean matchAbsolutePaths) {
        this.setPattern(regex);
        this.matchSubstring = matchSubstring;
        this.matchAbsolutePaths = matchAbsolutePaths;
    }

    public RegexFileFilter(String regex) {
        this(regex, false, false);
    }

    public boolean isMatchSubstring() {
        return this.matchSubstring;
    }

    public void setMatchSubstring(boolean matchSubstring) {
        this.matchSubstring = matchSubstring;
    }

    public boolean isMatchAbsolutePaths() {
        return this.matchAbsolutePaths;
    }

    public void setMatchAbsolutePaths(boolean matchAbsolutePaths) {
        this.matchAbsolutePaths = matchAbsolutePaths;
    }

    public String getPattern() {
        return this.pattern.pattern();
    }

    public void setPattern(String regex) {
        this.pattern = Pattern.compile(regex);
    }

    public boolean accept(File pathname) {
        String name = this.matchAbsolutePaths ? pathname.getAbsolutePath() : pathname.getName();
        return this.matchSubstring ? this.pattern.matcher(name).find() : this.pattern.matcher(name).matches();
    }
}

