/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.replicatedmap;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapEntrySetCodec;
import com.hazelcast.client.impl.protocol.task.AbstractCallableMessageTask;
import com.hazelcast.instance.Node;
import com.hazelcast.nio.Connection;
import com.hazelcast.replicatedmap.impl.ReplicatedMapService;
import com.hazelcast.replicatedmap.impl.record.ReplicatedRecordStore;
import com.hazelcast.security.permission.ReplicatedMapPermission;
import java.security.Permission;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ReplicatedMapEntrySetMessageTask
extends AbstractCallableMessageTask<ReplicatedMapEntrySetCodec.RequestParameters> {
    public ReplicatedMapEntrySetMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Object call() throws Exception {
        ReplicatedMapService replicatedMapService = (ReplicatedMapService)this.getService(this.getServiceName());
        ReplicatedRecordStore recordStore = replicatedMapService.getReplicatedRecordStore(((ReplicatedMapEntrySetCodec.RequestParameters)this.parameters).name, true);
        Set entrySet = recordStore.entrySet();
        HashMap dataMap = new HashMap();
        for (Map.Entry entry : entrySet) {
            dataMap.put(this.serializationService.toData(entry.getKey()), this.serializationService.toData(entry.getValue()));
        }
        return dataMap;
    }

    @Override
    protected ReplicatedMapEntrySetCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return ReplicatedMapEntrySetCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return ReplicatedMapEntrySetCodec.encodeResponse((Map)response);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:replicatedMapService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new ReplicatedMapPermission(((ReplicatedMapEntrySetCodec.RequestParameters)this.parameters).name, "read");
    }

    @Override
    public String getDistributedObjectName() {
        return ((ReplicatedMapEntrySetCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return "entrySet";
    }

    @Override
    public Object[] getParameters() {
        return null;
    }
}

