/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.metricsets;

import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.util.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public final class GarbageCollectionMetricSet {
    private static final Set<String> YOUNG_GC = new HashSet<String>(3);
    private static final Set<String> OLD_GC = new HashSet<String>(3);
    private static final int PUBLISH_FREQUENCY_SECONDS = 1;

    private GarbageCollectionMetricSet() {
    }

    public static void register(MetricsRegistry metricsRegistry) {
        Preconditions.checkNotNull(metricsRegistry, "metricsRegistry");
        GcStats stats = new GcStats();
        metricsRegistry.scheduleAtFixedRate(stats, 1L, TimeUnit.SECONDS);
        metricsRegistry.scanAndRegister(stats, "gc");
    }

    static {
        YOUNG_GC.add("PS Scavenge");
        YOUNG_GC.add("ParNew");
        YOUNG_GC.add("G1 Young Generation");
        OLD_GC.add("PS MarkSweep");
        OLD_GC.add("ConcurrentMarkSweep");
        OLD_GC.add("G1 Old Generation");
    }

    @SuppressWarnings(value={"URF_UNREAD_FIELD"})
    static class GcStats
    implements Runnable {
        @Probe
        volatile long minorCount;
        @Probe
        volatile long minorTime;
        @Probe
        volatile long majorCount;
        @Probe
        volatile long majorTime;
        @Probe
        volatile long unknownCount;
        @Probe
        volatile long unknownTime;

        GcStats() {
        }

        @Override
        public void run() {
            long minorCount = 0L;
            long minorTime = 0L;
            long majorCount = 0L;
            long majorTime = 0L;
            long unknownCount = 0L;
            long unknownTime = 0L;
            for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
                long count = gc.getCollectionCount();
                if (count == -1L) continue;
                if (YOUNG_GC.contains(gc.getName())) {
                    minorCount += count;
                    minorTime += gc.getCollectionTime();
                    continue;
                }
                if (OLD_GC.contains(gc.getName())) {
                    majorCount += count;
                    majorTime += gc.getCollectionTime();
                    continue;
                }
                unknownCount += count;
                unknownTime += gc.getCollectionTime();
            }
            this.minorCount = minorCount;
            this.minorTime = minorTime;
            this.majorCount = majorCount;
            this.majorTime = majorTime;
            this.unknownCount = unknownCount;
            this.unknownTime = unknownTime;
        }
    }
}

