/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Logger;
import net.kano.joustsim.JavaTools;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.oscar.OscarConnListener;
import net.kano.joustsim.oscar.oscar.OscarConnStateEvent;
import net.kano.joustsim.oscar.oscar.OscarConnection;
import net.kano.joustsim.oscar.oscar.service.Service;
import net.kano.joustsim.oscar.oscar.service.ServiceArbiter;
import net.kano.joustsim.oscar.oscar.service.ServiceArbiterRequest;
import net.kano.joustsim.oscar.oscar.service.ServiceArbitrationManager;
import net.kano.joustsim.oscar.oscar.service.ServiceListener;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServiceArbiter<S extends Service>
implements ServiceArbiter<S> {
    private static final Logger LOGGER = Logger.getLogger(AbstractServiceArbiter.class.getName());
    protected final ServiceArbitrationManager manager;
    protected Set<ServiceArbiterRequest> requests = new LinkedHashSet<ServiceArbiterRequest>();
    protected S currentService = null;

    public AbstractServiceArbiter(ServiceArbitrationManager manager) {
        this.manager = manager;
    }

    @Override
    public abstract int getSnacFamily();

    @Override
    public synchronized boolean shouldKeepAlive() {
        return !this.requests.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dequeueRequests(S service) {
        ArrayList<ServiceArbiterRequest> requests;
        AbstractServiceArbiter abstractServiceArbiter = this;
        synchronized (abstractServiceArbiter) {
            requests = new ArrayList<ServiceArbiterRequest>(this.requests);
        }
        for (ServiceArbiterRequest request : requests) {
            this.processRequest(service, request);
        }
        this.handleRequestsDequeuedEvent(service);
    }

    protected abstract void handleRequestsDequeuedEvent(S var1);

    protected abstract void processRequest(S var1, ServiceArbiterRequest var2);

    @Override
    public final S createService(AimConnection aimConnection, OscarConnection conn) {
        S service = this.createServiceInstance(aimConnection, conn);
        conn.addOscarListener(new OscarConnListener((Service)service){
            final /* synthetic */ Service val$service;
            {
                this.val$service = service;
            }

            public void registeredSnacFamilies(OscarConnection conn) {
            }

            public void connStateChanged(OscarConnection conn, OscarConnStateEvent event) {
                LOGGER.info("Conn state changed for " + AbstractServiceArbiter.this + ": " + event.getClientConnEvent().getNewState());
            }

            public void allFamiliesReady(OscarConnection conn) {
                LOGGER.fine("Dequeueing requests upon connecting to " + this.val$service);
                AbstractServiceArbiter.this.dequeueRequests(this.val$service);
            }
        });
        ((Service)service).addServiceListener(new ServiceListener((Service)service){
            final /* synthetic */ Service val$service;
            {
                this.val$service = service;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleServiceReady(Service s) {
                AbstractServiceArbiter abstractServiceArbiter = AbstractServiceArbiter.this;
                synchronized (abstractServiceArbiter) {
                    AbstractServiceArbiter.this.currentService = this.val$service;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleServiceFinished(Service s) {
                AbstractServiceArbiter abstractServiceArbiter = AbstractServiceArbiter.this;
                synchronized (abstractServiceArbiter) {
                    if (AbstractServiceArbiter.this.currentService == this.val$service) {
                        AbstractServiceArbiter.this.currentService = null;
                    }
                }
            }
        });
        return service;
    }

    protected abstract S createServiceInstance(AimConnection var1, OscarConnection var2);

    protected final void addRequest(ServiceArbiterRequest req) {
        this.addRequestImpl(req, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R extends ServiceArbiterRequest> void addRequestImpl(R req, @Nullable Class<R> unique) {
        S service;
        AbstractServiceArbiter abstractServiceArbiter = this;
        synchronized (abstractServiceArbiter) {
            if (unique != null) {
                Iterator<ServiceArbiterRequest> it = this.requests.iterator();
                while (it.hasNext()) {
                    if (!unique.isInstance(it.next())) continue;
                    it.remove();
                }
            }
            this.requests.add(req);
            service = this.currentService;
        }
        if (service == null) {
            this.manager.openService(this);
        } else {
            this.processRequest(service, req);
        }
    }

    protected <R extends ServiceArbiterRequest> void addUniqueRequest(R req, Class<R> unique) {
        if (unique == null) {
            throw new IllegalArgumentException("class cannot be null");
        }
        this.addRequestImpl(req, unique);
    }

    @Nullable
    protected synchronized <E> E getRequest(Class<E> cls) {
        E found = null;
        for (ServiceArbiterRequest request : this.requests) {
            if (!cls.isInstance(request)) continue;
            if (found == null) {
                found = JavaTools.cast(cls, request);
                continue;
            }
            throw new IllegalArgumentException("Multiple instances of " + cls + " in requests: " + this.requests);
        }
        return found;
    }

    protected synchronized void removeRequest(ServiceArbiterRequest req) {
        while (this.requests.remove(req)) {
        }
    }

    protected synchronized void removeRequests(RequestProcessor processor) {
        Iterator<ServiceArbiterRequest> it = this.requests.iterator();
        while (it.hasNext()) {
            ServiceArbiterRequest request = it.next();
            if (!processor.shouldRemove(request)) continue;
            it.remove();
        }
    }

    protected static interface RequestProcessor {
        public boolean shouldRemove(ServiceArbiterRequest var1);
    }
}

