/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.chatrooms;

import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.snaccmd.FullRoomInfo;
import net.kano.joscar.snaccmd.MiniRoomInfo;
import net.kano.joustsim.JavaTools;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.oscar.BasicConnection;
import net.kano.joustsim.oscar.oscar.OscarConnection;
import net.kano.joustsim.oscar.oscar.service.AbstractServiceArbiter;
import net.kano.joustsim.oscar.oscar.service.ServiceArbiterRequest;
import net.kano.joustsim.oscar.oscar.service.ServiceArbitrationManager;
import net.kano.joustsim.oscar.oscar.service.chatrooms.RoomFinderService;
import net.kano.joustsim.oscar.oscar.service.chatrooms.RoomFinderServiceListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoomFinderServiceArbiter
extends AbstractServiceArbiter<RoomFinderService> {
    private CopyOnWriteArrayList<RoomFinderServiceListener> listeners = new CopyOnWriteArrayList();
    private RoomFinderServiceListener delegatingListener = JavaTools.getDelegatingProxy(this.listeners, RoomFinderServiceListener.class);

    public RoomFinderServiceArbiter(ServiceArbitrationManager manager) {
        super(manager);
        this.listeners.add((Object)new RoomFinderServiceListener(){

            public void handleNewChatRoom(RoomFinderService service, FullRoomInfo roomInfo, BasicConnection connection) {
                RoomFinderServiceArbiter.this.removeRequest(new JoinRoomRequest(roomInfo.getExchange(), roomInfo.getName()));
            }

            public void handleRoomInfo(RoomFinderService service, MiniRoomInfo mini, FullRoomInfo info) {
                RoomFinderServiceArbiter.this.removeRequest(new GetInfoRequest(mini));
            }
        });
    }

    @Override
    public int getSnacFamily() {
        return 13;
    }

    @Override
    protected void handleRequestsDequeuedEvent(RoomFinderService service) {
    }

    @Override
    protected void processRequest(RoomFinderService service, ServiceArbiterRequest request) {
        if (request instanceof JoinRoomRequest) {
            JoinRoomRequest req = (JoinRoomRequest)request;
            service.joinChatRoom(req.getExchange(), req.getRoomName());
        } else if (request instanceof AcceptInvitationRequest) {
            AcceptInvitationRequest invitationRequest = (AcceptInvitationRequest)request;
            service.joinChatRoom(invitationRequest.roomInfo);
        } else if (request instanceof GetInfoRequest) {
            GetInfoRequest infoRequest = (GetInfoRequest)request;
            service.requestRoomInfo(infoRequest.roomInfo);
        }
    }

    @Override
    protected RoomFinderService createServiceInstance(AimConnection aimConnection, OscarConnection conn) {
        RoomFinderService service = new RoomFinderService(aimConnection, conn);
        service.addRoomManagerServiceListener(this.delegatingListener);
        return service;
    }

    public void joinChatRoom(int exchange, String name) {
        this.addRequest(new JoinRoomRequest(exchange, name));
    }

    public void joinChatRoom(FullRoomInfo roomInfo) {
        this.addRequest(new AcceptInvitationRequest(roomInfo));
    }

    public void addRoomManagerServiceListener(RoomFinderServiceListener l) {
        this.listeners.addIfAbsent((Object)l);
    }

    public void removeRoomManagerServiceListener(RoomFinderServiceListener l) {
        this.listeners.remove((Object)l);
    }

    public void getRoomInfo(MiniRoomInfo roomInfo) {
        this.addRequest(new GetInfoRequest(roomInfo));
    }

    private static class GetInfoRequest
    implements ServiceArbiterRequest {
        public final MiniRoomInfo roomInfo;

        public GetInfoRequest(MiniRoomInfo roomInfo) {
            this.roomInfo = roomInfo;
        }
    }

    private static class AcceptInvitationRequest
    implements ServiceArbiterRequest {
        public final FullRoomInfo roomInfo;

        public AcceptInvitationRequest(FullRoomInfo roomInfo) {
            this.roomInfo = roomInfo;
        }
    }

    private static class JoinRoomRequest
    implements ServiceArbiterRequest {
        private final int exchange;
        private final String roomName;

        public JoinRoomRequest(int exchange, String name) {
            this.exchange = exchange;
            this.roomName = name;
        }

        public int getExchange() {
            return this.exchange;
        }

        public String getRoomName() {
            return this.roomName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JoinRoomRequest that = (JoinRoomRequest)o;
            if (this.exchange != that.exchange) {
                return false;
            }
            return this.roomName.equals(that.roomName);
        }

        public int hashCode() {
            int result = this.exchange;
            result = 29 * result + this.roomName.hashCode();
            return result;
        }
    }
}

