/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icon;

import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.Writable;
import net.kano.joscar.snaccmd.ExtraInfoData;
import net.kano.joustsim.JavaTools;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.oscar.OscarConnection;
import net.kano.joustsim.oscar.oscar.service.AbstractServiceArbiter;
import net.kano.joustsim.oscar.oscar.service.ServiceArbiterRequest;
import net.kano.joustsim.oscar.oscar.service.ServiceArbitrationManager;
import net.kano.joustsim.oscar.oscar.service.icon.IconRequestHandler;
import net.kano.joustsim.oscar.oscar.service.icon.IconRequestListener;
import net.kano.joustsim.oscar.oscar.service.icon.IconService;
import net.kano.joustsim.oscar.oscar.service.icon.IconSetListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IconServiceArbiter
extends AbstractServiceArbiter<IconService>
implements IconRequestHandler {
    private CopyOnWriteArrayList<IconRequestListener> listeners = new CopyOnWriteArrayList();
    private IconRequestListener delegatingListener = JavaTools.getDelegatingProxy(this.listeners, IconRequestListener.class);

    public IconServiceArbiter(ServiceArbitrationManager manager) {
        super(manager);
    }

    @Override
    public int getSnacFamily() {
        return 16;
    }

    protected boolean shouldKeepAliveSub() {
        return false;
    }

    @Override
    public void addIconRequestListener(IconRequestListener listener) {
        this.listeners.addIfAbsent((Object)listener);
    }

    @Override
    public void removeIconRequestListener(IconRequestListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public void requestIcon(Screenname sn, ExtraInfoData hashBlock) {
        this.addRequest(new RequestedIconInfo(sn, hashBlock));
    }

    @Override
    public void uploadIcon(Writable data) {
        this.addUniqueRequest(new UploadIconRequest(data), UploadIconRequest.class);
    }

    @Override
    protected void handleRequestsDequeuedEvent(IconService service) {
    }

    @Override
    protected void processRequest(IconService service, ServiceArbiterRequest request) {
        if (request instanceof RequestedIconInfo) {
            RequestedIconInfo iconInfo = (RequestedIconInfo)request;
            service.requestIcon(iconInfo.screenname, iconInfo.iconHash);
        } else if (request instanceof UploadIconRequest) {
            UploadIconRequest uploadReq = (UploadIconRequest)request;
            service.uploadIcon(uploadReq.data, new IconSetListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handleIconSet(IconService service, Writable data, boolean succeeded) {
                    1 var4_4 = this;
                    synchronized (var4_4) {
                        UploadIconRequest req = (UploadIconRequest)IconServiceArbiter.this.getRequest(UploadIconRequest.class);
                        if (req != null && req.data == data) {
                            IconServiceArbiter.this.removeRequest(req);
                        }
                    }
                }
            });
        }
    }

    @Override
    protected IconService createServiceInstance(AimConnection aimConnection, OscarConnection conn) {
        IconService service = new IconService(aimConnection, conn);
        service.addIconRequestListener(this.delegatingListener);
        return service;
    }

    private static class UploadIconRequest
    implements ServiceArbiterRequest {
        public final Writable data;

        public UploadIconRequest(Writable data) {
            this.data = data;
        }
    }

    private static class RequestedIconInfo
    implements ServiceArbiterRequest {
        public final Screenname screenname;
        public final ExtraInfoData iconHash;

        public RequestedIconInfo(Screenname screenname, ExtraInfoData iconHash) {
            this.iconHash = iconHash;
            this.screenname = screenname;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RequestedIconInfo that = (RequestedIconInfo)o;
            if (!this.iconHash.equals((Object)that.iconHash)) {
                return false;
            }
            return this.screenname.equals(that.screenname);
        }

        public int hashCode() {
            int result = this.screenname.hashCode();
            result = 29 * result + this.iconHash.hashCode();
            return result;
        }
    }
}

