/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.message.p2p;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.sf.jml.MsnFileTransferState;
import net.sf.jml.MsnSwitchboard;
import net.sf.jml.impl.AbstractMessenger;
import net.sf.jml.impl.MsnFileTransferImpl;
import net.sf.jml.message.p2p.MsnFileByeMessage;
import net.sf.jml.message.p2p.MsnP2PAckMessage;
import net.sf.jml.message.p2p.MsnP2PBaseIdGenerator;
import net.sf.jml.message.p2p.MsnP2PDataMessage;
import net.sf.jml.message.p2p.MsnP2PMessage;
import net.sf.jml.message.p2p.MsnP2PSlpMessage;
import net.sf.jml.protocol.MsnIncomingMessage;
import net.sf.jml.protocol.MsnSession;
import net.sf.jml.protocol.msnslp.MsnslpMessage;
import net.sf.jml.protocol.msnslp.MsnslpRequest;
import net.sf.jml.protocol.msnslp.MsnslpResponse;
import net.sf.jml.protocol.outgoing.OutgoingMSG;
import net.sf.jml.util.Charset;
import net.sf.jml.util.NumberUtils;
import net.sf.jml.util.StringHolder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileTransferWorker {
    private static final Log logger = LogFactory.getLog(FileTransferWorker.class);
    private MsnFileTransferImpl fileTransfer;
    private int baseId = NumberUtils.getIntRandom();
    private int baseP2PId;
    private MsnSwitchboard switchboard = null;
    private FileInputStream fileInput = null;
    private long fileOffset = 0L;

    public FileTransferWorker(MsnFileTransferImpl msnFileTransferImpl) {
        this.fileTransfer = msnFileTransferImpl;
    }

    public MsnFileTransferImpl getFileTransfer() {
        return this.fileTransfer;
    }

    private int getNextIdentifier() {
        return ++this.baseId;
    }

    private int getLastIdentifier() {
        return this.baseId;
    }

    private int nextP2PBaseId() {
        this.baseP2PId = MsnP2PBaseIdGenerator.getInstance().getNextId();
        return this.baseP2PId;
    }

    public void startFileTransfer() {
        if (this.fileTransfer.isReceiver()) {
            OutgoingMSG[] outgoingMSGArray;
            MsnslpMessage msnslpMessage = this.fileTransfer.getReqMessage().getSlpMessage();
            MsnslpResponse msnslpResponse = new MsnslpResponse();
            msnslpResponse.setTo(msnslpMessage.getFrom());
            msnslpResponse.setFrom(msnslpMessage.getTo());
            msnslpResponse.setVia(msnslpMessage.getVia());
            msnslpResponse.setCSeq(msnslpMessage.getCSeq() + 1);
            msnslpResponse.setCallId(msnslpMessage.getCallId());
            msnslpResponse.setMaxForwards(msnslpMessage.getMaxForwards());
            msnslpResponse.setContentType(msnslpMessage.getContentType());
            StringHolder stringHolder = new StringHolder();
            stringHolder.setProperty("SessionID", this.fileTransfer.getID());
            msnslpResponse.setBody(stringHolder.toString() + "\r\n" + "\u0000");
            int n = Charset.encodeAsByteArray(msnslpResponse.toString()).length;
            MsnP2PSlpMessage msnP2PSlpMessage = new MsnP2PSlpMessage();
            msnP2PSlpMessage.setSlpMessage(msnslpResponse);
            msnP2PSlpMessage.setIdentifier(this.getNextIdentifier());
            msnP2PSlpMessage.setTotalLength(n);
            msnP2PSlpMessage.setCurrentLength(n);
            msnP2PSlpMessage.setField7(NumberUtils.getIntRandom());
            msnP2PSlpMessage.setFlag(0x1000000);
            msnP2PSlpMessage.setP2PDest(this.fileTransfer.getEmail().getEmailAddress());
            for (OutgoingMSG outgoingMSG : outgoingMSGArray = msnP2PSlpMessage.toOutgoingMsg(this.fileTransfer.getSession().getMessenger().getActualMsnProtocol())) {
                this.fileTransfer.getSession().sendSynchronousMessage(outgoingMSG);
            }
        } else {
            try {
                OutgoingMSG[] outgoingMSGArray;
                int n;
                if (this.fileInput == null) {
                    this.fileInput = new FileInputStream(this.fileTransfer.getFile());
                    this.getNextIdentifier();
                }
                int n2 = (n = (int)(this.fileTransfer.getFile().length() - this.fileOffset)) > 1202 ? 1202 : n;
                byte[] byArray = new byte[n2];
                this.fileInput.read(byArray);
                MsnP2PDataMessage msnP2PDataMessage = new MsnP2PDataMessage(Integer.parseInt(this.fileTransfer.getID()), this.getLastIdentifier(), (int)this.fileOffset, (int)this.fileTransfer.getFileTotalSize(), byArray, this.fileTransfer.getEmail().getEmailAddress()){

                    protected void receivedResponse(MsnSession msnSession, MsnIncomingMessage msnIncomingMessage) {
                        try {
                            OutgoingMSG[] outgoingMSGArray;
                            int n = (int)(FileTransferWorker.this.fileTransfer.getFile().length() - FileTransferWorker.this.fileOffset);
                            if (n == 0) {
                                FileTransferWorker.this.fileTransfer.setState(MsnFileTransferState.COMPLETED);
                                ((AbstractMessenger)FileTransferWorker.this.fileTransfer.getSession().getMessenger()).fireFileTransferFinished(FileTransferWorker.this.fileTransfer);
                                return;
                            }
                            if (FileTransferWorker.this.fileTransfer.getState() == MsnFileTransferState.CANCELED) {
                                return;
                            }
                            this.binaryHeader.rewind();
                            int n2 = n > 1202 ? 1202 : n;
                            byte[] byArray = new byte[n2];
                            FileTransferWorker.this.fileInput.read(byArray);
                            this.setCurrentLength(byArray.length);
                            this.parseP2PBody(ByteBuffer.wrap(byArray));
                            this.setOffset(FileTransferWorker.this.fileOffset);
                            FileTransferWorker.this.fileOffset += byArray.length;
                            FileTransferWorker.this.fileTransfer.setTransferredSize(this.getOffset());
                            ((AbstractMessenger)FileTransferWorker.this.fileTransfer.getSession().getMessenger()).fireFileTransferProcess(FileTransferWorker.this.fileTransfer);
                            for (OutgoingMSG outgoingMSG : outgoingMSGArray = this.toOutgoingMsg(msnSession.getMessenger().getActualMsnProtocol())) {
                                FileTransferWorker.this.switchboard.send(outgoingMSG);
                            }
                        }
                        catch (IOException iOException) {
                            logger.info((Object)"Cannot send file", (Throwable)iOException);
                        }
                    }
                };
                msnP2PDataMessage.setFlag(0x1000030);
                this.fileOffset += (long)byArray.length;
                this.fileTransfer.setTransferredSize(this.fileOffset);
                ((AbstractMessenger)this.fileTransfer.getSession().getMessenger()).fireFileTransferProcess(this.fileTransfer);
                for (OutgoingMSG outgoingMSG : outgoingMSGArray = msnP2PDataMessage.toOutgoingMsg(this.fileTransfer.getSession().getMessenger().getActualMsnProtocol())) {
                    this.switchboard.send(outgoingMSG);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.error((Object)"Cannot open file", (Throwable)fileNotFoundException);
            }
            catch (IOException iOException) {
                logger.error((Object)"Cannot read from file", (Throwable)iOException);
            }
        }
    }

    private void sendBye() {
        OutgoingMSG[] outgoingMSGArray;
        MsnslpRequest msnslpRequest = new MsnslpRequest();
        MsnFileByeMessage msnFileByeMessage = new MsnFileByeMessage();
        msnFileByeMessage.setSlpMessage(msnslpRequest);
        int n = NumberUtils.getIntRandom();
        msnFileByeMessage.setP2PDest(this.fileTransfer.getEmail().getEmailAddress());
        msnFileByeMessage.setSessionId(Integer.parseInt(this.fileTransfer.getID()));
        msnFileByeMessage.setIdentifier(this.getNextIdentifier());
        msnFileByeMessage.setFlag(0x1000000);
        msnFileByeMessage.setField7(n);
        msnFileByeMessage.setField8(0);
        msnFileByeMessage.setField9(0L);
        msnslpRequest.setRequestMethod("BYE");
        msnslpRequest.setRequestURI("MSNMSGR:" + this.fileTransfer.getSession().getMessenger().getOwner().getEmail().getEmailAddress());
        msnslpRequest.setTo("<msnmsgr:" + this.fileTransfer.getEmail().getEmailAddress() + ">");
        msnslpRequest.setFrom("<msnmsgr:" + this.fileTransfer.getSession().getMessenger().getOwner().getEmail().getEmailAddress() + ">");
        msnslpRequest.setVia("MSNSLP/1.0/TLP ;branch={A0D624A6-6C0C-4283-A9E0-BC97B4B46D32}");
        msnslpRequest.setCSeq(0);
        msnslpRequest.setCallId(this.fileTransfer.getReqMessage().getSlpMessage().getCallId());
        msnslpRequest.setMaxForwards(0);
        msnslpRequest.setContentType("application/x-msnmsgr-sessionclosebody");
        msnslpRequest.setBody("\r\n\u0000");
        int n2 = Charset.encodeAsByteArray(msnslpRequest.toString()).length;
        msnFileByeMessage.setTotalLength(n2);
        msnFileByeMessage.setCurrentLength(n2);
        for (OutgoingMSG outgoingMSG : outgoingMSGArray = msnFileByeMessage.toOutgoingMsg(this.fileTransfer.getSession().getMessenger().getActualMsnProtocol())) {
            if (this.switchboard != null) {
                this.switchboard.send(outgoingMSG);
                continue;
            }
            this.fileTransfer.getSession().sendAsynchronousMessage(outgoingMSG);
        }
    }

    private void sendDecline() {
        OutgoingMSG[] outgoingMSGArray;
        MsnslpMessage msnslpMessage = this.fileTransfer.getReqMessage().getSlpMessage();
        MsnslpResponse msnslpResponse = new MsnslpResponse();
        msnslpResponse.setStatusCode(603);
        msnslpResponse.setReasonPhrase("Decline");
        msnslpResponse.setTo(msnslpMessage.getFrom());
        msnslpResponse.setFrom(msnslpMessage.getTo());
        msnslpResponse.setVia(msnslpMessage.getVia());
        msnslpResponse.setCSeq(msnslpMessage.getCSeq() + 1);
        msnslpResponse.setCallId(msnslpMessage.getCallId());
        msnslpResponse.setMaxForwards(msnslpMessage.getMaxForwards());
        msnslpResponse.setContentType(msnslpMessage.getContentType());
        StringHolder stringHolder = new StringHolder();
        stringHolder.setProperty("SessionID", this.fileTransfer.getID());
        msnslpResponse.setBody(stringHolder.toString() + "\r\n" + "\u0000");
        int n = Charset.encodeAsByteArray(msnslpResponse.toString()).length;
        MsnP2PSlpMessage msnP2PSlpMessage = new MsnP2PSlpMessage();
        msnP2PSlpMessage.setSlpMessage(msnslpResponse);
        msnP2PSlpMessage.setIdentifier(this.getNextIdentifier());
        msnP2PSlpMessage.setTotalLength(n);
        msnP2PSlpMessage.setCurrentLength(n);
        msnP2PSlpMessage.setFlag(0x1000000);
        msnP2PSlpMessage.setField7(NumberUtils.getIntRandom());
        msnP2PSlpMessage.setP2PDest(this.fileTransfer.getEmail().getEmailAddress());
        for (OutgoingMSG outgoingMSG : outgoingMSGArray = msnP2PSlpMessage.toOutgoingMsg(this.fileTransfer.getSession().getMessenger().getActualMsnProtocol())) {
            this.fileTransfer.getSession().sendSynchronousMessage(outgoingMSG);
        }
    }

    public void cancelFileTransfer() {
        if (this.fileTransfer.isSender()) {
            this.sendBye();
        } else if (!this.fileTransfer.isSender() && !this.fileTransfer.isStarted()) {
            this.sendDecline();
        } else {
            this.sendBye();
        }
    }

    public void sendP2PAck(MsnP2PMessage msnP2PMessage, boolean bl) {
        OutgoingMSG[] outgoingMSGArray;
        MsnP2PAckMessage msnP2PAckMessage = new MsnP2PAckMessage(this.getNextIdentifier(), this.fileTransfer.getEmail().getEmailAddress(), msnP2PMessage);
        if (bl) {
            msnP2PAckMessage.setSessionId(Integer.valueOf(this.fileTransfer.getID()));
        }
        for (OutgoingMSG outgoingMSG : outgoingMSGArray = msnP2PAckMessage.toOutgoingMsg(this.fileTransfer.getSession().getMessenger().getActualMsnProtocol())) {
            this.fileTransfer.getSession().sendSynchronousMessage(outgoingMSG);
        }
    }

    public void sendDeny(MsnP2PSlpMessage msnP2PSlpMessage) {
        OutgoingMSG[] outgoingMSGArray;
        MsnslpRequest msnslpRequest = (MsnslpRequest)msnP2PSlpMessage.getSlpMessage();
        MsnslpResponse msnslpResponse = new MsnslpResponse();
        msnslpResponse.setStatusCode(405);
        msnslpResponse.setReasonPhrase("Not supported");
        msnslpResponse.setTo(msnslpRequest.getFrom());
        msnslpResponse.setFrom(msnslpRequest.getTo());
        msnslpResponse.setVia(msnslpRequest.getVia());
        msnslpResponse.setCSeq(msnslpRequest.getCSeq() + 1);
        msnslpResponse.setCallId(msnslpRequest.getCallId());
        msnslpResponse.setMaxForwards(msnslpRequest.getMaxForwards());
        msnslpResponse.setContentType(msnslpRequest.getContentType());
        StringHolder stringHolder = new StringHolder();
        stringHolder.setProperty("SessionID", this.fileTransfer.getID());
        msnslpResponse.setBody(stringHolder.toString() + "\r\n" + "\u0000");
        int n = Charset.encodeAsByteArray(msnslpResponse.toString()).length;
        MsnP2PSlpMessage msnP2PSlpMessage2 = new MsnP2PSlpMessage();
        msnP2PSlpMessage2.setSlpMessage(msnslpResponse);
        msnP2PSlpMessage2.setIdentifier(this.getNextIdentifier());
        msnP2PSlpMessage2.setTotalLength(n);
        msnP2PSlpMessage2.setCurrentLength(n);
        msnP2PSlpMessage2.setField7(NumberUtils.getIntRandom());
        msnP2PSlpMessage2.setP2PDest(this.fileTransfer.getEmail().getEmailAddress());
        for (OutgoingMSG outgoingMSG : outgoingMSGArray = msnP2PSlpMessage2.toOutgoingMsg(this.fileTransfer.getSession().getMessenger().getActualMsnProtocol())) {
            this.fileTransfer.getSession().sendSynchronousMessage(outgoingMSG);
        }
    }

    public MsnSwitchboard getSwitchboard() {
        return this.switchboard;
    }

    public void setSwitchboard(MsnSwitchboard msnSwitchboard) {
        this.switchboard = msnSwitchboard;
    }
}

