/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.message.p2p;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import net.sf.jml.DisplayPictureListener;
import net.sf.jml.Email;
import net.sf.jml.MsnContact;
import net.sf.jml.MsnMessenger;
import net.sf.jml.MsnObject;
import net.sf.jml.MsnSwitchboard;
import net.sf.jml.event.MsnAdapter;
import net.sf.jml.message.MsnControlMessage;
import net.sf.jml.message.MsnDatacastMessage;
import net.sf.jml.message.MsnInstantMessage;
import net.sf.jml.message.MsnSystemMessage;
import net.sf.jml.message.MsnUnknownMessage;
import net.sf.jml.message.p2p.MsnP2PAckMessage;
import net.sf.jml.message.p2p.MsnP2PByeMessage;
import net.sf.jml.message.p2p.MsnP2PDataMessage;
import net.sf.jml.message.p2p.MsnP2PInvitationMessage;
import net.sf.jml.message.p2p.MsnP2PMessage;
import net.sf.jml.message.p2p.MsnP2PPreperationMessage;
import net.sf.jml.message.p2p.MsnP2PSlpMessage;
import net.sf.jml.protocol.msnslp.MsnslpMessage;
import net.sf.jml.protocol.msnslp.MsnslpRequest;
import net.sf.jml.protocol.msnslp.MsnslpResponse;
import net.sf.jml.util.Charset;
import net.sf.jml.util.NumberUtils;
import net.sf.jml.util.StringHolder;
import net.sf.jml.util.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DisplayPictureRetrieveWorker
extends MsnAdapter {
    private static final Log log = LogFactory.getLog(DisplayPictureRetrieveWorker.class);
    private MsnMessenger messenger = null;
    private MsnObject msnObject = null;
    private DisplayPictureListener listener = null;
    private Email creator = null;
    private MsnSwitchboard switchboard = null;
    private boolean active = true;
    private boolean notified = false;
    private int baseId = NumberUtils.getIntRandom();
    private int transferSessionId = -1;
    private String callId;
    private int lastRandomIdentifier = 0;
    private ByteArrayOutputStream buffer = null;
    private TransferState state = TransferState.WAITING_INVITE_ACK;
    private int receivedData = 0;

    public DisplayPictureRetrieveWorker(MsnMessenger msnMessenger, MsnObject msnObject, DisplayPictureListener displayPictureListener) {
        this.messenger = msnMessenger;
        this.msnObject = msnObject;
        this.listener = displayPictureListener;
        msnMessenger.addMessageListener(this);
    }

    public void start() {
        if (!this.active) {
            return;
        }
        this.creator = Email.parseStr(this.msnObject.getCreator());
        this.messenger.addSwitchboardListener(this);
        this.messenger.newSwitchboard(this);
    }

    private synchronized void finishProcess() {
        if (!this.active) {
            return;
        }
        this.active = false;
        this.messenger.removeSwitchboardListener(this);
        this.messenger.removeMessageListener(this);
        this.switchboard.close();
    }

    private synchronized void notifyFinalization(DisplayPictureListener.ResultStatus resultStatus, Object object, boolean bl) {
        if (bl) {
            this.finishProcess();
        }
        if (this.notified) {
            return;
        }
        this.notified = true;
        if (this.buffer != null && resultStatus != DisplayPictureListener.ResultStatus.GOOD) {
            this.buffer = new ByteArrayOutputStream();
        }
        byte[] byArray = this.buffer == null ? new byte[]{} : this.buffer.toByteArray();
        this.listener.notifyMsnObjectRetrieval(this.messenger, this, this.msnObject, resultStatus, byArray, object);
    }

    private int getNextIdentifier() {
        return ++this.baseId;
    }

    private int getLastIdentifier() {
        return this.baseId;
    }

    private String generateNewCallId() {
        int n = NumberUtils.getIntRandom();
        String string = NumberUtils.toHexValue(n);
        return "{2B073406-65D8-A7B2-5B13-B287" + string + "}";
    }

    private void sendP2PInviteRequest() {
        this.transferSessionId = NumberUtils.getIntRandom();
        this.lastRandomIdentifier = NumberUtils.getIntRandom();
        this.callId = this.generateNewCallId();
        MsnslpRequest msnslpRequest = new MsnslpRequest();
        MsnP2PInvitationMessage msnP2PInvitationMessage = new MsnP2PInvitationMessage();
        msnP2PInvitationMessage.setSlpMessage(msnslpRequest);
        msnP2PInvitationMessage.setP2PDest(this.creator.getEmailAddress());
        msnP2PInvitationMessage.setSessionId(0);
        msnP2PInvitationMessage.setIdentifier(this.getNextIdentifier());
        msnP2PInvitationMessage.setFlag(0);
        msnP2PInvitationMessage.setField7(this.lastRandomIdentifier);
        msnP2PInvitationMessage.setField8(0);
        msnP2PInvitationMessage.setField9(0L);
        msnslpRequest.setRequestMethod("INVITE");
        msnslpRequest.setRequestURI("MSNMSGR:" + this.creator.getEmailAddress());
        msnslpRequest.setTo("<msnmsgr:" + this.creator.getEmailAddress() + ">");
        msnslpRequest.setFrom("<msnmsgr:" + this.messenger.getOwner().getEmail().getEmailAddress() + ">");
        msnslpRequest.setVia("MSNSLP/1.0/TLP ;branch=" + this.callId);
        msnslpRequest.setCSeq(0);
        msnslpRequest.setCallId(this.callId);
        msnslpRequest.setMaxForwards(0);
        msnslpRequest.setContentType("application/x-msnmsgr-sessionreqbody");
        StringHolder stringHolder = new StringHolder();
        stringHolder.setProperty("EUF-GUID", "{A4268EEC-FEC5-49E5-95C3-F126696BDBF6}");
        stringHolder.setProperty("SessionID", this.transferSessionId);
        stringHolder.setProperty("AppID", 1);
        stringHolder.setProperty("Context", StringUtils.encodeBase64(this.msnObject.toString()));
        msnslpRequest.setBody(stringHolder.toString() + "\r\n" + "\u0000");
        int n = Charset.encodeAsByteArray(msnslpRequest.toString()).length;
        msnP2PInvitationMessage.setTotalLength(n);
        msnP2PInvitationMessage.setCurrentLength(n);
        msnP2PInvitationMessage.setAppId(0);
        this.switchboard.sendMessage(msnP2PInvitationMessage);
        log.info((Object)("Sended Invite request for retrieval of avatar for " + this.msnObject.getCreator()));
    }

    private void sendP2PAck(MsnP2PMessage msnP2PMessage, boolean bl) {
        MsnP2PAckMessage msnP2PAckMessage = new MsnP2PAckMessage(this.getNextIdentifier(), this.creator.getEmailAddress(), msnP2PMessage);
        if (bl) {
            msnP2PAckMessage.setSessionId(this.transferSessionId);
        }
        this.switchboard.sendMessage(msnP2PAckMessage);
    }

    private void sendP2PByeMessage() {
        MsnslpRequest msnslpRequest = new MsnslpRequest();
        MsnP2PByeMessage msnP2PByeMessage = new MsnP2PByeMessage();
        msnP2PByeMessage.setSlpMessage(msnslpRequest);
        this.lastRandomIdentifier = NumberUtils.getIntRandom();
        msnP2PByeMessage.setP2PDest(this.creator.getEmailAddress());
        msnP2PByeMessage.setSessionId(0);
        msnP2PByeMessage.setIdentifier(this.getNextIdentifier());
        msnP2PByeMessage.setFlag(128);
        msnP2PByeMessage.setField7(this.lastRandomIdentifier);
        msnP2PByeMessage.setField8(0);
        msnP2PByeMessage.setField9(0L);
        msnslpRequest.setRequestMethod("BYE");
        msnslpRequest.setRequestURI("MSNMSGR:" + this.creator.getEmailAddress());
        msnslpRequest.setTo("<msnmsgr:" + this.creator.getEmailAddress() + ">");
        msnslpRequest.setFrom("<msnmsgr:" + this.messenger.getOwner().getEmail().getEmailAddress() + ">");
        msnslpRequest.setVia("MSNSLP/1.0/TLP ;branch=" + this.callId);
        msnslpRequest.setCSeq(0);
        msnslpRequest.setCallId(this.callId);
        msnslpRequest.setMaxForwards(0);
        msnslpRequest.setContentType("application/x-msnmsgr-sessionclosebody");
        msnslpRequest.setBody("\r\n\u0000");
        int n = Charset.encodeAsByteArray(msnslpRequest.toString()).length;
        msnP2PByeMessage.setTotalLength(n);
        msnP2PByeMessage.setCurrentLength(n);
        msnP2PByeMessage.setAppId(0);
        this.switchboard.sendMessage(msnP2PByeMessage);
        log.info((Object)("Sended Bye request for retrieval of avatar for " + this.msnObject.getCreator()));
    }

    private void sendDirectConnectionDeny(MsnP2PInvitationMessage msnP2PInvitationMessage) {
        MsnslpMessage msnslpMessage = msnP2PInvitationMessage.getSlpMessage();
        MsnslpResponse msnslpResponse = new MsnslpResponse();
        msnslpResponse.setStatusCode(405);
        msnslpResponse.setReasonPhrase("Not supported");
        msnslpResponse.setTo(msnslpMessage.getFrom());
        msnslpResponse.setFrom(msnslpMessage.getTo());
        msnslpResponse.setVia(msnslpMessage.getVia());
        msnslpResponse.setCSeq(msnslpMessage.getCSeq() + 1);
        msnslpResponse.setCallId(msnslpMessage.getCallId());
        msnslpResponse.setMaxForwards(msnslpMessage.getMaxForwards());
        msnslpResponse.setContentType(msnslpMessage.getContentType());
        StringHolder stringHolder = new StringHolder();
        stringHolder.setProperty("SessionID", this.transferSessionId);
        msnslpResponse.setBody(stringHolder.toString() + "\r\n" + "\u0000");
        int n = Charset.encodeAsByteArray(msnslpResponse.toString()).length;
        MsnP2PSlpMessage msnP2PSlpMessage = new MsnP2PSlpMessage();
        msnP2PSlpMessage.setSlpMessage(msnslpResponse);
        msnP2PSlpMessage.setIdentifier(this.getNextIdentifier());
        msnP2PSlpMessage.setTotalLength(n);
        msnP2PSlpMessage.setCurrentLength(n);
        msnP2PSlpMessage.setField7(NumberUtils.getIntRandom());
        msnP2PSlpMessage.setP2PDest(this.creator.getEmailAddress());
        this.switchboard.sendMessage(msnP2PSlpMessage);
        log.info((Object)("Denied direct-Connection invitation for retrieval of avatar for " + this.msnObject.getCreator()));
    }

    public void switchboardStarted(MsnSwitchboard msnSwitchboard) {
        if (msnSwitchboard.getAttachment() != this) {
            return;
        }
        log.info((Object)("Switchboard started for avatar download for " + this.msnObject.getCreator()));
        this.switchboard = msnSwitchboard;
        msnSwitchboard.inviteContact(this.creator);
    }

    public void switchboardClosed(MsnSwitchboard msnSwitchboard) {
        if (msnSwitchboard.getAttachment() != this) {
            return;
        }
        this.notifyFinalization(DisplayPictureListener.ResultStatus.PROTOCOL_ERROR, 0, true);
    }

    public void contactJoinSwitchboard(MsnSwitchboard msnSwitchboard, MsnContact msnContact) {
        if (msnSwitchboard.getAttachment() != this) {
            return;
        }
        this.sendP2PInviteRequest();
    }

    public void contactLeaveSwitchboard(MsnSwitchboard msnSwitchboard, MsnContact msnContact) {
        if (msnSwitchboard.getAttachment() != this) {
            return;
        }
        this.notifyFinalization(DisplayPictureListener.ResultStatus.PROTOCOL_ERROR, 0, true);
    }

    public void p2pMessageReceived(MsnSwitchboard msnSwitchboard, MsnP2PMessage msnP2PMessage, MsnContact msnContact) {
        if (msnSwitchboard.getAttachment() != this) {
            return;
        }
        if (msnP2PMessage.getFlag() == 64) {
            if (this.state == TransferState.WAITING_BYE_ACK) {
                this.finishProcess();
            }
        } else if (msnP2PMessage.getFlag() != 4) {
            MsnP2PInvitationMessage msnP2PInvitationMessage;
            MsnslpRequest msnslpRequest;
            if (msnP2PMessage.getFlag() == 2) {
                if (this.state == TransferState.WAITING_INVITE_ACK && msnP2PMessage.getField7() == this.baseId) {
                    this.state = TransferState.WAITING_200_OK;
                } else if (this.state == TransferState.WAITING_BYE_ACK && msnP2PMessage.getField7() == this.getLastIdentifier()) {
                    this.finishProcess();
                }
            } else if (msnP2PMessage instanceof MsnP2PSlpMessage && ((MsnP2PSlpMessage)msnP2PMessage).getSlpMessage() instanceof MsnslpResponse) {
                MsnP2PSlpMessage msnP2PSlpMessage = (MsnP2PSlpMessage)msnP2PMessage;
                MsnslpResponse msnslpResponse = (MsnslpResponse)msnP2PSlpMessage.getSlpMessage();
                int n = msnslpResponse.getBodys().getIntProperty("SessionID");
                if (n == this.transferSessionId) {
                    if (msnslpResponse.getStatusCode() == 200) {
                        this.state = TransferState.WAITING_DATA_PREPARATION;
                        this.sendP2PAck(msnP2PMessage, false);
                    } else {
                        this.sendP2PByeMessage();
                        this.state = TransferState.WAITING_BYE_ACK;
                        this.notifyFinalization(DisplayPictureListener.ResultStatus.PROTOCOL_ERROR, msnP2PMessage.getFlag(), false);
                    }
                }
            } else if (msnP2PMessage instanceof MsnP2PPreperationMessage && msnP2PMessage.getSessionId() == this.transferSessionId) {
                this.state = TransferState.WAITING_DATA;
                this.sendP2PAck(msnP2PMessage, true);
            } else if (msnP2PMessage instanceof MsnP2PDataMessage && msnP2PMessage.getSessionId() == this.transferSessionId) {
                this.state = TransferState.WAITING_DATA;
                MsnP2PDataMessage msnP2PDataMessage = (MsnP2PDataMessage)msnP2PMessage;
                try {
                    if (this.buffer == null) {
                        this.buffer = new ByteArrayOutputStream();
                    }
                    byte[] byArray = msnP2PDataMessage.bodyToMessage();
                    this.buffer.write(byArray, 0, byArray.length);
                    this.receivedData += byArray.length;
                    log.info((Object)("Received data message ('" + this.receivedData + "','" + msnP2PDataMessage.getTotalLength() + "') for retrieval of avatar for " + this.msnObject.getCreator()));
                    if ((long)this.buffer.size() == msnP2PDataMessage.getTotalLength()) {
                        log.info((Object)("Finished receiving data for retrieval of avatar for " + this.msnObject.getCreator()));
                        this.buffer.close();
                        this.sendP2PAck(msnP2PMessage, true);
                        this.sendP2PByeMessage();
                        this.state = TransferState.WAITING_BYE_ACK;
                        log.info((Object)("Notifing about retrieved avatar for " + this.msnObject.getCreator()));
                        this.notifyFinalization(DisplayPictureListener.ResultStatus.GOOD, null, false);
                    }
                }
                catch (IOException iOException) {
                    this.sendP2PByeMessage();
                    this.state = TransferState.WAITING_BYE_ACK;
                    this.notifyFinalization(DisplayPictureListener.ResultStatus.FILE_ACCESS_ERROR, iOException, false);
                }
            } else if (msnP2PMessage instanceof MsnP2PInvitationMessage && (msnslpRequest = (MsnslpRequest)(msnP2PInvitationMessage = (MsnP2PInvitationMessage)msnP2PMessage).getSlpMessage()).getContentType().equals("application/x-msnmsgr-transreqbody")) {
                int n = msnslpRequest.getBodys().getIntProperty("SessionID");
                String string = msnslpRequest.getCallId();
                if (n == this.transferSessionId && string.equals(string)) {
                    this.sendP2PAck(msnP2PMessage, false);
                    this.sendDirectConnectionDeny(msnP2PInvitationMessage);
                }
            }
        }
    }

    public void controlMessageReceived(MsnSwitchboard msnSwitchboard, MsnControlMessage msnControlMessage, MsnContact msnContact) {
    }

    public void datacastMessageReceived(MsnSwitchboard msnSwitchboard, MsnDatacastMessage msnDatacastMessage, MsnContact msnContact) {
    }

    public void instantMessageReceived(MsnSwitchboard msnSwitchboard, MsnInstantMessage msnInstantMessage, MsnContact msnContact) {
    }

    public void systemMessageReceived(MsnMessenger msnMessenger, MsnSystemMessage msnSystemMessage) {
    }

    public void unknownMessageReceived(MsnSwitchboard msnSwitchboard, MsnUnknownMessage msnUnknownMessage, MsnContact msnContact) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TransferState {
        WAITING_INVITE_ACK,
        WAITING_200_OK,
        WAITING_DATA_PREPARATION,
        WAITING_DATA,
        WAITING_BYE_ACK;

    }
}

