/*
 * Decompiled with CFR 0.152.
 */
package nl.goodbytes.xmpp.xep0363;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.goodbytes.xmpp.xep0363.Repository;
import nl.goodbytes.xmpp.xep0363.Slot;
import nl.goodbytes.xmpp.xep0363.SlotManager;
import nl.goodbytes.xmpp.xep0363.TempDirectoryRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Servlet
extends HttpServlet {
    private static final Logger Log = LoggerFactory.getLogger(Servlet.class);
    private Repository repository = null;

    public static UUID uuidFromPath(String path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        String[] parts = path.split("/");
        if (parts.length < 2) {
            return null;
        }
        try {
            return UUID.fromString(parts[parts.length - 2]);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public void init(ServletConfig config) throws ServletException {
        Log.info("Initializing...");
        super.init(config);
        try {
            this.repository = new TempDirectoryRepository();
            this.repository.initialize();
        }
        catch (IOException e) {
            throw new ServletException("Unable to create temporary directory.", (Throwable)e);
        }
        Log.info("Initialized.");
    }

    public void destroy() {
        Log.info("Destroying...");
        super.destroy();
        try {
            if (this.repository != null) {
                this.repository.destroy();
            }
        }
        catch (Exception e) {
            Log.warn("Unable to destroy the repository.", (Throwable)e);
        }
        Log.info("Destroyed.");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String calculatedETagHash;
        Log.info("Processing GET request... ({} requesting from {})", (Object)req.getRemoteAddr(), (Object)req.getRequestURI());
        if (this.repository == null) {
            resp.sendError(500);
            Log.warn("... responded with INTERNAL_SERVER_ERROR. The repository is null.");
            return;
        }
        UUID uuid = Servlet.uuidFromPath(req.getRequestURI());
        if (uuid == null) {
            resp.sendError(404);
            Log.info("... responded with NOT_FOUND. Unable to parse UUID from request URI.");
            return;
        }
        if (!this.repository.contains(uuid)) {
            resp.sendError(404);
            Log.info("... responded with NOT_FOUND. The repository does not contain a path to the UUID that is parsed from request URI: {}", (Object)uuid.toString());
            return;
        }
        String eTagRequest = req.getHeader("If-None-Match");
        if (eTagRequest != null && eTagRequest.equals(calculatedETagHash = this.repository.calculateETagHash(uuid))) {
            resp.setStatus(304);
            Log.info("... responded with NOT_MODIFIED. Provided ETag value matches the hash in the repository.");
            return;
        }
        try {
            String contentType = this.repository.getContentType(uuid);
            if (contentType != null && !contentType.isEmpty()) {
                resp.setContentType(contentType);
                Log.debug("... setting content type '{}'.", (Object)contentType);
            }
        }
        catch (Exception e) {
            Log.warn("Unable to determine the content type of '{}'", (Object)uuid, (Object)e);
        }
        try {
            long size = this.repository.getSize(uuid);
            if (size > 0L && size <= Integer.MAX_VALUE) {
                resp.setContentLength((int)size);
                Log.debug("... setting content length '{}'.", (Object)size);
            }
        }
        catch (Exception e) {
            Log.warn("Unable to determine the file size of '{}'.", (Object)uuid, (Object)e);
        }
        resp.setHeader("Cache-Control", "max-age=31536000");
        resp.setHeader("ETag", this.repository.calculateETagHash(uuid));
        try (BufferedInputStream in = new BufferedInputStream(this.repository.getInputStream(uuid));
             ServletOutputStream out = resp.getOutputStream();){
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = ((InputStream)in).read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
        }
        Log.info("... responded with OK and included the data in the response body.");
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Log.info("Processing PUT request... ({} submitting to {})", (Object)req.getRemoteAddr(), (Object)req.getRequestURI());
        if (this.repository == null) {
            resp.sendError(500);
            Log.warn("... responded with INTERNAL_SERVER_ERROR. The repository is null.");
            return;
        }
        UUID uuid = Servlet.uuidFromPath(req.getRequestURI());
        if (uuid == null) {
            resp.sendError(400, "The request lacks a slot identifier on its path.");
            Log.info("... responded with BAD_REQUEST. The request lacks a slot identifier on its path.");
            return;
        }
        Slot slot = SlotManager.getInstance().consumeSlotForPut(uuid);
        if (slot == null) {
            resp.sendError(400, "The requested slot is not available. Either it does not exist, or has already been used.");
            Log.info("... responded with BAD_REQUEST. The requested slot is not available. Either it does not exist, or has already been used.");
            return;
        }
        if ((long)req.getContentLength() != slot.getSize()) {
            resp.sendError(400, "Content length in request does not correspond with slot size.");
            Log.info("... responded with BAD_REQUEST. Content length in request ({}) does not correspond with slot size ({}).", (Object)req.getContentLength(), (Object)slot.getSize());
            return;
        }
        try (ServletInputStream in = req.getInputStream();
             BufferedOutputStream out = new BufferedOutputStream(this.repository.getOutputStream(slot.getUuid()));){
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = in.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, bytesRead);
            }
        }
        resp.setHeader("Location", req.getRequestURL().toString());
        resp.setStatus(201);
        Log.info("... responded with CREATED. Stored data from the request body in the repository.");
    }
}

