/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl;

import com.hazelcast.instance.Node;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.InternalPartition;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationAccessor;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.impl.BackpressureRegulator;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.impl.operationservice.impl.operations.Backup;

final class OperationBackupHandler {
    private final Node node;
    private final OperationServiceImpl operationService;
    private final NodeEngineImpl nodeEngine;
    private final BackpressureRegulator backpressureRegulator;

    public OperationBackupHandler(OperationServiceImpl operationService) {
        this.operationService = operationService;
        this.node = operationService.node;
        this.nodeEngine = operationService.nodeEngine;
        this.backpressureRegulator = operationService.backpressureRegulator;
    }

    public int backup(BackupAwareOperation backupAwareOp) throws Exception {
        int requestedSyncBackups = this.requestedSyncBackups(backupAwareOp);
        int requestedAsyncBackups = this.requestedAsyncBackups(backupAwareOp);
        int requestedTotalBackups = this.requestedTotalBackups(backupAwareOp);
        if (requestedTotalBackups == 0) {
            return 0;
        }
        Operation op = (Operation)((Object)backupAwareOp);
        InternalPartitionService partitionService = this.node.getPartitionService();
        long[] replicaVersions = partitionService.incrementPartitionReplicaVersions(op.getPartitionId(), requestedTotalBackups);
        boolean syncForced = this.backpressureRegulator.isSyncForced(backupAwareOp);
        int syncBackups = this.syncBackups(requestedSyncBackups, requestedAsyncBackups, syncForced);
        int asyncBackups = this.asyncBackups(requestedSyncBackups, requestedAsyncBackups, syncForced);
        if (!op.returnsResponse()) {
            asyncBackups += syncBackups;
            syncBackups = 0;
        }
        return this.makeBackups(backupAwareOp, op.getPartitionId(), replicaVersions, syncBackups, asyncBackups);
    }

    int syncBackups(int requestedSyncBackups, int requestedAsyncBackups, boolean syncForced) {
        if (syncForced) {
            requestedSyncBackups += requestedAsyncBackups;
        }
        InternalPartitionService partitionService = this.node.getPartitionService();
        int maxBackupCount = partitionService.getMaxBackupCount();
        return Math.min(maxBackupCount, requestedSyncBackups);
    }

    int asyncBackups(int requestedSyncBackups, int requestedAsyncBackups, boolean syncForced) {
        if (syncForced || requestedAsyncBackups == 0) {
            return 0;
        }
        InternalPartitionService partitionService = this.node.getPartitionService();
        int maxBackupCount = partitionService.getMaxBackupCount();
        return Math.min(maxBackupCount - requestedSyncBackups, requestedAsyncBackups);
    }

    private int requestedSyncBackups(BackupAwareOperation op) {
        int backups = op.getSyncBackupCount();
        if (backups < 0) {
            throw new IllegalArgumentException("Can't create backup for Operation:" + op + ", sync backup count can't be smaller than 0, but found: " + backups);
        }
        if (backups > 6) {
            throw new IllegalArgumentException("Can't create backup for Operation:" + op + ", sync backup count can't be larger than " + 6 + ", but found: " + backups);
        }
        return backups;
    }

    private int requestedAsyncBackups(BackupAwareOperation op) {
        int backups = op.getAsyncBackupCount();
        if (backups < 0) {
            throw new IllegalArgumentException("Can't create backup for Operation:" + op + ", async backup count can't be smaller than 0, but found: " + backups);
        }
        if (backups > 6) {
            throw new IllegalArgumentException("Can't create backup for Operation:" + op + ", async backup count can't be larger than " + 6 + ", but found: " + backups);
        }
        return backups;
    }

    private int requestedTotalBackups(BackupAwareOperation op) {
        int backups = op.getSyncBackupCount() + op.getAsyncBackupCount();
        if (backups > 6) {
            throw new IllegalArgumentException("Can't create backup for Operation:" + op + ", the sum of async and sync backups is larger than " + 6 + ", sync backup count is " + op.getSyncBackupCount() + ", async backup count is " + op.getAsyncBackupCount());
        }
        return backups;
    }

    private int makeBackups(BackupAwareOperation backupAwareOp, int partitionId, long[] replicaVersions, int syncBackups, int asyncBackups) {
        int sendSyncBackups = 0;
        InternalPartitionService partitionService = this.node.getPartitionService();
        InternalPartition partition = partitionService.getPartition(partitionId);
        for (int replicaIndex = 1; replicaIndex <= syncBackups + asyncBackups; ++replicaIndex) {
            Address target = partition.getReplicaAddress(replicaIndex);
            if (target == null) continue;
            this.assertNoBackupOnPrimaryMember(partition, target);
            boolean isSyncBackup = replicaIndex <= syncBackups;
            Backup backup = this.newBackup(backupAwareOp, replicaVersions, replicaIndex, isSyncBackup);
            this.operationService.send(backup, target);
            if (!isSyncBackup) continue;
            ++sendSyncBackups;
        }
        return sendSyncBackups;
    }

    private Backup newBackup(BackupAwareOperation backupAwareOp, long[] replicaVersions, int replicaIndex, boolean isSyncBackup) {
        Operation op = (Operation)((Object)backupAwareOp);
        Operation backupOp = this.newBackupOperation(backupAwareOp, replicaIndex);
        Object backupOpData = this.nodeEngine.getSerializationService().toData(backupOp);
        Backup backup = new Backup((Data)backupOpData, op.getCallerAddress(), replicaVersions, isSyncBackup);
        backup.setPartitionId(op.getPartitionId()).setReplicaIndex(replicaIndex).setServiceName(op.getServiceName()).setCallerUuid(this.nodeEngine.getLocalMember().getUuid());
        OperationAccessor.setCallId(backup, op.getCallId());
        return backup;
    }

    private Operation newBackupOperation(BackupAwareOperation backupAwareOp, int replicaIndex) {
        Operation backupOp = backupAwareOp.getBackupOperation();
        if (backupOp == null) {
            throw new IllegalArgumentException("Backup operation should not be null! " + backupAwareOp);
        }
        Operation op = (Operation)((Object)backupAwareOp);
        backupOp.setPartitionId(op.getPartitionId()).setReplicaIndex(replicaIndex).setServiceName(op.getServiceName());
        return backupOp;
    }

    private void assertNoBackupOnPrimaryMember(InternalPartition partition, Address target) {
        if (target.equals(this.node.getThisAddress())) {
            throw new IllegalStateException("Normally shouldn't happen! Owner node and backup node are the same! " + partition);
        }
    }
}

