/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.stringprep;

import org.jivesoftware.stringprep.NFKC;
import org.jivesoftware.stringprep.RFC3454;
import org.jivesoftware.stringprep.StringprepException;

public class Stringprep {
    private static final char[] NODEPREP_PROHIBIT = new char[]{'\"', '&', '\'', '/', ':', '<', '>', '>', '@'};

    public static String nameprep(String input, boolean allowUnassigned) throws StringprepException {
        if (input == null) {
            return null;
        }
        StringBuffer s = new StringBuffer(input);
        if (allowUnassigned && Stringprep.contains(s, RFC3454.A1)) {
            throw new StringprepException(StringprepException.CONTAINS_UNASSIGNED);
        }
        Stringprep.filter(s, RFC3454.B1);
        Stringprep.map(s, RFC3454.B2search, RFC3454.B2replace);
        s = new StringBuffer(NFKC.normalizeNFKC(s.toString()));
        if (Stringprep.contains(s, RFC3454.C1_2) || Stringprep.contains(s, RFC3454.C2_2) || Stringprep.contains(s, RFC3454.C3) || Stringprep.contains(s, RFC3454.C4) || Stringprep.contains(s, RFC3454.C5) || Stringprep.contains(s, RFC3454.C6) || Stringprep.contains(s, RFC3454.C7) || Stringprep.contains(s, RFC3454.C8)) {
            throw new StringprepException(StringprepException.CONTAINS_PROHIBITED);
        }
        boolean r = Stringprep.contains(s, RFC3454.D1);
        boolean l = Stringprep.contains(s, RFC3454.D2);
        if (r && l) {
            throw new StringprepException(StringprepException.BIDI_BOTHRAL);
        }
        if (!(!r || Stringprep.contains(s.charAt(0), RFC3454.D1) && Stringprep.contains(s.charAt(s.length() - 1), RFC3454.D1))) {
            throw new StringprepException(StringprepException.BIDI_LTRAL);
        }
        return s.toString();
    }

    public static String nodeprep(String input) throws StringprepException {
        if (input == null) {
            return null;
        }
        StringBuffer s = new StringBuffer(input);
        if (Stringprep.contains(s, RFC3454.A1)) {
            throw new StringprepException(StringprepException.CONTAINS_UNASSIGNED);
        }
        Stringprep.filter(s, RFC3454.B1);
        Stringprep.map(s, RFC3454.B2search, RFC3454.B2replace);
        s = new StringBuffer(NFKC.normalizeNFKC(s.toString()));
        if (Stringprep.contains(s, RFC3454.C1_1) || Stringprep.contains(s, RFC3454.C1_2) || Stringprep.contains(s, RFC3454.C2_1) || Stringprep.contains(s, RFC3454.C2_2) || Stringprep.contains(s, RFC3454.C3) || Stringprep.contains(s, RFC3454.C4) || Stringprep.contains(s, RFC3454.C5) || Stringprep.contains(s, RFC3454.C6) || Stringprep.contains(s, RFC3454.C7) || Stringprep.contains(s, RFC3454.C8) || Stringprep.contains(s, NODEPREP_PROHIBIT)) {
            throw new StringprepException(StringprepException.CONTAINS_PROHIBITED);
        }
        boolean r = Stringprep.contains(s, RFC3454.D1);
        boolean l = Stringprep.contains(s, RFC3454.D2);
        if (r && l) {
            throw new StringprepException(StringprepException.BIDI_BOTHRAL);
        }
        if (!(!r || Stringprep.contains(s.charAt(0), RFC3454.D1) && Stringprep.contains(s.charAt(s.length() - 1), RFC3454.D1))) {
            throw new StringprepException(StringprepException.BIDI_LTRAL);
        }
        return s.toString();
    }

    public static String resourceprep(String input) throws StringprepException {
        if (input == null) {
            return null;
        }
        StringBuffer s = new StringBuffer(input);
        if (Stringprep.contains(s, RFC3454.A1)) {
            throw new StringprepException(StringprepException.CONTAINS_UNASSIGNED);
        }
        Stringprep.filter(s, RFC3454.B1);
        s = new StringBuffer(NFKC.normalizeNFKC(s.toString()));
        if (Stringprep.contains(s, RFC3454.C1_2) && Stringprep.contains(s, RFC3454.C2_1) && Stringprep.contains(s, RFC3454.C2_2) && Stringprep.contains(s, RFC3454.C3) && Stringprep.contains(s, RFC3454.C4) && Stringprep.contains(s, RFC3454.C5) && Stringprep.contains(s, RFC3454.C6) && Stringprep.contains(s, RFC3454.C7) && Stringprep.contains(s, RFC3454.C8)) {
            throw new StringprepException(StringprepException.CONTAINS_PROHIBITED);
        }
        boolean r = Stringprep.contains(s, RFC3454.D1);
        boolean l = Stringprep.contains(s, RFC3454.D2);
        if (r && l) {
            throw new StringprepException(StringprepException.BIDI_BOTHRAL);
        }
        if (!(!r || Stringprep.contains(s.charAt(0), RFC3454.D1) && Stringprep.contains(s.charAt(s.length() - 1), RFC3454.D1))) {
            throw new StringprepException(StringprepException.BIDI_LTRAL);
        }
        return s.toString();
    }

    private static boolean contains(StringBuffer s, char[] p) {
        for (int i = 0; i < p.length; ++i) {
            char c = p[i];
            for (int j = 0; j < s.length(); ++j) {
                if (c != s.charAt(j)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean contains(StringBuffer s, char[][] p) {
        for (int i = 0; i < p.length; ++i) {
            char[] r = p[i];
            if (1 == r.length) {
                char c = r[0];
                for (int j = 0; j < s.length(); ++j) {
                    if (c != s.charAt(j)) continue;
                    return true;
                }
                continue;
            }
            if (2 != r.length) continue;
            char f = r[0];
            char t = r[1];
            for (int j = 0; j < s.length(); ++j) {
                if (f > s.charAt(j) || t < s.charAt(j)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean contains(char c, char[][] p) {
        for (int i = 0; i < p.length; ++i) {
            char[] r = p[i];
            if (1 == r.length) {
                if (c != r[0]) continue;
                return true;
            }
            if (2 != r.length) continue;
            char f = r[0];
            char t = r[1];
            if (f > c || t < c) continue;
            return true;
        }
        return false;
    }

    private static void filter(StringBuffer s, char[] f) {
        for (int i = 0; i < f.length; ++i) {
            char c = f[i];
            int j = 0;
            while (j < s.length()) {
                if (c == s.charAt(j)) {
                    s.deleteCharAt(j);
                    continue;
                }
                ++j;
            }
        }
    }

    private static void filter(StringBuffer s, char[][] f) {
        for (int i = 0; i < f.length; ++i) {
            char[] r = f[i];
            if (1 == r.length) {
                char c = r[0];
                int j = 0;
                while (j < s.length()) {
                    if (c == s.charAt(j)) {
                        s.deleteCharAt(j);
                        continue;
                    }
                    ++j;
                }
                continue;
            }
            if (2 != r.length) continue;
            char from = r[0];
            char to = r[1];
            int j = 0;
            while (j < s.length()) {
                if (from <= s.charAt(j) && to >= s.charAt(j)) {
                    s.deleteCharAt(j);
                    continue;
                }
                ++j;
            }
        }
    }

    private static void map(StringBuffer s, char[] search, String[] replace) {
        for (int i = 0; i < search.length; ++i) {
            char c = search[i];
            int j = 0;
            while (j < s.length()) {
                if (c == s.charAt(j)) {
                    s.deleteCharAt(j);
                    if (null == replace[i]) continue;
                    s.insert(j, replace[i]);
                    j += replace[i].length() - 1;
                    continue;
                }
                ++j;
            }
        }
    }
}

